(function($){
	$(document).ready(function(){
		var loginform = $('.djc2-login-form');
		var btns = $('[data-toggle="djc2-login-form"]');
		btns.click(function(e){
			e.preventDefault();
			var btn = $(this);
			var itemid = btn.attr('data-id');
			if (itemid == 'undefined') return;
			
			var modal = $('#djc2-login-form-modal-' + itemid);
			if (modal.length) {
				modal.detach().appendTo($(document.body));
			}
			
			$.ajax({
				'method': 'post',
				'data': 'option=com_djcatalog2&task=accesslogin&id=' + itemid
			}).done(function(resp) {
				var json;
				try {
					json = JSON.parse(resp);
				} catch (e) {
					// do nothing
					return;
				}
				
				if (json.message && json.message != '') {
					alert(json.message);
				}
				if (json.body && json.body != '') {
					var formHtml = $(json.body);
					if (download = btn.attr('data-redirect')) {
						formHtml.find('input[name="return"]').val(download);
					}
					
					if (modal.length) {
						modal.find('.djc2-login-form-modal--body').html(formHtml);
						modal.modal();
					} else {
						// B/C - no modal
						var wrap = $('<div class="djc2-login-form--wrapper" />').html(formHtml);
						btn.parent().find('.djc2-login-form--wrapper').remove();
						btn.parent().append(wrap);
					}
				}
				if (json.redirect) {
					window.location.href = json.redirect;
				}
			});
		});
	});
})(jQuery);