<?php
/**
 * @author Joomla! Extensions Store
 * @package JSPEED::modules
 * @copyright (C) 2020 - Joomla! Extensions Store
 * @license GNU/GPLv2 http://www.gnu.org/licenses/gpl-2.0.html
 */
defined('_JEXEC') or die;

$jSpeedPlugin = ModJSpeedHelper::getPlugin();
if(is_array($jSpeedPlugin) && empty($jSpeedPlugin)) {
	echo JText::_('MOD_JSPEED_JSPEED_PLUGIN_UNPUBLISHED');
	return;
}

$pluginParams = json_decode($jSpeedPlugin->params, true);

// Compat update
if(!array_key_exists('enable_instant_page', $pluginParams)) {
	$pluginParams['enable_instant_page'] = 0;
}

$showItemsLeft = array (
		0 => array('combine_files_enable', 'flash'),
		1 => array('css_minify', 'archive'),
		2 => array('html_minify', 'archive'),
		3 => array('font_display_swap', 'dashboard'),
		4 => array('defer_combined_js', 'unblock'),
		5 => array('load_asynchronous', 'arrow-down-4'),
		6 => array('load_css_byjs', 'cogs'),
		7 => array('lazyload', 'pictures'),
		8 => array('lazyload_include_iframes', 'file'),
		9 => array('http2_push_enabled', 'link'),
		10 => array('inline_style', 'cube'),
		11 => array('enable_instant_page', 'flash'),
		12 => array('adaptive_contents_enable', 'shuffle')
);
$showItemsRight = array (
		0 => array('css', 'box-add'),
		1 => array('javascript', 'box-add'),
		2 => array('js_minify', 'archive'),
		3 => array('cache_lifetime', 'stack'),
		4 => array('defer_combined_css', 'unblock'),
		5 => array('bottom_js', 'download'),
		6 => array('load_js_byjs', 'cogs'),
		7 => array('lazyload_html_enable', 'grid'),
		8 => array('lightimgs_status', 'pictures'),
		9 => array('preload_font_face', 'arrow-up-4'),
		10 => array('inline_scripts', 'cube'),
		11 => array('defer_js', 'unblock'),
		12 => array('combinedimage_enabled', 'pictures')
);
$numRows = count($showItemsLeft);
$doc = JFactory::getDocument();
$doc->addStyleDeclaration('div.jspeed-module-title{margin-top:5px}span.jspeed-combine_files_enable{background-color:#f89406;color:#FFF;padding:2px 4px;border-radius:10px;line-height:0}span.jspeed-combine_files_enable>span{vertical-align:text-bottom}');
?>
<div class="row-striped">
	<div class="row-fluid">
		<div class="span3 jspeed-module-title">
			<?php echo JText::_('MOD_JSPEED_ACCESS_CONFIG'); ?>
		</div>
		<div class="span9">
			<a href="index.php?option=com_plugins&task=plugin.edit&extension_id=<?php echo $jSpeedPlugin->id;?>" class="btn btn-small btn-primary"><span class="icon-pencil"></span> <?php echo JText::_('MOD_JSPEED_OPEN_CONFIG'); ?></a>
		</div>
	</div>
	<?php for($i = 0;$i < $numRows; $i++):
		$leftItem = $showItemsLeft[$i];
		$rightItem = $showItemsRight[$i];
		?>
		<div class="row-fluid">
			<div class="span3">
				<span class="jspeed-<?php echo $leftItem[0];?>">
					<span class="icon-<?php echo $leftItem[1];?>" aria-hidden="true"></span> <?php echo JText::_('MOD_JSPEED_' . JString::strtoupper($leftItem[0])); ?>
				</span>
			</div>
			<div class="span3">
				<?php if(!in_array($leftItem[0], array('cache_lifetime'))):?>
					<?php $enabledClassState = $pluginParams[$leftItem[0]] ? 'success' : '';?>
					<span class="label label-<?php echo $enabledClassState;?>"><?php echo $enabledClassState ? JText::_('MOD_JSPEED_ENABLED') : JText::_('MOD_JSPEED_DISABLED');?></span>
				<?php else:?>
					<span class="label label-info"><?php echo $pluginParams[$leftItem[0]];?></span>
				<?php endif;?>
			</div>
			
			<div class="span3">
				<span class="jspeed-<?php echo $rightItem[0];?>">
					<span class="icon-<?php echo $rightItem[1];?>" aria-hidden="true"></span> <?php echo JText::_('MOD_JSPEED_' . JString::strtoupper($rightItem[0])); ?>
				</span>
			</div>
			<div class="span3">
				<?php if(!in_array($rightItem[0], array('cache_lifetime'))):?>
					<?php $enabledClassState = $pluginParams[$rightItem[0]] ? 'success' : '';?>
					<span class="label label-<?php echo $enabledClassState;?>"><?php echo $enabledClassState ? JText::_('MOD_JSPEED_ENABLED') : JText::_('MOD_JSPEED_DISABLED');?></span>
				<?php else:?>
					<span class="label label-info"><?php echo $pluginParams[$rightItem[0]];?></span>
				<?php endif;?>
			</div>
		</div>
	<?php endfor;?>
</div>