<?php
/**
* @package RSform!Pro
* @copyright (C) 2015 www.rsjoomla.com
* @license GPL, http://www.gnu.org/copyleft/gpl.html
*/

// no direct access
defined( '_JEXEC' ) or die( 'Restricted access' );

class RSFPZohoCrm {

	protected $token;
	protected $host;
	public $debug;
	
	public function __construct($token, $host) {
		$this->token = $token;
		$this->host = $host;
		
		if (empty($this->host)) {
			$this->host = 'crm.zoho.com';
		}
	}
	
	public function getFields() {
		$fields = array();
		$url	= 'https://'.$this->host.'/crm/private/json/Leads/getFields?authtoken='.$this->token.'&scope=crmapi';
		
		// Connect to URL
		$result = $this->connect($url);
		if ($result === false)
		{
			throw new Exception("Empty response from $url");
		}
		
		// Decode JSON data
		$resultFields = json_decode($result);
		if (!$resultFields)
		{
			throw new Exception("Could not decode JSON data.");
		}
		
		// We've got an error from Zoho
		if (isset($resultFields->response, $resultFields->response->error, $resultFields->response->error->message))
		{
			throw new Exception($resultFields->response->error->message);
		}
		
		if (!isset($resultFields->Leads))
		{
			throw new Exception('No Leads property returned by the ZohoCRM API.');
		}
		
		if (!isset($resultFields->Leads->section))
		{
			throw new Exception('No Leads->section property returned by the ZohoCRM API.');
		}
		
		// Get sections
		$sections = $resultFields->Leads->section;
		
		// Make sure we have an array to loop
		if (!is_array($resultFields->Leads->section))
		{
			$sections = array($sections);
		}
		
		foreach ($sections as $section)
		{
			$fields[$section->name] = array();
			
			if (isset($section->FL))
			{
				if (is_array($section->FL))
				{
					foreach ($section->FL as $field)
					{
						$fields[$section->name][] = $field;
					}
				}
				elseif (is_object($section->FL))
				{
					$fields[$section->name][] = $section->FL;
				}
			}
		}
		
		return $fields;
	}
	
	public function addLead($data) {
		$url		= 'https://'.$this->host.'/crm/private/xml/Leads/insertRecords?authtoken='.$this->token.'&scope=crmapi';
		$response	= $this->connect($url, $data);
		
		$this->parse($response);
		
		return $response;
	}
	
	protected function connect($url, $data = null) {
		if (!function_exists('curl_init')) {
			throw new Exception(JText::_('RSFP_ZOHOCRM_NO_CURL'));
		}

		// No need to initialize if we don't have a token
		if (!$this->token)
		{
			return false;
		}
		
		$ch = curl_init();
		
		curl_setopt($ch, CURLOPT_URL, $url);
		curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
		curl_setopt($ch, CURLOPT_HTTPAUTH, CURLAUTH_ANY);
		curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
		curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, false);
		curl_setopt($ch, CURLOPT_TIMEOUT, 5);
		
		if ($data) {
			curl_setopt($ch, CURLOPT_POST, 1);
			curl_setopt($ch, CURLOPT_POSTFIELDS, http_build_query($data));
		}
		
		$response = curl_exec($ch);
		
		if (curl_errno($ch)) {
			throw new Exception(curl_error($ch));
		}
		
		curl_close($ch);
		
		if (!$response) {
			throw new Exception(JText::_('RSFP_ZOHOCRM_INVALID_RESPONSE'));
		}
		
		return $response;
	}
	
	protected function parse($response) {
		$xml = simplexml_load_string($response);
		if (isset($xml->error) && isset($xml->error->message)) {
			$code = '';
			if (isset($xml->error->code)) {
				$code = 'Code '.(string) $xml->error->code.'. ';
			}
			throw new Exception($code.(string) $xml->error->message);
		}
		
		if ($this->debug && isset($xml->result) && isset($xml->result->message)) {
			JFactory::getApplication()->enqueueMessage((string) $xml->result->message);
		}
	}
}