<?php

defined('_JEXEC') or die('Restricted access');
 

class mapplicViewitem extends JViewLegacy
{

	protected $form = null;
 

	public function display($tpl = null)
	{

		$this->form = $this->get('Form');
		$this->item = $this->get('Item');
		$this->state			= $this->get('State');
 
		if (count($errors = $this->get('Errors')))
		{
			JError::raiseError(500, implode('<br />', $errors));
 
			return false;
		}
 
		$this->addToolBar();
 
		parent::display($tpl);
		$this->setDocument();
	}
 

	protected function addToolBar()
	{
		$input = JFactory::getApplication()->input;
		$input->set('hidemainmenu', true);
		$canDo = JHelperContent::getActions('com_mapplic', 'item', $this->state->get('filter.id'));
		$user  = JFactory::getUser();
 
		$isNew = ($this->item->id == 0);
 
		if ($isNew)
		{
			$title = JText::_('جدید');
		}
		else
		{
			$title = JText::_('ویرایش');
		}
 
		JToolBarHelper::title($title, 'item');
		if($user->authorise('core.create', 'com_mapplic')){
			JToolBarHelper::apply('item.apply');
			JToolbarHelper::save2copy('item.save2copy');
		}
		JToolBarHelper::cancel(
			'item.cancel',
			$isNew ? 'JTOOLBAR_CANCEL' : 'JTOOLBAR_CLOSE'
		);
	}
	
	
	protected function setDocument() 	{		
		$isNew = ($this->item->id < 1);		
		$document = JFactory::getDocument();		
		$document->setTitle($isNew ? JText::_('جدید') : JText::_('ویرایش'));	
	}	
	
}