<?php
 
// No direct access
defined('_JEXEC') or die('Restricted access');
JHtml::_('behavior.framework');
JHtml::_('behavior.formvalidator');
$doc = JFactory::getDocument();
$doc->addStyleSheet(JURI::root().'components/com_mapplic/assets/css/jquery-ui.css');
$doc->addStyleSheet(JURI::root().'components/com_mapplic/assets/css/mapplic.css');
$doc->addStyleSheet(JURI::root().'components/com_mapplic/assets/css/map.css');
$doc->addStyleSheet(JURI::root().'components/com_mapplic/assets/css/admin-style.css');
$doc->addScriptDeclaration('
	var mapplic_localization = {add:"Add", save:"Save", Search:"Search", not_found:"Nothing found. Please try a different search.", map:"Map", raw:"Raw", missing_id:"Landmark ID is required and must be unique!"};
');
$doc->addScript(JURI::root().'components/com_mapplic/assets/js/jquery-ui.js');
$doc->addScript(JURI::root().'components/com_mapplic/assets/js/color-picker.min.js');
$doc->addScript(JURI::root().'components/com_mapplic/assets/js/hammer.min.js');
$doc->addScript(JURI::root().'components/com_mapplic/assets/js/jquery.mousewheel.js');
$doc->addScript(JURI::root().'components/com_mapplic/assets/js/mapplic-admin.js');
$doc->addScript(JURI::root().'components/com_mapplic/assets/js/admin-script.js');
$doc->addStyleSheet($this->baseurl.'/media/jui/css/icomoon.css');
if($this->item->id){
$mapdata = htmlentities($this->item->data, ENT_QUOTES);
$data = json_decode($this->item->data, true);
$floors = array_reverse($data['levels']);
}
?>
<form action="<?php echo JRoute::_('index.php?option=com_mapplic&layout=edit&id=' . (int) $this->item->id); ?>"
    method="post" name="adminForm" id="adminForm">
    <div class="form-horizontal">

	<div class="row-fluid">
		<div class="span6">
			<?php foreach ($this->form->getFieldset() as $field) : ?>
				<div class="control-group">
					<div class="control-label"><?php echo $field->label; ?></div>
					<div class="controls"><?php echo $field->input; ?></div>
				</div>
			<?php endforeach; ?>
		</div>
	</div>
	
	<div class="row-fluid">
		<div class="span12">

			<div class="mapplic-rawedit">
				<label class="right"><input type="checkbox" id="mapplic-indent"></input></label>
				<textarea name="mapplic-mapdata" id="mapplic-mapdata" rows="20" spellcheck="false"><?php echo $mapdata; ?></textarea>
			</div>
			
			<?php if((int) $this->item->id){ ?>
				<script>
					jQuery(document).ready(function($) {
						$('.button-apply').attr("onclick","");											
						$('.button-save-copy').attr("onclick","");											
					});					
				</script>
				<div class="row-fluid">
					<div class="span9">
						<div id="mapplic-admin-map" data-mapdata="<?php echo $mapdata; ?>"></div>
						<input type="button" id="mapplic-editmode" class="button" value="Raw">
						<br><br>
					</div>
					
					<div class="span3">
						<div id="postbox-container-1" class="postbox-container">
							<div id="side-sortables" class="meta-box-sortables ui-sortable">

							
								<!-- Landmark -->
								<div id="landmark" class="postbox">	
									<h2 class="hndle ui-sortable-handle"><span>Landmark</span></h2>
									<div class="inside">
									<?php									
										$categories = $data['categories'];
										// Pin types
										$pins = array(
											'yellow no-fill',
											'orange no-fill',
											'green no-fill',
											'blue no-fill',
											'purple no-fill',
											'circular',
											'pin-classic pin-label',
											'pin-marker pin-label',
											'pin-disk pin-label',
											'pin-ribbon pin-label',
											'pin-dot pin-label',
											'transparent pin-md pin-label',
											'circular pin-md pin-label',
											'circular pin-md pin-pulse pin-label'
										);
										?>
										<div id="landmark-settings">
											<div>
												<input type="button" class="delete-landmark button" value="Delete">
												<input type="button" class="save-landmark button button-primary right" value="Save">
											</div>
											<div class="clear"></div>
											<hr>

											<label><strong>Title:</strong><input type="text" class="title-input "></label>
											<label><strong>ID (unique):</strong><input type="text" class="id-input "></label>
											<textarea id="descriptioninput" name="descriptioninput"></textarea>
											<div class="landmark-geolocation">
												<p><strong>Geolocation</strong></p>
												<input type="text" class="landmark-lat  geopos-field" placeholder="Latitude">
												<input type="text" class="landmark-lng  geopos-field" placeholder="Longitude">
											</div>

											<p><strong>Color and Pin Type</strong></p>
											<div>
												<ul id="pins-input">
													<li><div class="mapplic-pin hidden" data-pin="hidden">pin</div></li>
													<li class="selected"><div class="mapplic-pin default" data-pin="no-fill">pin</div></li>
												<?php foreach ($pins as &$pin) : ?>
													<li><div class="mapplic-pin <?php echo $pin; ?>" data-pin="<?php echo $pin; ?>">m</div></li>
												<?php endforeach; ?>
												</ul>
											</div>
											
											<input type="text" class="mapplic-color-picker fill-input" placeholder="#343f4b">

											<p><strong>Attributes</strong></p>
											<label>Link:<input type="text" class="link-input "></label>

											<label>Category
												<select class="category-select input-select">
													<option value="false" selected>None</option>
												<?php foreach ($categories as &$category) : ?>
													<option value="<?php echo $category['id']; ?>"><?php echo $category['title']; ?></option>
												<?php endforeach; ?>
												</select>
											</label>

											<div>
												<label>Thumbnail<br>
													<input type="text" class=" thumbnail-input buttoned" value="">
												</label>
											</div>

											<label>Action

												<select class="action-select input-select">
													<option value="default" selected>Default</option>
													<?php 
														$landmark_actions = array(
															'tooltip' => 'Tooltip',
															'open-link' => 'Open link',
															'open-link-new-tab' => 'Open link in new tab',
															'lightbox' => 'Lightbox',
															'none' => 'None', 'mapplic'
														);
														foreach ($landmark_actions as $value => $action) : 
													?>
													<option value="<?php echo $value; ?>"<?php if ($data['action'] == $value) echo ' selected'; ?>><?php echo $action; ?></option>
													<?php endforeach; ?>
												</select>
											</label>

											<label>About:<input type="text" class="about-input " placeholder="Visible in sidebar"></label>
											<label>Zoom Level<input type="text" class="zoom-input " placeholder="Auto"></label>
											<input type="button" class="duplicate-landmark button right" value="Duplicate">
										</div>
										<input type="button" id="new-landmark" class="button" value="Add New">																					
									</div>
								</div>	
								<!-- End Landmark -->
								
								<!-- floors -->
								<div id="floors" class="postbox">	
									<h2 class="hndle ui-sortable-handle"><span>Floors</span></h2>
									<div class="inside">
									
										<ul id="floor-list" class="sortable-list">
											<li class="list-item new-item">
												<div class="list-item-handle">
													<span class="menu-item-title">New Floor</span>
													<a href="#" class="menu-item-toggle"></a>
												</div>
												<div class="list-item-settings">
													<label>
														Name<br><input type="text" class=" title-input" value="New Floor">
													</label>
													<label>ID (unique)<br><input type="text" class=" id-input" value=""></label>

													<div>
														<label>Map<br>
															<input type="text" class=" map-input buttoned" value="">
														</label>
													</div>

													<div>
														<label>Minimap<br>
															<input type="text" class=" minimap-input buttoned" value="">
														</label>
													</div>

													<div>
														<a href="#" class="item-delete">Delete</a>
														<span class="meta-sep"> | </span>
														<a href="#" class="item-cancel">Cancel</a>
													</div>
												</div>
											</li>
										
										<?php foreach ($floors as &$floor) : ?>

											<li class="list-item">
												<div class="list-item-handle">
													<span class="menu-item-title"><?php echo $floor['title']; ?></span>
													<a href="#" class="menu-item-toggle"></a>
												</div>
												<div class="list-item-settings">
													<label>Name<br><input type="text" class=" title-input" value="<?php echo $floor['title']; ?>"></label>
													<label>ID (unique)<br><input type="text" class=" id-input" value="<?php echo $floor['id']; ?>" disabled></label>

													<?php $shown = (isset($floor['show']) && ($floor['show'] == 'true')) ? 'checked' : ''; ?>
													<label>
														<input type="radio" name="shown-floor" class="show-input" <?php echo $shown; ?> value="<?php echo $floor['id']; ?>"> Show by default
													</label>

													<div>
														<label>Map<br>
															<input type="text" class=" map-input buttoned" value="<?php echo $floor['map']; ?>">
															<button class="button media-button"><span class="dashicons dashicons-upload"></span></button>
														</label>
													</div>

													<div>
														<label>Minimap<br>
															<input type="text" class=" minimap-input buttoned" value="<?php echo $floor['minimap']; ?>">
															<button class="button media-button"><span class="dashicons dashicons-upload"></span></button>
														</label>
													</div>

													<div>
														<a href="#" class="item-delete">Delete</a>
														<span class="meta-sep"> | </span>
														<a href="#" class="item-cancel">Cancel</a>
													</div>
												</div>
											</li>

										<?php endforeach; ?>
										</ul>
										<input type="button" id="new-floor" class="button" value="New Floor">
										<div class="clear"></div>							
									
									</div>
								</div>	
								<!-- end floors -->
								
								
								<!-- Categories -->
								<div id="categories" class="postbox">	
									<h2 class="hndle ui-sortable-handle"><span>Categories</span></h2>
									<div class="inside">
										<ul id="category-list" class="sortable-list">
											<li class="list-item new-item">
												<div class="list-item-handle">
													<span class="menu-item-title">New Category</span>
													<a href="#" class="menu-item-toggle"></a>
												</div>
												<div class="list-item-settings">

													<label>
														Name<br><input type="text" class=" title-input" value="New Category">
													</label>
													<label>ID (unique)<br><input type="text" class=" id-input" value=""></label>
													<label><input type="checkbox" class="expand-input" checked> Expand by default</label>

													<div>
														<a href="#" class="item-delete">Delete</a>
														<span class="meta-sep"> | </span>
														<a href="#" class="item-cancel">Cancel</a>
													</div>
												</div>
											</li>
										<?php foreach ($data['categories'] as &$category) : ?>
											<li class="list-item">
												<div class="list-item-handle">
													<span class="menu-item-title"><?php echo $category['title']; ?></span>
													<a href="#" class="menu-item-toggle"></a>
												</div>
												<div class="list-item-settings">

													<label>Name<br><input type="text" class=" title-input" value="<?php echo $category['title']; ?>"></label>
													<label>ID (unique)<br><input type="text" class=" id-input" value="<?php echo $category['id']; ?>"></label>
													<?php $shown = (isset($category['show']) && ($category['show'] == 'false')) ? '' : 'checked'; ?>
													<label><input type="checkbox" class="expand-input" <?php echo $shown; ?>> Expand by default</label>
													<input type="text" value="<?php echo $category['color']; ?>" class="mapplic-color-picker color-input" data-default-color="#666666">

													<div>
														<a href="#" class="item-delete">Delete</a>
														<span class="meta-sep"> | </span>
														<a href="#" class="item-cancel">Cancel</a>
													</div>
												</div>
											</li>
										<?php endforeach; ?>
										</ul>
										<input type="button" id="new-category" class="button" value="New Category">												
									</div>
								</div>	
								<!-- End Categories -->
								
								<!-- Categories -->
								<div id="geoposition" class="postbox">	
									<h2 class="hndle ui-sortable-handle"><span>Geoposition</span></h2>
									<div class="inside">
										<div id="geopos">
											<div class="geopos-corner tl"></div>
											<input type="text" class="geopos-field" id="topLat" placeholder="Top Latitude" value="<?php mapplicHelper::mplc_field($data['topLat']); ?>">
											<div class="geopos-corner tr"></div><br>
											<input type="text" class="geopos-field" id="leftLng" placeholder="Left Longitude" value="<?php mapplicHelper::mplc_field($data['leftLng']); ?>">
											<input type="text" class="geopos-field" id="rightLng" placeholder="Right Longitude" value="<?php mapplicHelper::mplc_field($data['rightLng']); ?>">
											<br><div class="geopos-corner bl"></div>
											<input type="text" class="geopos-field" id="bottomLat" placeholder="Bottom Latitude" value="<?php mapplicHelper::mplc_field($data['bottomLat']); ?>">
											<div class="geopos-corner br"></div>
										</div>							
									</div>
								</div>	
								
							</div>
						</div>
					</div>
				</div>
				
				<div class="row-fluid">
					<div class="span12">
						<div id="postbox-container-2" class="postbox-container">
							<div id="settings" class="postbox">
								<h2 class="hndle ui-sortable-handle"><span>Settings</span></h2>
								<div class="inside">
								<?php if (!is_numeric($data['mapwidth']) || !is_numeric($data['mapheight'])) : ?>
									<div class="notice notice-error">
										<p>Map file dimensions either not set or invalid!</p>
									</div>
								<?php endif; ?>	
								<h4>Map file Dimensions (REQUIRED)</h4>
								<label>
									Map Width<br>
									<input type="text" id="setting-mapwidth" value="<?php echo $data['mapwidth']; ?>" placeholder="REQUIRED"><span> px</span>
								</label>
								<label>
									Map Height<br>
									<input type="text" id="setting-mapheight" value="<?php echo $data['mapheight']; ?>" placeholder="REQUIRED"><span> px</span>
								</label>

								<!-- Components -->
								<h4>Features</h4>
								<label>
									<input type="checkbox" id="setting-minimap"<?php mapplicHelper::mplc_field($data['minimap'], 'true', ' checked', ''); ?>> Minimap
								</label>
								<label>
									<input type="checkbox" id="setting-clearbutton"<?php mapplicHelper::mplc_field($data['clearbutton'], 'true', ' checked', ''); ?>> Clear button
								</label>
								<label>
									<input type="checkbox" id="setting-zoombuttons"<?php mapplicHelper::mplc_field($data['zoombuttons'], 'true', ' checked', ''); ?>> Zoom buttons
								</label>
								<label>
									<input type="checkbox" id="setting-hovertip"<?php mapplicHelper::mplc_field($data['hovertip'], 'true', ' checked', ''); ?>> Hover Tooltip
								</label>
								<label>
									<input type="checkbox" id="setting-fullscreen"<?php mapplicHelper::mplc_field($data['fullscreen'], 'true', ' checked', ''); ?>> Fullscreen
								</label>
								<label>
									<input type="checkbox" id="setting-deeplinking"<?php mapplicHelper::mplc_field($data['deeplinking'], 'true', ' checked', ''); ?>> Deeplinking
								</label>
								<label>
									<input type="checkbox" id="setting-zoomoutclose"<?php mapplicHelper::mplc_field($data['zoomoutclose'], 'true', ' checked', ''); ?>> Zoom out on closing popup
								</label>

								<!-- Sidebar -->
								<h4>Sidebar</h4>
								<label>
									<input type="checkbox" id="setting-sidebar"<?php mapplicHelper::mplc_field($data['sidebar'], 'true', ' checked', ''); ?>> Sidebar
								</label>
								<label>
									<input type="checkbox" id="setting-alphabetic"<?php mapplicHelper::mplc_field($data['alphabetic'], 'true', ' checked', ''); ?>> Alphabetically ordered
								</label>
								<label>
									<input type="checkbox" id="setting-search"<?php mapplicHelper::mplc_field($data['search'], 'true', ' checked', ''); ?>> Search
								</label>

								<!-- General -->
								<h4>General Settings</h4>
								<label>
									<input type="checkbox" id="setting-zoom"<?php mapplicHelper::mplc_field($data['zoom'], false, '', ' checked'); ?>> Enable zoom
								</label>
								<label>
									<input type="checkbox" id="setting-mousewheel"<?php mapplicHelper::mplc_field($data['mousewheel'], 'true', ' checked', ''); ?>> Mouse wheel
								</label>
								<label>
									<input type="checkbox" id="setting-mapfill"<?php mapplicHelper::mplc_field($data['mapfill'], 'true', ' checked', ''); ?>> Map fills the container
								</label>
								<label>
									Zoom Limit<br>
									<input type="text" id="setting-zoomlimit" value="<?php echo $data['zoomlimit']; ?>" placeholder="No zoom">
								</label>
								<label>Default Action<br>
									<select id="setting-action">
										<?php
											$landmark_actions = array(
												'tooltip' => 'Tooltip',
												'open-link' => 'Open link',
												'open-link-new-tab' => 'Open link in new tab',
												'lightbox' => 'Lightbox',
												'none' => 'None'
											);
											foreach ($landmark_actions as $value => $action) : 
										?>
										<option value="<?php echo $value; ?>"<?php if ($data['action'] == $value) echo ' selected'; ?>><?php echo $action; ?></option>
										<?php endforeach; ?>
									</select>
								</label>
								<label>
									Default Fill Color<br>
									<input type="text" id="setting-fillcolor" class="mapplic-color-picker" data-default-color="#343f4b" value="<?php mapplicHelper::mplc_field($data['fillcolor']); ?>">
								</label>
								
								</div>
							</div>
						</div>
					</div>
				</div>
								
			<?php } else {
			
				$maps = array(
					'world' 		=> 'World',
					'continents' 	=> 'Continents',
					'europe' 		=> 'Europe',
					'usa' 			=> 'USA',
					'canada' 		=> 'Canada',
					'australia' 	=> 'Australia',
					'france' 		=> 'France',
					'germany' 		=> 'Germany',
					'uk' 			=> 'United Kingdom',
					'italy' 		=> 'Italy',
					'netherlands' 	=> 'Netherlands',
					'switzerland' 	=> 'Switzerland',
					'russia' 		=> 'Russia',
					'china' 		=> 'China',
					'brazil' 		=> 'Brazil'
				); ?>
				
				<h3>Select Map Type</h3>
				<p>Create a custom map using your own file(s) or select one of the built-in maps.</p>
				<select id="mapplic-new-type" name="new-map-type">
					<option value="custom">Custom</option>
				<?php foreach ($maps as $key => $map) : ?>
					<option value="<?php echo $key; ?>"><?php echo $map; ?></option>
				<?php endforeach; ?>
				</select>
				<br><br>

				<div id="mapplic-mapfile">
					<h3>Define Map File</h3>
					<p>Upload or select map file from library. SVG, JPG and PNG formats supported.</p>
					<label class="field-small">
						<b>Name</b><br>
						<input type="text" name="new-map-name" class="title-input" value="My Map">
					</label>
					<label class="field-small">
						<b>ID (required)</b><br>
						<input type="text" name="new-map-id" class="id-input" value="my-map">
					</label>

					<label class="field-small">
						<b>Width (reqiured)</b><br>
						<input type="text" name="new-mapwidth"  value="">
					</label>
					<label class="field-small">
						<b>Height (reqiured)</b><br>
						<input type="text" name="new-mapheight" value="">
					</label>
				</div>				

			<?php } ?>
		</div>
	</div>	
	
    </div>
    <input type="hidden" name="task" value="item.edit" />
    <?php echo JHtml::_('form.token'); ?>
</form>
