<?php
/**
 * @author Joomla! Extensions Store
 * @package JSPEED::plugins::system
 * @copyright (C) 2020 - Joomla! Extensions Store
 * @license GNU/GPLv2 http://www.gnu.org/licenses/gpl-2.0.html
 */
defined ( '_JEXEC' ) or die ();

include_once JPATH_PLUGINS . '/system/jspeed/framework/loader.php';

if (! defined ( 'JSPEED_VERSION' )) {
	$currentVersion = strval ( simplexml_load_file ( JPATH_ROOT . '/plugins/system/jspeed/jspeed.xml' )->version );
	define ( 'JSPEED_VERSION', $currentVersion );
}

$app = JFactory::getApplication ();

$action = $app->input->get ( 'task', '', 'string' );

if (! $action) {
	exit ();
}

try {
	$results = JSpeedAjaxHelper::$action ();
} catch ( Exception $e ) {
	$results = $e;
}

if (is_scalar ( $results ) || is_object ( $results )) {
	$out = ( string ) $results;
} else {
	$out = implode ( ( array ) $results );
}

echo $out;
class JSpeedAjaxHelper {
	/**
	 */
	public static function garbagecron() {
		return JSpeedAjax::garbageCron ( JSpeedSettings::getInstance ( $this->params ) );
	}

	/**
	 */
	public static function exclusionfiles() {
		$aData = JSpeedUtilities::get ( 'data', '', 'array' );

		$params = JSpeedPlugin::getPluginParams ();
		$oAdmin = new JSpeedAdmin ( $params, true );
		$oHtml = new JSpeedHTML ( $params );

		try {
			$sHtml = $oHtml->getOriginalHtml ();
			$oAdmin->getAdminLinks ( $sHtml );
		} catch ( Exception $e ) {
		}

		$response = array ();

		if(!empty($aData)) {
			foreach ( $aData as $sData ) {
				$options = $oAdmin->prepareFieldOptions ( $sData ['type'], $sData ['param'], $sData ['group'], false );
				$response [$sData ['id']] = new JSpeedJsonManager ( $options );
			}
		}

		return new JSpeedJsonManager ( $response );
	}
}

jexit ();
