<?php
/**
 * @package HideMyJoomla
 * @author Yusuf Uygun
 * @copyright (C) 2014 Yusuf Uygun
 * @license license GNU General Public License Version 2
 **/

// No direct access
defined( '_JEXEC' ) or die( 'Restricted access' );

jimport( 'joomla.application.component.view' );
jimport('joomla.html.pane');

class hidemyjoomlaViewBasic extends JViewLegacy {
	protected $form;
	protected $item;
	protected $state;
	
	function display($tpl=null){

		$this->form		= $this->get('Form');
		$this->item		= $this->get('Item');
		$this->state	= $this->get('State');

		$basepath   = JPATH_ADMINISTRATOR .'/components/com_hidemyjoomla';
		$configFile	= $basepath.'/params.php';
		require_once($configFile);
		$HidemyjoomlaConfig = new HidemyjoomlaConfig();
		
		$this->assignRef('HidemyjoomlaConfig',$HidemyjoomlaConfig);
		

		$this->addToolbar();
				
		parent::display($tpl);
	}

    protected function addToolbar() {
        JToolBarHelper::title(JText::_('COM_HIDE_MY_JOOMLA'), 'generic.png');
        JToolBarHelper::apply('saveBasic');
        JToolBarHelper::preferences('com_hidemyjoomla');
	}

	function save(){
		$app = &JFactory::getApplication();
	    $msg  = 'Details Has Been Saved';
		$result = $this->saveDetails();
 		if($result){
 			$link = 'index.php?option=com_hidemyjoomla&task=basic';
 			$msg  = 'Details Has Been Saved';
 			$app->redirect($link,JFactory::getApplication()->enqueueMessage($msg));
 	    }
 	}
 	
 	function saveDetails(){
		jimport('joomla.filesystem.file');	
		$app           =& JFactory::getApplication();
		$option		= JRequest::getVar('option', '', '', 'cmd');
		$post       = JRequest::get( 'post' );
		$basepath   = JPATH_ADMINISTRATOR .'/components/com_hidemyjoomla';
		$configFile	= $basepath.'/params.php';
		$xml	    = $basepath.'/com_hidemyjoomla.xml';
		require_once($configFile);
		
		if(!is_writable($configFile)){
			$link = "index.php?option=com_hidemyjoomla";
			$msg = 'Configuration File is Not Writable /administrator/components/com_hidemyjoomla/params.php ';
			$app->redirect($link, JError::raiseWarning( 100, $msg ));
			exit();
		}

		// Read the ini file
		if (JFile::exists($configFile)) {
			$content = JFile::read($configFile);
		} else {
			$content = null;
		}

		$config = new JRegistry('HidemyjoomlaConfig');
		$oldValue = new HidemyjoomlaConfig();

		$config_array = array();
		$config_array['publish']	                    = JRequest::getVar('administrator_publish', 0, 'post', 'int');
        $config_array['administrator_publish']	        = JRequest::getVar('administrator_publish', 0, 'post', 'int');
		$config_array['com_users_publish']	            = JRequest::getVar('com_users_publish', 0, 'post', 'int');
		$config_array['template_publish']	            = JRequest::getVar('template_publish', 0, 'post', 'int');
		$config_array['component_publish']	            = JRequest::getVar('component_publish', 0, 'post', 'int');
		$config_array['modules_publish']	            = JRequest::getVar('modules_publish', 0, 'post', 'int');
		$config_array['plugins_publish']	            = JRequest::getVar('plugins_publish', 0, 'post', 'int');
		$config_array['media_publish']	                = JRequest::getVar('media_publish', 0, 'post', 'int');
        $config_array['key']                            = JRequest::getVar('key', '', 'post', 'string');
        $config_array['keyword']                        = JRequest::getVar('keyword', '', 'post', 'string');
		$config_array['passkeytype']	                = JRequest::getVar('passkeytype', 'url', 'post', 'string');
		$config_array['options']                        = JRequest::getVar('options', 0, 'post', 'string');
		$config_array['custom_path']				    = JRequest::getVar('custom_path', '', 'post', 'string');
        $config_array['generator']                      = JRequest::getVar('generator', '', 'post', 'string');
        $config_array['template']                       = JRequest::getVar('template', '', 'post', 'string');
        $config_array['components']                     = JRequest::getVar('components', '', 'post', 'string');
        $config_array['modules']                        = JRequest::getVar('modules', '', 'post', 'string');
        $config_array['plugins']                        = JRequest::getVar('plugins', '', 'post', 'string');
        $config_array['media']                          = JRequest::getVar('media', '', 'post', 'string');
              
		
		if($config_array['key'] == ''){
			$config_array['key'] = $oldValue->key;			
		} else {
			$keyvalue = $config_array['key'];
		}

		if($config_array['administrator_publish']	== 1){
			$session    =& JFactory::getSession();
			$session->set('HidemyjoomlaAuthentication', 1);
		}
		
		$config->loadArray($config_array);
		$fname = JPATH_COMPONENT_ADMINISTRATOR.'/'.'params.php';

		if (JFile::write($fname, $config->toString('PHP', array('class' => 'HidemyjoomlaConfig','closingtag' => false)))){
            $file = file_get_contents($configFile);
            $file = str_replace("<?php", "<?php \ndefined( '_JEXEC' ) or die( 'Restricted access' );", $file);
            JFile::write($configFile, $file);
            $file1 = str_replace("<?php", "<?php \n/**\n * @package HideMyJoomla\n * @author Yusuf Uygun\n * @copyright (C) 2014 Yusuf Uygun\n * @license license GNU General Public License Version 2\n **/\n", $file);
            JFile::write($configFile, $file1);
			$msg = JText::_('COM_HIDEMYJOOMLA_UPDATED_CONFIG');
        }else{
			$msg = JText::_('COM_HIDEMYJOOMLA_ERROR_CONFIG');
        }
        $file = JPATH_ROOT .'/.htaccess';
        $dest = $basepath .'/htaccess.txt';
        JFile::copy($dest, $file);
		
		return true;
 	}
}