<?php
/* ======================================================
 # Fix 404 Error Links for Joomla! - v2.2.5 (pro version)
 # -------------------------------------------------------
 # For Joomla! CMS (v3.x)
 # Author: Web357 (Yiannis Christodoulou)
 # Copyright (©) 2014-2022 Web357. All rights reserved.
 # License: GNU/GPLv3, http://www.gnu.org/licenses/gpl-3.0.html
 # Website: https:/www.web357.com
 # Demo: https://demo.web357.com/joomla/fix-404-error-links
 # Support: support@web357.com
 # Last modified: Thursday 08 June 2023, 01:53:23 AM
 ========================================================= */
defined('_JEXEC') or die;
use Joomla\CMS\Factory;

JHtml::addIncludePath(JPATH_COMPONENT . '/helpers/');
JHtml::_('behavior.multiselect');

if (version_compare(JVERSION, '4.0', 'lt')) {
    JHtml::_('bootstrap.tooltip');
	JHtml::_('formbehavior.chosen', 'select');
}

$user      = Factory::getUser();
$userId    = $user->get('id');
$listOrder = $this->state->get('list.ordering');
$listDirn  = $this->state->get('list.direction');
$canOrder  = $user->authorise('core.edit.state', 'com_fix404errorlinks');
$saveOrder = $listOrder == 'a.ordering';

if ($saveOrder)
{
	$saveOrderingUrl = 'index.php?option=com_fix404errorlinks&task=redirects.saveOrderAjax&tmpl=component';
	JHtml::_('sortablelist.sortable', 'redirectList', 'adminForm', strtolower($listDirn), $saveOrderingUrl);
}

$sortFields = $this->getSortFields();
?>

<script type="text/javascript">
Joomla.submitbutton = function(task)
{
	if (task == 'redirects.comRedirectImport')
	{
		var confirm_import_from_com_redirects = confirm("<?php echo JText::_('COM_FIX404ERRORLINKS_COMREDIRECT_IMPORT_CONFIRM_ALERT_MSG'); ?>")
		if (confirm_import_from_com_redirects)
		{
			Joomla.submitform(task);
		}
		else
		{
			return false;
		}
	}
	else
	{
		Joomla.submitform(task);
	}
}
</script>

<?php if (!empty($this->sidebar) && version_compare(JVERSION, '4.0', 'lt')): ?>
<div id="j-sidebar-container" class="span2 col-2">
    <?php echo $this->sidebar; ?>
</div>
<div id="j-main-container" class="span10 col-10">
    <?php else : ?>
    <div id="j-main-container">
        <?php endif; ?>
        <form action="<?php echo JRoute::_('index.php?option=com_fix404errorlinks&view=redirects'); ?>" method="post"
            name="adminForm" id="adminForm">

            <?php echo JLayoutHelper::render('joomla.searchtools.default', array('view' => $this)); ?>

            <div class="clearfix"></div>
            <table class="table table-striped" id="redirectList">
                <thead>
                    <tr>
                        <?php if (isset($this->items[0]->ordering)): ?>
                        <th width="1%" class="nowrap center hidden-phone">
                            <?php echo JHtml::_('searchtools.sort', '', 'a.ordering', $listDirn, $listOrder, null, 'asc', 'JGRID_HEADING_ORDERING', 'icon-menu-2'); ?>
                        </th>
                        <?php endif; ?>
                        <th width="1%" class="hidden-phone">
                            <input type="checkbox" name="checkall-toggle" value="" title="<?php echo JText::_('JGLOBAL_CHECK_ALL'); ?>"
                                onclick="Joomla.checkAll(this)" />
                        </th>
                        <?php if (isset($this->items[0]->state)): ?>
                        <th width="1%" class="nowrap center">
                            <?php echo JHtml::_('searchtools.sort', 'JSTATUS', 'a.state', $listDirn, $listOrder); ?>
                        </th>
                        <?php endif; ?>

                        <th>
                            <?php echo JText::_('#'); ?>
                        </th>
                        <th>
                            <?php echo JText::_('Actions'); ?>
                        </th>
                        <th>
                            <?php echo JHtml::_('searchtools.sort',  'COM_FIX404ERRORLINKS_SOURCE_URL_HEADING', 'a.source_url', $listDirn, $listOrder); ?>
                        </th>
                        <th>
                            <?php echo JHtml::_('searchtools.sort',  'COM_FIX404ERRORLINKS_TARGET_URL_HEADING', 'a.target_url', $listDirn, $listOrder); ?>
                        </th>
                        <th class="center">
                            <?php echo JHtml::_('searchtools.sort',  'COM_FIX404ERRORLINKS_HITS_HEADING', 'a.hits', $listDirn, $listOrder); ?>
                        </th>
                        <th class="center">
                            <?php echo JHtml::_('searchtools.sort',  'COM_FIX404ERRORLINKS_LAST_ACCESS_HEADING', 'a.last_access', $listDirn, $listOrder); ?>
                        </th>
                        <th class="center">
                            <?php echo JHtml::_('searchtools.sort',  'COM_FIX404ERRORLINKS_NOTES_HEADING', 'a.notes', $listDirn, $listOrder); ?>
                        </th>
                        <th class="center">
                            <?php echo JHtml::_('searchtools.sort',  'COM_FIX404ERRORLINKS_ID', 'a.id', $listDirn, $listOrder); ?>
                        </th>
                    </tr>
                </thead>
                <tfoot>
                    <tr>
                        <td colspan="<?php echo isset($this->items[0]) ? count(get_object_vars($this->items[0])) : 10; ?>">
                            <?php echo $this->pagination->getListFooter(); ?>
                        </td>
                    </tr>
                </tfoot>

                <tbody>
                    <?php foreach ($this->items as $i => $item) :
					$ordering   = ($listOrder == 'a.ordering');
					$canCreate  = $user->authorise('core.create', 'com_fix404errorlinks');
					$canEdit    = $user->authorise('core.edit', 'com_fix404errorlinks');
					$canCheckin = $user->authorise('core.manage', 'com_fix404errorlinks');
					$canChange  = $user->authorise('core.edit.state', 'com_fix404errorlinks');
					?>
                    <tr class="row<?php echo $i % 2; ?>">

                        <?php if (isset($this->items[0]->ordering)) : ?>
                        <td class="order nowrap center hidden-phone">
                            <?php if ($canChange) :
									$disableClassName = '';
									$disabledLabel    = '';

									if (!$saveOrder) :
										$disabledLabel    = JText::_('JORDERINGDISABLED');
										$disableClassName = 'inactive tip-top';
									endif; ?>
                            <span class="sortable-handler hasTooltip <?php echo $disableClassName ?>" title="<?php echo $disabledLabel ?>">
                                <i class="icon-menu"></i>
                            </span>
                            <input type="text" style="display:none" name="order[]" size="5" value="<?php echo $item->ordering; ?>"
                                class="width-20 text-area-order " />
                            <?php else : ?>
                            <span class="sortable-handler inactive">
                                <i class="icon-menu"></i>
                            </span>
                            <?php endif; ?>
                        </td>
                        <?php endif; ?>

                        <td class="hidden-phone">
                            <?php echo JHtml::_('grid.id', $i, $item->id); ?>
                        </td>

                        <?php if (isset($this->items[0]->state)): ?>
                        <td class="center">
                            <?php echo JHtml::_('jgrid.published', $item->state, $i, 'redirects.', $canChange, 'cb'); ?>

                        </td>
                        <?php endif; ?>

                        <td>
                            <?php echo $this->pagination->getRowOffset($i); ?>
                        </td>

                        <td>
                        <?php if ($canEdit) : ?>
                            <a href="<?php echo JRoute::_('index.php?option=com_fix404errorlinks&task=redirect.edit&id='.(int) $item->id); ?>" title="<?php echo JText::_('COM_FIX404ERRORLINKS_EDIT'); ?>" class="btn btn-small btn-sm btn-warning"><?php echo JText::_('COM_FIX404ERRORLINKS_EDIT'); ?></a>
                        <?php else : ?>
                            <?php echo JText::_('COM_FIX404ERRORLINKS_NO_ACCESS_TO_EDIT'); ?>
                        <?php endif; ?>
                        </td>
                        
                        <td>
                            <small style="margin-right: 5px;">
                                <span class="hasTooltip dottedUnderline" title="<?php echo JText::_('COM_FIX404ERRORLINKS_MATCH_TYPE_LBL'); ?>">
                                <?php echo JText::_('COM_FIX404ERRORLINKS_'.strtoupper($item->match_type)); ?>
                                <?php if ($item->regex): ?>
                                    (<?php echo JText::_('COM_FIX404ERRORLINKS_REGEX'); ?>)
                                <?php endif; ?>
                                </span>
                            </small>
                            
                            <?php 
                            if (strpos($item->source_url, Fix404errorlinksHelper::idnToAscii(str_replace('administrator/', '', JURI::base()))) !== false)
                            {
                                $item_source_url = $item->source_url;
                            }
                            else
                            {
                                $item_source_url = str_replace('administrator', '', JURI::base(true)) . '' . $this->escape($item->source_url);
                            }

                            switch ($item->match_type) 
                            {
                                case 'full_url':
                                    $source_url = $item_source_url;
                                    $source_url_txt = str_replace('administrator', '', $this->escape($item->source_url));
									$link = true;
                                    break;
                                case 'contains_string':
                                    $source_url = $item_source_url;
                                    $source_url_txt = str_replace('administrator', '', $this->escape($item->source_url));
									$link = true;
                                    break;
                                case 'start_with':
                                    $source_url = $item_source_url;
                                    $source_url_txt = str_replace('administrator', '', $this->escape($item->source_url));
									$link = true;
                                    break;
                                case 'end_with':
                                    $source_url = $item_source_url;
                                    $source_url_txt = str_replace('administrator', '', $this->escape($item->source_url));
									$link = true;
                                    break;
                                case 'find_and_replace':
                                    $source_url = $item_source_url;
                                    $source_url_txt = str_replace('administrator', '', $this->escape($item->source_url));
									$link = false;
                                    break;
                                default:
                                    $source_url = $item_source_url;
                                    $source_url_txt = str_replace('administrator', '', $this->escape($item->source_url));
									$link = true;
                                    break;
                            }
                            
                            // IDN Character Set Support
                            $source_url = Fix404errorlinksHelper::idnToUtf8($source_url);
                            $source_url = htmlentities($source_url, ENT_COMPAT, 'UTF-8');
                            $source_url_txt = Fix404errorlinksHelper::idnToUtf8($source_url_txt);
                            $source_url_txt = htmlentities($source_url_txt, ENT_COMPAT, 'UTF-8');
                            ?>

                            <?php if ($link): ?>
                            <a href="<?php echo $source_url; ?>" title="<?php echo $source_url; ?>" target="_blank" rel="noopener noreferrer">
                            <?php endif; ?>
                                <?php echo Web357Framework\Functions::shortenURL($source_url_txt, 100); ?>
                            <?php if ($link): ?>
                            <img src="components/com_fix404errorlinks/assets/icons/open_link.png" alt="link" width="9" height="9" />
                            </a>
                            <?php endif; ?>
                            
                        </td>

                        <td>
                            <?php if ($item->action_type == 'redirect_to_menu_item' || $item->action_type == 'redirect_to_url'): ?>
                                         
                                <?php if(substr($item->action_code, 0, 1) == 3) : ?>
                                    <span class="label label-success badge bg-success hasTooltip" style="margin-left: 10px; margin-right: 5px;" title="<?php echo JText::_('COM_FIX404ERRORLINKS_ACTION_TYPE_'.strtoupper($item->action_type)); ?> <?php echo JText::_('COM_FIX404ERRORLINKS_WITH'); ?> <?php echo $item->action_code; ?> <?php echo JText::_('COM_FIX404ERRORLINKS_HTTP_CODE'); ?>">
                                        <?php echo $item->action_code; ?>
                                    </span>
                                <?php elseif(substr($item->action_code, 0, 1) == 4) : ?>
                                    <span class="label label-important badge bg-danger hasTooltip" style="margin-left: 10px; margin-right: 5px;" title="<?php echo JText::_('COM_FIX404ERRORLINKS_ACTION_TYPE_'.strtoupper($item->action_type)); ?> <?php echo JText::_('COM_FIX404ERRORLINKS_WITH'); ?> <?php echo $item->action_code; ?> <?php echo JText::_('COM_FIX404ERRORLINKS_HTTP_CODE'); ?>">
                                        <?php echo $item->action_code; ?>
                                    </span>
                                <?php else: ?>
                                    <span class="label label-important badge bg-danger hasTooltip" style="margin-left: 10px; margin-right: 5px;" title="<?php echo $item->action_type; ?> <?php echo JText::_('COM_FIX404ERRORLINKS_WITH'); ?> <?php echo $item->action_code; ?> <?php echo JText::_('COM_FIX404ERRORLINKS_HTTP_CODE'); ?>">
                                        <?php echo $item->action_code; ?>
                                    </span>
                                <?php endif; ?>

                                <?php 
                                if ($item->action_type == 'redirect_to_menu_item')
                                {
                                    $url = $this->router->build('index.php?Itemid=' . intval($item->target_url));
                                    $url = $url->toString();
                                    $target_url = str_replace($this->live_site .'/administrator', $this->live_site, $url);
                                    $target_url_txt = str_replace(str_replace('/administrator', '', JURI::base(true)), '', $url);
                                }
                                else 
                                {
                                    if (strpos($item->target_url,'http') !== false)
                                    {
                                        $target_url = $item->target_url;
                                    }
                                    elseif (strpos($item->target_url,'www') !== false)
                                    {
                                        $target_url = 'http://'.$item->target_url;
                                    }
                                    else
                                    {
                                        $target_url = str_replace('administrator', '', JURI::base(true)).$this->escape($item->target_url);
                                    }
                                    
                                    $target_url_txt = (strpos($item->target_url,'http') !== false || strpos($item->target_url,'www') !== false) ? $item->target_url : "/".$this->escape($item->target_url);
                                }
                                ?>
 
                                <a href="<?php echo $target_url; ?>" target="_blank" rel="noopener noreferrer">
    							    <strong><?php echo Web357Framework\Functions::shortenURL($target_url_txt, 100); ?></strong> 
                                    <img src="components/com_fix404errorlinks/assets/icons/open_link.png" alt="open link" width="9" height="9" />
                                </a>

                            <?php elseif ($item->action_type == 'error_404'): ?>

                                <span class="label label-important badge bg-danger hasTooltip" title="<?php echo JText::_('COM_FIX404ERRORLINKS_REDIRECT_TO_AN_ERROR_PAGE'); ?> <?php echo JText::_('COM_FIX404ERRORLINKS_WITH'); ?> <?php echo $item->action_code; ?> <?php echo JText::_('COM_FIX404ERRORLINKS_HTTP_CODE'); ?>">
                                    <?php echo JText::sprintf(JText::_('COM_FIX404ERRORLINKS_ERROR_CODE_PAGE'), $item->action_code); ?>
                                </span>
                                
                            <?php elseif ($item->action_type == 'do_nothing'): ?>

                                <span class="label label-default badge bg-secondary" style="margin-left:10px;">
                                    <?php echo JText::_('COM_FIX404ERRORLINKS_ACTION_TYPE_'.strtoupper($item->action_type)); ?>
                                </span>

                            <?php endif; ?>
                        </td>
     
                        <td class="center">
                            <span class="badge badge-info bg-secondary"><?php echo $item->hits; ?></span>
                        </td>
                        
                        <td class="center">
                            <span>
                            <?php
                            if (!empty($item->last_access) && $item->last_access != Factory::getDbo()->getNullDate())
                            {
                                echo JHtml::_('date', $item->last_access, JText::_('COM_FIX404ERRORLINKS_DEFAULT_DATE_FORMAT'));
                            }
                            else 
                            {
                                echo JText::_('COM_FIX404ERRORLINKS_NOT_VISITED_YET');
                            }
                            ?>
                            </span>
                        </td>

                        <td class="center">
                            <?php if (!empty($item->notes)): ?>

								<span class="hasTooltip" title="<?php echo $this->escape(nl2br($item->notes)); ?>">
									<i class="icon-info-2"></i>
								</span>

							<?php endif; ?>
                        </td>

                        <?php if (isset($this->items[0]->id)): ?>
                        <td class="center hidden-phone">
                            <?php echo (int) $item->id; ?>
                        </td>
                        <?php endif; ?>

                    </tr>
                    <?php endforeach; ?>
                </tbody>
            </table>

            <input type="hidden" name="task" value="" />
            <input type="hidden" name="boxchecked" value="0" />
            <?php echo JHtml::_('form.token'); ?>

        </form>

        <?php echo Web357Framework\Functions::showFooter("com_fix404errorlinks", JText::_('COM_FIX404ERRORLINKS_CLEAN')); ?>

    </div><!-- .j-main-container -->

    <script>
        window.toggleField = function (id, task, field) {

            var f = document.adminForm,
                i = 0,
                cbx, cb = f[id];

            if (!cb) return false;

            while (true) {
                cbx = f['cb' + i];

                if (!cbx) break;

                cbx.checked = false;
                i++;
            }

            var inputField = document.createElement('input');

            inputField.type = 'hidden';
            inputField.name = 'field';
            inputField.value = field;
            f.appendChild(inputField);

            cb.checked = true;
            f.boxchecked.value = 1;
            window.submitform(task);

            return false;
        };
    </script>