<?php
/* ======================================================
 # Fix 404 Error Links for Joomla! - v2.2.5 (pro version)
 # -------------------------------------------------------
 # For Joomla! CMS (v3.x)
 # Author: Web357 (Yiannis Christodoulou)
 # Copyright (©) 2014-2022 Web357. All rights reserved.
 # License: GNU/GPLv3, http://www.gnu.org/licenses/gpl-3.0.html
 # Website: https:/www.web357.com
 # Demo: https://demo.web357.com/joomla/fix-404-error-links
 # Support: support@web357.com
 # Last modified: Thursday 08 June 2023, 01:53:23 AM
 ========================================================= */
// No direct access
defined('_JEXEC') or die;

use Joomla\CMS\Factory;
use Joomla\CMS\HTML\HTMLHelper;
use Joomla\CMS\Language\Associations;
use Joomla\CMS\Language\Text;
use Joomla\CMS\Layout\LayoutHelper;
use Joomla\CMS\Router\Route;
use Joomla\CMS\Application\CMSApplication;

/** @var Joomla\CMS\WebAsset\WebAssetManager $wa */
// $wa = $this->document->getWebAssetManager();
// $wa->useScript('keepalive')
// 	->useScript('form.validate');

// // Fieldsets to not automatically render by /layouts/joomla/edit/params.php
// $this->ignore_fieldsets = ['details', 'item_associations', 'jmetadata'];
// $this->useCoreUI = true;

JHtml::addIncludePath(JPATH_COMPONENT . '/helpers/html');
if (version_compare(JVERSION, '3.3', 'ge') && version_compare(JVERSION, '4.0', 'lt'))
{
	// joomla 3.x
	JHtml::_('behavior.tooltip');
	JHtml::_('behavior.formvalidation');
	JHtml::_('formbehavior.chosen', 'select');
}
else
{
	HTMLHelper::_('behavior.formvalidator');
}

JHtml::_('behavior.keepalive');

?>
<script type="text/javascript">
	js = jQuery.noConflict();
	js(document).ready(function () {
		
	});

	Joomla.submitbutton = function (task) {
		if (task == 'redirect.cancel') {
			Joomla.submitform(task, document.getElementById('redirect-form'));
		}
		else {

			if (task != 'redirect.cancel'/*  && document.formvalidator.isValid(document.id('redirect-form')) */) {
				
				Joomla.submitform(task, document.getElementById('redirect-form'));
			}
			else {
				alert('<?php echo $this->escape(JText::_('JGLOBAL_VALIDATION_FORM_FAILED')); ?>');
			}
		}
	}
</script>

<form
	action="<?php echo JRoute::_('index.php?option=com_fix404errorlinks&layout=edit&id=' . (int) $this->item->id); ?>"
	method="post" enctype="multipart/form-data" name="adminForm" id="redirect-form" class="form-validate form-horizontal" autocomplete="off">

	<input type="hidden" name="jform[id]" value="<?php echo $this->item->id; ?>" />
	<input type="hidden" name="jform[ordering]" value="<?php echo $this->item->ordering; ?>" />
	<input type="hidden" name="jform[state]" value="<?php echo $this->item->state; ?>" />
	<input type="hidden" name="jform[checked_out]" value="<?php echo $this->item->checked_out; ?>" />
	<input type="hidden" name="jform[checked_out_time]" value="<?php echo $this->item->checked_out_time; ?>" />

	<div class="row-fluid">
		<div class="span9 col-9">
			<fieldset>
				<legend><?php echo JText::_('COM_FIX404ERRORLINKS_URL_DETAILS'); ?></legend>
				
				<div class="row-fluid">

					<div class="span4 col-4 col-4">
						<div class="control-group">
							<?php echo $this->form->getLabel('match_type'); ?>
							<div class="controls">
								<?php echo $this->form->getInput('match_type'); ?>
							</div>
						</div>
					</div>

					<div class="span4 col-4 col-4">
						<?php echo $this->form->renderField('source_match_http_code', null, $this->item->source_match_http_code); ?>
					</div>

				</div>

				<div class="row-fluid">
					<div class="span12 col-12">
						<div class="control-group">
							<?php echo $this->form->getLabel('source_url'); ?>
							<div class="controls">
								<?php echo $this->form->getInput('source_url', null, $this->get_source_url); ?>
								<?php echo $this->form->getLabel('regex'); ?>
								<?php echo $this->form->getInput('regex'); ?>
							</div>
						</div>
					</div>
				</div>

				<div class="row-fluid">

					<div class="span4 col-4">
						<div class="control-group">
							<?php echo $this->form->getLabel('action_type'); ?>
							<div class="controls">
								<?php echo $this->form->getInput('action_type'); ?>
							</div>
						</div>
					</div>
					
					<div class="span4 col-4">
						<?php echo $this->form->renderField('action_code_30x', null, $this->item->action_code); ?>
						<?php echo $this->form->renderField('action_code_40x', null, $this->item->action_code); ?>
					</div>

				</div>

				<div class="row-fluid">
					<div class="span12 col-12">
						<?php echo $this->form->renderField('target_url', null, $this->item->target_url); ?>
						<?php echo $this->form->renderField('target_menuitem', null, $this->item->target_url); ?>
					</div>
				</div>

				<?php if (!empty($this->item->source_url) && !empty($this->item->action_type)): ?>
				<div class="row-fluid">
					<div class="span12 col-12">
						<div style="margin-top: 20px; border: 3px solid green; padding: 12px; display:inline-block">
							<h3>Redirection Analysis</h3>

							<div id="redirection-analysis">

								<?php 
								// Build vars
								$source_url = $this->juri_base.$this->item->source_url;
								$source_match_http_code = $this->item->source_match_http_code;
								$source_match_http_code_text = Fix404errorlinksHelper::getHttpStatusCodeText($this->item->source_match_http_code);
								$action_code = $this->item->action_code;
								$action_code_text = Fix404errorlinksHelper::getHttpStatusCodeText($this->item->action_code);

								// target url
								if (strpos($this->item->target_url, 'http://') !== false || strpos($this->item->target_url, 'https://') !== false)
								{
									$target_url = $this->item->target_url;
								}
								else
								{
									$target_url = $this->juri_base.''.$this->item->target_url;
								}

								if ($this->item->action_type == 'error_404')
								{
									$target_url = $source_url;
								}

								if ($this->item->action_type == 'redirect_to_menu_item') 
								{
									$router = CMSApplication::getInstance('site')->getRouter('site');
									$url = $router->build('index.php?Itemid=' . intval($this->item->target_url));
									$target_url = $this->juri_base . '' . ltrim($url->toString(), '/');
								}

								// HTML structure
								$redirection_analysis_html  = '';
								$redirection_analysis_html .= '<p>';
								$redirection_analysis_html .= 'When a User visits ';

								if ($this->item->regex)
								{
									$redirection_analysis_html .= 'a URL with the REGEX <strong>'.$this->item->source_url.'</strong> ';
								}
								else
								{
									switch ($this->item->match_type) 
									{
										case 'full_url':
											$redirection_analysis_html .= 'the URL <span id="source-url"><a target="_blank" href="'.$source_url.'">'.$source_url.'</a></span> ';
											break;
										case 'contains_string':
											$example_url = $this->juri_base.'begin-'.$this->item->source_url.'-end';
											$redirection_analysis_html .= 'a URL that <strong>contains</strong> the string "<strong>'.$this->item->source_url.'</strong>", for example: <a target="_blank" href="'.$example_url.'">'.$example_url.'</a> ';
											break;
										case 'start_with':
											$example_url = $this->juri_base.''.$this->item->source_url.'-lorem-ipsum';
											$redirection_analysis_html .= 'a URL that <strong>starts with</strong> the string "<strong>'.$this->item->source_url.'</strong>", for example: <a target="_blank" href="'.$example_url.'">'.$example_url.'</a> ';
											break;
										case 'end_with':
											$example_url = $this->juri_base.'lorem-ipsum-'.$this->item->source_url;
											$redirection_analysis_html .= 'a URL that <strong>ends with</strong> the string "<strong>'.$this->item->source_url.'</strong>", for example: <a target="_blank" href="'.$example_url.'">'.$example_url.'</a> ';
											break;
										case 'find_and_replace':
											$example_url = $this->juri_base.'lorem-'.$this->item->source_url.'-ipsum';
											$redirection_analysis_html .= 'a URL that <strong>contains</strong> the string "<strong>'.$this->item->source_url.'</strong>", for example: <a target="_blank" href="'.$example_url.'">'.$example_url.'</a> ';
											$target_url = $this->juri_base.'lorem-'.$this->item->target_url.'-ipsum';
											break;
										default:
											$redirection_analysis_html .= 'the URL <span id="source-url"><a target="_blank" href="'.$source_url.'">'.$source_url.'</a></span>';
											break;
									}
								}

								// $redirection_analysis_html .= '(<small class="hasTooltip" title="'.JHtml::_('tooltipText', 'The HTTP status code of the source URL is "'.$source_match_http_code_text.'"').'">'.$source_match_http_code.'</small>) ';

								if ($this->item->action_type == 'do_nothing')
								{
									$redirection_analysis_html .= 'do nothing';
								}
								else
								{
									if ($this->item->action_type == 'error_404')
									{
										$redirection_analysis_html .= 'he will be redirected to website\'s <strong>default error page</strong> ';
									}
									else
									{
										$redirection_analysis_html .= 'he will be redirected to the URL ';
										$redirection_analysis_html .= '<span id="target-url"><a target="_blank" href="'.$target_url.'">'.$target_url.'</a></span> ';
									}

									$redirection_analysis_html .= '(<small class="hasTooltip" title="'.JHtml::_('tooltipText', 'The HTTP status code of the URL that User will be redirected is "'.$action_code_text.'"').'">'.$action_code.'</small>)';
								}

								$redirection_analysis_html .= '.';
								$redirection_analysis_html .= '</p>';
								
								// Print
								echo $redirection_analysis_html;
								?>
								
							</div>

						</div>
					</div>
				</div>
				<?php endif; ?>

			</fieldset>
		</div>
		<div class="span3 col-3">
			<legend><?php echo JText::_('JSTATUS'); ?></legend>

			<div class="row-fluid">
				<div class="span12 col-12">
					<?php echo $this->form->renderField('state'); ?>
				</div>
			</div>

			<div class="row-fluid">
				<div class="span12 col-12">
					<?php echo $this->form->renderField('hits'); ?>
				</div>
			</div>

			<div class="row-fluid">
				<div class="span12 col-12">
					<?php echo $this->form->renderField('notes'); ?>
				</div>
			</div>
		</div>
	</div>

	<?php echo $this->form->renderField('created_by'); ?>
	<?php echo $this->form->renderField('modified_by'); ?>

	<input type="hidden" name="task" value=""/>
	<input type="hidden" name="goback" value="<?php echo Factory::getApplication()->input->get('goback', '', 'STRING'); ?>" />
	<?php echo JHtml::_('form.token'); ?>

</form>

<?php echo Web357Framework\Functions::showFooter("com_fix404errorlinks", JText::_('COM_FIX404ERRORLINKS_CLEAN')); ?>
