<?php
/* ======================================================
 # Fix 404 Error Links for Joomla! - v2.2.5 (pro version)
 # -------------------------------------------------------
 # For Joomla! CMS (v3.x)
 # Author: Web357 (Yiannis Christodoulou)
 # Copyright (©) 2014-2022 Web357. All rights reserved.
 # License: GNU/GPLv3, http://www.gnu.org/licenses/gpl-3.0.html
 # Website: https:/www.web357.com
 # Demo: https://demo.web357.com/joomla/fix-404-error-links
 # Support: support@web357.com
 # Last modified: Thursday 08 June 2023, 01:53:23 AM
 ========================================================= */
// No direct access to this file
defined('_JEXEC') or die;

use Joomla\CMS\Application\CMSApplication;

// import Joomla view library
jimport('joomla.application.component.view');

class Fix404errorlinksViewFix404errorlinks extends JViewLegacy
{
		function display($tpl = null) 
		{
			// get model
			$model = $this->getModel();
			
			// get data
			$this->MostHitErrorURLs = $this->get('MostHitErrorURLs');
			$this->CountErrorURLs = (int) $this->get('CountErrorURLs');
			$this->getCountErrorURLs = (int) $model->getCountErrorURLs('', 'non_fixed');
			$this->getCountErrorURLsToday = (int) $model->getCountErrorURLs(1, 'non_fixed');
			$this->getCountErrorURLsLast7Days = (int) $model->getCountErrorURLs(7, 'non_fixed');
			$this->getCountErrorURLsLast30Days = (int) $model->getCountErrorURLs(30, 'non_fixed');
			$this->getCountErrorURLsLast3Months = (int) $model->getCountErrorURLs(90, 'non_fixed');
			$this->getCountFixedErrorURLs = (int) $model->getCountErrorURLs('', 'fixed');
			$this->getCountFixedErrorURLsToday = (int) $model->getCountErrorURLs(1, 'fixed');
			$this->getCountFixedErrorURLsLast7Days = (int) $model->getCountErrorURLs(7, 'fixed');
			$this->getCountFixedErrorURLsLast30Days = (int) $model->getCountErrorURLs(30, 'fixed');
			$this->getCountFixedErrorURLsLast3Months = (int) $model->getCountErrorURLs(90, 'fixed');
			$this->getCountAllErrorURLs = (int) $model->getCountErrorURLs();
			$this->getCountAllErrorURLsToday = (int) $model->getCountErrorURLs(1);
			$this->getCountAllErrorURLsLast7Days = (int) $model->getCountErrorURLs(7);
			$this->getCountAllErrorURLsLast30Days = (int) $model->getCountErrorURLs(30);
			$this->getCountAllErrorURLsLast3Months = (int) $model->getCountErrorURLs(90);

			$this->LatestUniqueErrorURLs = $this->get('LatestUniqueErrorURLs');
			$this->MostHitRedirections = $this->get('MostHitRedirections');
			$this->CountRedirections = $this->get('CountRedirections');

			// live URL
			$this->live_url = str_replace('/administrator', '', JURI::base());
			$this->live_site = substr(JURI::root(), 0, -1);
			$this->router = CMSApplication::getInstance('site')->getRouter('site');

			if (version_compare(JVERSION, '3.0', 'ge'))
			{
				// J3X
				// Include helper submenu
				Fix404errorlinksHelper::addSubmenu('fix404errorlinks');
		
				// Show sidebar
				$this->sidebar = JHtmlSidebar::render();
			}

			// Set the toolbar
			$this->addToolBar();

			// Display the template
			parent::display($tpl);
		}

	protected function addToolBar()
	{
		$canDo = Fix404errorlinksHelper::getActions();

		JToolbarHelper::link(JRoute::_('index.php?option=com_fix404errorlinks'), 'COM_FIX404ERRORLINKS_CPANEL', 'home');

		if($canDo->get('core.admin'))
		{
			JToolBarHelper::divider();
			JToolBarHelper::preferences('com_fix404errorlinks');
		}

		// Set ToolBar title
		JToolbarHelper::title(JText::_('COM_FIX404ERRORLINKS').': '.JText::_('COM_FIX404ERRORLINKS_CPANEL'), 'link.png');
	}
}