<?php
/* ======================================================
 # Fix 404 Error Links for Joomla! - v2.2.5 (pro version)
 # -------------------------------------------------------
 # For Joomla! CMS (v3.x)
 # Author: Web357 (Yiannis Christodoulou)
 # Copyright (©) 2014-2022 Web357. All rights reserved.
 # License: GNU/GPLv3, http://www.gnu.org/licenses/gpl-3.0.html
 # Website: https:/www.web357.com
 # Demo: https://demo.web357.com/joomla/fix-404-error-links
 # Support: support@web357.com
 # Last modified: Thursday 08 June 2023, 01:53:23 AM
 ========================================================= */
defined('_JEXEC') or die;
JHtml::_('bootstrap.tooltip');
?>
<div class="container-fluid">
	<div class="row-fluid">
		<span class="w357-col-span span8 col-8">

			<div class="row-fluid">
				<div class="clearfix">
					<ul class="w357-cpanel-icons clearfix">
						<li>
							<a href="<?php echo JURI::base() ?>index.php?option=com_fix404errorlinks&view=redirect&layout=edit">
								<span class="icon-new"></span>
								<span><?php echo JText::_("COM_FIX404ERRORLINKS_ADD_REDIRECTION") ?></span>
							</a>
						</li>
						<li>
							<a href="<?php echo JURI::base() ?>index.php?option=com_fix404errorlinks&view=error404logs">
								<span class="icon-notification-circle"></span>
								<span><?php echo JText::_("COM_FIX404ERRORLINKS_ERROR_404_LINKS") ?></span>
							</a>
						</li>
						
						<li>
							<a href="<?php echo JURI::base() ?>index.php?option=com_fix404errorlinks&view=redirects">
								<span class="icon-link"></span>
								<span><?php echo JText::_("COM_FIX404ERRORLINKS_REDIRECTS") ?></span>
							</a>
						</li>

						<li>
							<a href="<?php echo JURI::base() ?>index.php?option=com_config&view=component&component=com_fix404errorlinks&path=&return=<?php echo MD5(JURI::base()."index.php?option=com_fix404errorlinks") ?>">
								<span class="icon-options"></span>
								<span><?php echo JText::_("JOPTIONS") ?></span>
							</a>
						</li>
						<li>
							<a href="https://docs.web357.com/category/41-fix-404-error-links" target="_blank">
								<span class="icon-book"></span>
								<span><?php echo JText::_("COM_FIX404ERRORLINKS_DOCUMENTATION")?></span>
							</a>
						</li>
					</ul>
				</div>
			</div>

			<div class="row-fluid w357-cpanel-stats" style="margin-top:30px;">
				<div class="w357-col-span span6 col-6">
					<div class="well">
						<a href="index.php?option=com_fix404errorlinks&view=error404logs&list[fullordering]=a.hits DESC">
							<h3><?php echo JText::_("COM_FIX404ERRORLINKS_MOST_HIT_ERROR_URLS") ?></h3>
						</a>
						<?php if (!empty($this->MostHitErrorURLs)): ?>
						<table class="table table-striped">
							<thead>
								<tr>
									<th class="center"><?php echo JText::_("COM_FIX404ERRORLINKS_ACTION")?></th>
									<th class="center"><?php echo JText::_("COM_FIX404ERRORLINKS_HITS")?></th>
									<th><?php echo JText::_("COM_FIX404ERRORLINKS_ERROR_URL")?></th>
								</tr>
							</thead>
							<tbody>
								<?php foreach ($this->MostHitErrorURLs as $item): ?>
								<tr>
									<td width="15%" class="center">
										<a href="index.php?option=com_fix404errorlinks&view=redirect&layout=edit&source_url=<?php echo urlencode($item->error_url); ?>&goback=fix404errorlinks" class="btn btn-small btn-sm btn-success">
											<?php echo JText::_('COM_FIX404ERRORLINKS_FIX_IT'); ?>
										</a>
									</td>
									<td width="1%" class="center">
										<span class="badge badge-info bg-secondary"><?php echo $item->hits; ?></span>
									</td>
									<td>
										<?php
										if (strpos($item->error_url, Fix404errorlinksHelper::idnToAscii($this->live_url)) !== false)
										{
											$url = $this->escape($item->error_url);
										}
										else
										{
											$url = $this->live_url . $this->escape($item->error_url);
										}

										?>
										<a href="<?php echo $url; ?>" title="<?php echo $url; ?>" target="_blank">
											<?php echo Web357Framework\Functions::shortenURL($item->error_url, 40); ?> 
											<img src="<?php echo 'components/com_fix404errorlinks/assets/icons/open_link.png'; ?>" alt="link" width="9" height="9" />
										</a>
									</td>
								</tr>
								<?php endforeach; ?>
							</tbody>
						</table>
						<?php else: ?>
						<p>
							<?php echo JText::_('COM_FIX404ERRORLINKS_NODATA_YET'); ?>
						</p>
						<?php endif; ?>
					</div>
				</div>
				<div class="w357-col-span span6 col-6">
					<div class="well">
						<a href="index.php?option=com_fix404errorlinks&view=error404logs&list[fullordering]=a.datetime_created DESC">
							<h3>
								<?php echo JText::_("COM_FIX404ERRORLINKS_LATEST_404_ERROR_URLS") ?>
							</h3>
						</a>
						<?php if (!empty($this->LatestUniqueErrorURLs)): ?>
						<table class="table table-striped">
							<thead>
								<tr>
									<th width="15%" class="center"><?php echo JText::_("COM_FIX404ERRORLINKS_ACTION")?></th>
									<th width="30%"><?php echo JText::_("COM_FIX404ERRORLINKS_DATETIME")?></th>
									<th><?php echo JText::_("COM_FIX404ERRORLINKS_ERROR_URL")?></th>
								</tr>
							</thead>
							<tbody>
								<?php foreach ($this->LatestUniqueErrorURLs as $item): ?>
								<tr>
									<td class="center">
										<a href="index.php?option=com_fix404errorlinks&view=redirect&layout=edit&source_url=<?php echo urlencode($item->error_url); ?>&goback=fix404errorlinks" class="btn btn-small btn-sm btn-success">
											<?php echo JText::_('COM_FIX404ERRORLINKS_FIX_IT'); ?>
										</a>
									</td>
									<td>
										<small class="text-muted">
										<?php
										if (!empty($item->datetime_created))
										{
											echo JHtml::_('date', $item->datetime_created, JText::_('COM_FIX404ERRORLINKS_DEFAULT_DATE_FORMAT_FULL'));
										}
										else 
										{
											echo Factory::getDbo()->getNullDate();
										}
										?>
										</small>
									</td>
									<td>
										<?php
										if (strpos($item->error_url, Fix404errorlinksHelper::idnToAscii($this->live_url)) !== false)
										{
											$url = $this->escape($item->error_url);
										}
										else
										{
											$url = $this->live_url . $this->escape($item->error_url);
										}
										?>
										<a href="<?php echo $url; ?>" title="<?php echo $url; ?>" target="_blank">
											<?php echo Web357Framework\Functions::shortenURL($item->error_url, 40); ?> 
											<img src="<?php echo 'components/com_fix404errorlinks/assets/icons/open_link.png'; ?>" alt="link" width="9" height="9" />
										</a>
									</td>
								</tr>
								<?php endforeach; ?>
							</tbody>
						</table>
						<?php else: ?>
						<p>
							<?php echo JText::_('COM_FIX404ERRORLINKS_NODATA_YET'); ?>
						</p>
						<?php endif; ?>
					</div>
				</div>
			</div>
			<div class="row-fluid w357-cpanel-stats" style="margin-top: 10px;">
				<div class="w357-col-span span6 col-6">
					<div class="well">
						<a href="index.php?option=com_fix404errorlinks&view=redirects">
							<h3><?php echo JText::_("COM_FIX404ERRORLINKS_MOST_HIT_REDIRECTIONS") ?></h3>
						</a>
						<?php if (!empty($this->MostHitRedirections)): ?>
						<table class="table table-striped">
						<thead>
								<tr>
									<th width="1%" class="center"><?php echo JText::_("COM_FIX404ERRORLINKS_HITS")?></th>
									<th width="45%"><?php echo JText::_("COM_FIX404ERRORLINKS_SOURCE_URL_HEADING")?></th>
									<th><?php echo JText::_("COM_FIX404ERRORLINKS_TARGET_URL_HEADING")?></th>
								</tr>
							</thead>
							<tbody>
								<?php foreach ($this->MostHitRedirections as $item): ?>
								<tr>
									<td class="center">
										<span class="badge badge-info bg-secondary"><?php echo $item->hits; ?></span>
									</td>
									<td>
										<small style="margin-right: 5px;">
										
											<span class="hasTooltip dottedUnderline" title="<?php echo JText::_('COM_FIX404ERRORLINKS_MATCH_TYPE_LBL'); ?>">
											<?php echo JText::_('COM_FIX404ERRORLINKS_'.strtoupper($item->match_type)); ?>

											<?php if ($item->regex): ?>
												(<?php echo JText::_('COM_FIX404ERRORLINKS_REGEX'); ?>)
											<?php endif; ?>
											</span>
										</small>
										
										<?php 
										if (strpos($item->source_url, Fix404errorlinksHelper::idnToAscii(str_replace('administrator/', '', JURI::base()))) !== false)
										{
											$item_source_url = $item->source_url;
										}
										else
										{
											$item_source_url = str_replace('administrator', '', JURI::base(true)) . '' . $this->escape($item->source_url);
										}

										switch ($item->match_type) 
										{
											case 'full_url':
                                    			$source_url = $item_source_url;
			                                    $source_url_txt = str_replace('administrator', '', $this->escape($item->source_url));
												$link = true;
												break;
											case 'contains_string':
                                    			$source_url = $item_source_url;
			                                    $source_url_txt = str_replace('administrator', '', $this->escape($item->source_url));
												$link = true;
												break;
											case 'start_with':
                                    			$source_url = $item_source_url;
			                                    $source_url_txt = str_replace('administrator', '', $this->escape($item->source_url));
												$link = true;
												break;
											case 'end_with':
                                    			$source_url = $item_source_url;
			                                    $source_url_txt = str_replace('administrator', '', $this->escape($item->source_url));
												$link = true;
												break;
											case 'find_and_replace':
                                    			$source_url = $item_source_url;
			                                    $source_url_txt = str_replace('administrator', '', $this->escape($item->source_url));
												$link = false;
												break;
											default:
                                    			$source_url = $item_source_url;
												$source_url_txt = $this->escape($item->source_url);
												$link = true;
												break;
										}
										?>

										<?php if ($link): ?>
										<a href="<?php echo $source_url; ?>" title="<?php echo $source_url; ?>" target="_blank" rel="noopener noreferrer">
										<?php endif; ?>
											<?php echo Web357Framework\Functions::shortenURL($source_url_txt, 40); ?>
										<?php if ($link): ?>
										<img src="components/com_fix404errorlinks/assets/icons/open_link.png" alt="link" width="9" height="9" />
										</a>
										<?php endif; ?>
									</td>
									<td>
										<?php if ($item->action_type == 'redirect_to_menu_item' || $item->action_type == 'redirect_to_url'): ?>
													
											<?php if(substr($item->action_code, 0, 1) == 3) : ?>
												<span class="label label-success badge bg-success hasTooltip" style="margin-right: 5px;" title="<?php echo JText::_('COM_FIX404ERRORLINKS_ACTION_TYPE_'.strtoupper($item->action_type)); ?> <?php echo JText::_('COM_FIX404ERRORLINKS_WITH'); ?> <?php echo $item->action_code; ?> <?php echo JText::_('COM_FIX404ERRORLINKS_HTTP_CODE'); ?>">
													<?php echo $item->action_code; ?>
												</span>
											<?php elseif(substr($item->action_code, 0, 1) == 4) : ?>
												<span class="label label-important badge bg-danger hasTooltip" style="margin-right: 5px;" title="<?php echo JText::_('COM_FIX404ERRORLINKS_ACTION_TYPE_'.strtoupper($item->action_type)); ?> <?php echo JText::_('COM_FIX404ERRORLINKS_WITH'); ?> <?php echo $item->action_code; ?> <?php echo JText::_('COM_FIX404ERRORLINKS_HTTP_CODE'); ?>">
													<?php echo $item->action_code; ?>
												</span>
											<?php else: ?>
												<span class="label label-important badge bg-danger hasTooltip" style="margin-right: 5px;" title="<?php echo $item->action_type; ?> <?php echo JText::_('COM_FIX404ERRORLINKS_WITH'); ?> <?php echo $item->action_code; ?> <?php echo JText::_('COM_FIX404ERRORLINKS_HTTP_CODE'); ?>">
													<?php echo $item->action_code; ?>
												</span>
											<?php endif; ?>

											<?php 
											if ($item->action_type == 'redirect_to_menu_item')
											{
												$url = $this->router->build('index.php?Itemid=' . intval($item->target_url));
												$url = $url->toString();
												$target_url = str_replace($this->live_site .'/administrator', $this->live_site, $url);
			                                    $target_url_txt = str_replace(str_replace('/administrator', '', JURI::base(true)), '', $url);
											}
											else 
											{
												if ($item->match_type == 'find_and_replace')
												{
													$target_url = $this->escape($item->target_url);
												}
												else
												{

													if (strpos($item->target_url,'http') !== false)
													{
														$target_url = $item->target_url;
													}
													elseif (strpos($item->target_url,'www') !== false)
													{
														$target_url = 'http://'.$item->target_url;
													}
													else
													{
														$target_url = str_replace('administrator', '', JURI::base(true)).$this->escape($item->target_url);
													}
                                   					
													$target_url_txt = (strpos($item->target_url,'http') !== false || strpos($item->target_url,'www') !== false) ? $item->target_url : "/".$this->escape($item->target_url);
												}
											}
											?>

											<?php if ($link): ?>
											<a href="<?php echo $target_url; ?>" target="_blank" rel="noopener noreferrer">
											<?php endif; ?>
												<strong><?php echo Web357Framework\Functions::shortenURL($target_url_txt, 40); ?></strong> 
											<?php if ($link): ?>
											<img src="components/com_fix404errorlinks/assets/icons/open_link.png" alt="open link" width="9" height="9" />
											</a>
											<?php endif; ?>

										<?php elseif ($item->action_type == 'error_404'): ?>

											<span class="label label-important badge bg-danger hasTooltip" title="<?php echo JText::_('COM_FIX404ERRORLINKS_REDIRECT_TO_AN_ERROR_PAGE'); ?> <?php echo JText::_('COM_FIX404ERRORLINKS_WITH'); ?> <?php echo $item->action_code; ?> <?php echo JText::_('COM_FIX404ERRORLINKS_HTTP_CODE'); ?>">
												<?php echo JText::sprintf(JText::_('COM_FIX404ERRORLINKS_ERROR_CODE_PAGE'), $item->action_code); ?>
											</span>
											
										<?php elseif ($item->action_type == 'do_nothing'): ?>

											<span class="label label-default">
												<?php echo JText::_('COM_FIX404ERRORLINKS_ACTION_TYPE_'.strtoupper($item->action_type)); ?>
											</span>

										<?php endif; ?>
									</td>

								</tr>
								<?php endforeach; ?>
							</tbody>
						</table>
						<?php else: ?>
						<p>
							<?php echo JText::_('COM_FIX404ERRORLINKS_NODATA_YET'); ?>
						</p>
						<?php endif; ?>
					</div>
				</div>
				<div class="w357-col-span span6 col-6">
					<div class="well">
						<h3><?php echo JText::_("COM_FIX404ERRORLINKS_STATISTICS") ?></h3>
						<table class="table table-striped">
							<thead>
								<tr>
									<th width="45%"><?php echo JText::_("COM_FIX404ERRORLINKS_TYPE") ?></th>
									<th><?php echo JText::_("COM_FIX404ERRORLINKS_NUM_OF_ITEMS") ?></th>
								</tr>
							</thead>
							<tbody>
								<tr>
									<td><?php echo JText::_("COM_FIX404ERRORLINKS_TODAY_ERRORS") ?></td>
									<td><a href="index.php?option=com_fix404errorlinks&view=error404logs&filter[date_range]=today&filter[fixed_error404_urls]=&list[fullordering]=a.hits DESC" class="badge badge-important bg-secondary hasTooltip" title="<?php echo JText::sprintf(JText::_('COM_FIX404ERRORLINKS_NON_FIXED_ERROR_LINKS_COUNT'), $this->getCountErrorURLsToday); ?>"><?php echo $this->getCountErrorURLsToday; ?></a></td>
								</tr>
								<tr>
									<td><?php echo JText::_("COM_FIX404ERRORLINKS_LAST7DAYS_ERRORS") ?></td>
									<td><a href="index.php?option=com_fix404errorlinks&view=error404logs&filter[date_range]=7d&filter[fixed_error404_urls]=&list[fullordering]=a.hits DESC" class="badge badge-important bg-secondary hasTooltip" title="<?php echo JText::sprintf(JText::_('COM_FIX404ERRORLINKS_NON_FIXED_ERROR_LINKS_COUNT'), $this->getCountErrorURLsLast7Days); ?>"><?php echo $this->getCountErrorURLsLast7Days; ?></a></td>
								</tr>
								<tr>
									<td><?php echo JText::_("COM_FIX404ERRORLINKS_LAST30DAYS_ERRORS") ?></td>
									<td><a href="index.php?option=com_fix404errorlinks&view=error404logs&filter[date_range]=30d&filter[fixed_error404_urls]=&list[fullordering]=a.hits DESC" class="badge badge-important bg-secondary hasTooltip" title="<?php echo JText::sprintf(JText::_('COM_FIX404ERRORLINKS_NON_FIXED_ERROR_LINKS_COUNT'), $this->getCountErrorURLsLast30Days); ?>"><?php echo $this->getCountErrorURLsLast30Days; ?></a></td>
								</tr>
								<tr>
									<td><?php echo JText::_("COM_FIX404ERRORLINKS_LAST3MONTHS_ERRORS") ?></td>
									<td><a href="index.php?option=com_fix404errorlinks&view=error404logs&filter[date_range]=3m&filter[fixed_error404_urls]=&list[fullordering]=a.hits DESC" class="badge badge-important bg-secondary hasTooltip" title="<?php echo JText::sprintf(JText::_('COM_FIX404ERRORLINKS_NON_FIXED_ERROR_LINKS_COUNT'), $this->getCountErrorURLsLast3Months); ?>"><?php echo $this->getCountErrorURLsLast3Months; ?></a></td>
								</tr>

								<tr>
									<td><strong><?php echo JText::_("COM_FIX404ERRORLINKS_TOTAL_ERRORS") ?></strong></td>
									<td>
								
										<a href="index.php?option=com_fix404errorlinks&view=error404logs&filter[fixed_error404_urls]=all" class="badge badge-info bg-secondary hasTooltip" title="<?php echo JText::sprintf(JText::_('COM_FIX404ERRORLINKS_ERROR_LINKS_COUNT'), $this->getCountAllErrorURLs); ?>">
											<?php echo $this->getCountAllErrorURLs; ?>
										</a>

										<?php if ($this->getCountAllErrorURLs > 0): ?>

										<a href="index.php?option=com_fix404errorlinks&view=error404logs&filter[fixed_error404_urls]=non_fixed&list[fullordering]=a.hits DESC" class="label label-important badge bg-danger hasTooltip" title="<?php echo JText::sprintf(JText::_('COM_FIX404ERRORLINKS_NON_FIXED_ERROR_LINKS_COUNT'), $this->getCountErrorURLs); ?>" style="margin-left:10px;">
											<?php echo $this->getCountErrorURLs; ?> <?php echo JText::_("COM_FIX404ERRORLINKS_NON_FIXED") ?>
										</a>

										<a href="index.php?option=com_fix404errorlinks&view=error404logs&filter[fixed_error404_urls]=fixed&list[fullordering]=a.hits DESC" class="label label-success badge bg-success hasTooltip" title="<?php echo JText::sprintf(JText::_('COM_FIX404ERRORLINKS_FIXED_ERROR_LINKS_COUNT'), $this->getCountFixedErrorURLs); ?>" style="margin-left:5px;">
											<?php echo $this->getCountFixedErrorURLs; ?> <?php echo JText::_("COM_FIX404ERRORLINKS_FIXED") ?>
										</a>

										<?php endif; ?>

									</td>
								</tr>
								<tr>
									<td><strong><?php echo JText::_("COM_FIX404ERRORLINKS_TOTAL_REDIRECTIONS") ?></strong></td>
									<td>
										<a href="index.php?option=com_fix404errorlinks&view=redirects" class="badge badge-success bg-secondary hasTooltip" title="<?php echo JText::sprintf(JText::_('COM_FIX404ERRORLINKS_COUNT_REDIRECTIONS'), $this->CountRedirections); ?>">
											<?php echo $this->CountRedirections; ?>
										</a>
									</td>
								</tr>
							</tbody>
						</table>
					</div>
				</div>
			</div>
		</span>
		<span class="w357-col-span span4 col-4">
			<?php echo Web357Framework\Functions::updateChecker("com_fix404errorlinks", JText::_('COM_FIX404ERRORLINKS')); ?>

			<?php echo Web357Framework\Functions::web357ApiKeyCheckerHTMLbox(JText::_('COM_FIX404ERRORLINKS')); ?>

			<?php echo JHtml::_('bootstrap.startAccordion', "info", array('active' => 'slide0')); ?>

			<?php echo JHtml::_('bootstrap.addSlide', "info", JText::_("COM_FIX404ERRORLINKS"), 'slide0'); ?>
			<?php echo Web357Framework\Functions::controlPanelProductInfoHTMLTable("com_fix404errorlinks", JText::_('COM_FIX404ERRORLINKS')); ?>
			<?php echo JHtml::_('bootstrap.endSlide'); ?>

			<?php echo JHtml::_('bootstrap.endAccordion'); ?>

		</span>
	</div>
</div>

<?php echo Web357Framework\Functions::showFooter("com_fix404errorlinks", JText::_('COM_FIX404ERRORLINKS_CLEAN')); ?>
