<?php
/* ======================================================
 # Fix 404 Error Links for Joomla! - v2.2.5 (pro version)
 # -------------------------------------------------------
 # For Joomla! CMS (v3.x)
 # Author: Web357 (Yiannis Christodoulou)
 # Copyright (©) 2014-2022 Web357. All rights reserved.
 # License: GNU/GPLv3, http://www.gnu.org/licenses/gpl-3.0.html
 # Website: https:/www.web357.com
 # Demo: https://demo.web357.com/joomla/fix-404-error-links
 # Support: support@web357.com
 # Last modified: Thursday 08 June 2023, 01:53:23 AM
 ========================================================= */
// No direct access to this file
defined('_JEXEC') or die;

use Joomla\Utilities\IpHelper;
use Joomla\CMS\Application\CMSApplication;

// import Joomla view library
jimport('joomla.application.component.view');

class Fix404errorlinksViewError404logs extends JViewLegacy
{
	protected $items;
	protected $pagination;
	protected $state;

	function display($tpl = null) 
	{		
		// Get data from the model and then assign data to the view
		$this->state = $this->get('State');
		$this->items = $this->get('Items');
		$this->pagination = $this->get('Pagination');
		$this->filterForm = $this->get('FilterForm');
		$this->activeFilters = $this->get('ActiveFilters');
		$this->fixed_error404_urls = $this->getState('filter.fixed_error404_urls');

		$this->live_site = substr(JURI::root(), 0, -1);
		$this->router = CMSApplication::getInstance('site')->getRouter('site');

		// Get the correct IP address of the client
		$this->my_ip_address = IpHelper::getIp();
		if (!filter_var($this->my_ip_address, FILTER_VALIDATE_IP))
		{
			$this->my_ip_address = isset($_SERVER['REMOTE_ADDR']) ? $_SERVER['REMOTE_ADDR'] : '0.0.0.0';
		}
		$this->my_ip_address = '66.102.15.255';

		// get Model
       	$this->model = $this->getModel();

		// Check for model errors.
		if ($errors = $this->get('Errors'))
		{
			JError::raiseWarning(500, implode('<br />', $errors));
			return false;
		}

		if (version_compare(JVERSION, '3.0', 'ge'))
		{
			// J3X
			// Include helper submenu
			Fix404errorlinksHelper::addSubmenu('error404logs');
	
			// Show sidebar
			$this->sidebar = JHtmlSidebar::render();
		}

		// Set the toolbar
		$this->addToolBar();

		// Display the template
		parent::display($tpl);
	}

	protected function addToolBar()
	{
		$canDo = Fix404errorlinksHelper::getActions();

		// delete
		if($canDo->get('core.delete'))
		{
			JToolBarHelper::custom('error404logs.deletelogs', 'delete.png', 'delete_f2.png', 'JTOOLBAR_DELETE', true);
			JToolBarHelper::custom('error404logs.deleteAllLogs', 'purge.png', 'purge_f2.png', 'COM_FIX404ERRORLINKS_DELETE_ALL_404_ERROR_LINKS', false);
			JToolBarHelper::custom('error404logs.deleteFixed404ErrorURLs', 'ok.png', 'ok_f2.png', 'COM_FIX404ERRORLINKS_DELETE_ALL_404_FIXED_ERROR_LINKS', false);
		}

		JToolbarHelper::link(JRoute::_('index.php?option=com_fix404errorlinks'), 'COM_FIX404ERRORLINKS_CPANEL', 'arrow-left');

		// parameters
		if($canDo->get('core.admin'))
		{
			JToolBarHelper::divider();
			JToolBarHelper::preferences('com_fix404errorlinks');
		}

		// Set ToolBar title
		JToolbarHelper::title(JText::_('COM_FIX404ERRORLINKS_ERROR_404_LINKS'), 'link.png');
	}
	
	protected function getSortFields()
	{
		return array(
		'a.id' => JText::_('JGRID_HEADING_ID'),
		'a.error_url' => JText::_('COM_FIX404ERRORLINKS_ERROR_URL'),
		'a.hits' => JText::_('COM_FIX404ERRORLINKS_HITS'),
		);
	}

    /**
     * Check if state is set
     *
     * @param   mixed  $state  State
     *
     * @return bool
     */
    public function getState($state)
    {
        return isset($this->state->{$state}) ? $this->state->{$state} : false;
    }
}