<?php
/* ======================================================
 # Fix 404 Error Links for Joomla! - v2.2.5 (pro version)
 # -------------------------------------------------------
 # For Joomla! CMS (v3.x)
 # Author: Web357 (Yiannis Christodoulou)
 # Copyright (©) 2014-2022 Web357. All rights reserved.
 # License: GNU/GPLv3, http://www.gnu.org/licenses/gpl-3.0.html
 # Website: https:/www.web357.com
 # Demo: https://demo.web357.com/joomla/fix-404-error-links
 # Support: support@web357.com
 # Last modified: Thursday 08 June 2023, 01:53:23 AM
 ========================================================= */
defined('_JEXEC') or die;
use Joomla\CMS\Factory;

JHtml::addIncludePath(JPATH_COMPONENT . '/helpers/');
JHtml::_('bootstrap.tooltip');
JHtml::_('behavior.multiselect');
JHtml::_('dropdown.init');
if (version_compare(JVERSION, '4.0', 'lt')) {
	JHtml::_('formbehavior.chosen', 'select');
	JHTML::_('behavior.modal');
}

$user      = Factory::getUser();
$userId    = $user->get('id');
$listOrder = $this->state->get('list.ordering');
$listDirn  = $this->state->get('list.direction');
$canOrder  = $user->authorise('core.edit.state', 'com_fix404errorlinks');
$listOrder == 'hits';

$live_url = str_replace('/administrator','',JURI::base());

$sortFields = $this->getSortFields();
?>

<script type="text/javascript">
Joomla.submitbutton = function(task)
{
	if (task == 'error404logs.deleteAllLogs')
	{
		var confirmTask = confirm("<?php echo JText::_('COM_FIX404ERRORLINKS_DELETE_ALL_404_ERROR_LINKS_CONFIRM_ALERT_MSG'); ?>")
		if (confirmTask)
		{
			Joomla.submitform(task);
		}
		else
		{
			return false;
		}
	}
	else if (task == 'error404logs.deleteFixed404ErrorURLs')
	{
		var confirmTask = confirm("<?php echo JText::_('COM_FIX404ERRORLINKS_DELETE_ALL_FIXED_404_ERROR_LINKS_CONFIRM_ALERT_MSG'); ?>")
		if (confirmTask)
		{
			Joomla.submitform(task);
		}
		else
		{
			return false;
		}
	}
	else
	{
		Joomla.submitform(task);
	}
}
</script>

<form action="<?php echo JRoute::_('index.php?option=com_fix404errorlinks&view=error404logs'); ?>" method="post" name="adminForm" id="adminForm">
<div class="row-fluid">
<?php if(!empty($this->sidebar) && version_compare(JVERSION, '4.0', 'lt')): ?>
	<div id="j-sidebar-container" class="span2 col-2">
		<?php echo $this->sidebar; ?>
	</div>
	<div id="j-main-container" class="span10 col-10">
<?php else: ?>
	<div id="j-main-container">
<?php endif; ?>

		<?php echo JLayoutHelper::render('joomla.searchtools.default', array('view' => $this)); ?>

		<div class="clearfix"></div>

		<table class="table table-striped" id="orderList">
			<thead>

            <tr>
                <th width="1%" class="hidden-phone"><input type="checkbox" name="checkall-toggle" value="" title="<?php echo JText::_('JGLOBAL_CHECK_ALL'); ?>" onclick="Joomla.checkAll(this)" /></th>
                <th class="center"><?php echo JText::_('#'); ?></th>
                <th width="7%"><?php echo JText::_('COM_FIX404ERRORLINKS_FIX_LINKS'); ?></th>
                <th class="center"><?php echo JHtml::_('searchtools.sort', 'COM_FIX404ERRORLINKS_HITS', 'a.hits', $listDirn, $listOrder); ?></th>
                <th><?php echo JHtml::_('searchtools.sort', 'COM_FIX404ERRORLINKS_ERROR_URL', 'a.error_url', $listDirn, $listOrder); ?></th>
                <th><?php echo JHtml::_('searchtools.sort', 'COM_FIX404ERRORLINKS_ERROR_CODE_MSG', 'a.error_code', $listDirn, $listOrder); ?></th>
				<?php if ($this->fixed_error404_urls == 'fixed'): ?>
				<th><?php echo JText::_('COM_FIX404ERRORLINKS_FIXED_ERROR_URL_HEADING'); ?></th>
				<?php endif; ?>
				<th><?php echo JHtml::_('searchtools.sort',  'COM_FIX404ERRORLINKS_LAST_ACCESS_HEADING', 'a.datetime_created', $listDirn, $listOrder); ?></th>
            </tr>   
                    
            </thead>
			
			<tbody>
                        
			<?php
            foreach($this->items as $i => $item):
				$ordering   = ($listOrder == 'a.ordering');
				$canEdit    = $user->authorise('core.edit', 'com_fix404errorlinks');

				$redirect_id = '';
				$redirect_details = $this->model->getRedirectDetailsFromSourceURL($item->error_url);
				if ($redirect_details)
				{
					$redirect_id = $redirect_details->id;
					$redirect_source_url = $redirect_details->source_url;
					$redirect_target_url = $redirect_details->target_url;
					$redirect_match_type = $redirect_details->match_type;
					$redirect_action_type = $redirect_details->action_type;
					$redirect_action_code = $redirect_details->action_code;
					$redirect_regex = $redirect_details->regex;
				}
				$isDanger = $this->model->isDangerURL($item->error_url);
				?>
				<tr class="row<?php echo $i % 2; ?>">

					<td><?php echo JHtml::_('grid.id', $i, $item->id); ?></td>
					<td class="center"><?php echo $this->pagination->getRowOffset($i); ?></td>

					<td class="left">
						<?php if ($canEdit) : ?>
							<?php if (!empty($redirect_id)): ?>
								<a href="index.php?option=com_fix404errorlinks&view=redirect&layout=edit&id=<?php echo (int) $redirect_id; ?>" class="btn btn-small btn-sm btn-warning hasTooltip" title="<?php echo JText::_('COM_FIX404ERRORLINKS_EDIT_REDIRECTION_TITLE'); ?>" style="min-width: 30px;"><?php echo JText::_('COM_FIX404ERRORLINKS_EDIT'); ?></a>
							<?php else: ?>
								<a href="index.php?option=com_fix404errorlinks&view=redirect&layout=edit&source_url=<?php echo urlencode($item->error_url); ?>&goback=error404logs" class="btn btn-small btn-sm btn-success" style="min-width: 30px;"><?php echo JText::_('COM_FIX404ERRORLINKS_FIX_IT'); ?></a>
							<?php endif; ?>
						<?php else : ?>
                            <?php echo JText::_('COM_FIX404ERRORLINKS_NO_ACCESS_TO_EDIT'); ?>
                        <?php endif; ?>
					</td>

					<td class="center">
						<span class="badge badge-info bg-secondary"><?php echo $item->hits; ?></span>
					</td>

					<td>
						<?php if ($isDanger == TRUE): ?>
							<span class="badge badge-important bg-danger hasTooltip" style="margin-right: 5px;" title="<?php echo JText::_('COM_FIX404ERRORLINKS_DANGER_URL_TITLE'); ?>">
								<?php echo JText::_('COM_FIX404ERRORLINKS_DANGER_URL'); ?>	
							</span>
						<?php endif; ?>

						<?php if (!empty($redirect_id)): ?>
							<span class="badge badge-success hasTooltip" style="display:inline-block;font-size:10px;margin-right: 5px;" title="<?php echo JText::_('COM_FIX404ERRORLINKS_ALREADY_FIXED_TITLE'); ?>">
								<?php echo JText::_('COM_FIX404ERRORLINKS_ALREADY_FIXED'); ?>	
							</span>
						<?php endif; ?>

						<?php
						if (strpos($item->error_url, Fix404errorlinksHelper::idnToAscii($live_url)) !== false)
						{
							$url = $this->escape($item->error_url);
						}
						else
						{
							$url = $live_url . $this->escape($item->error_url);
						}
						?>
						
                    	<a href="<?php echo $url; ?>" title="<?php echo $url; ?>" target="_blank">
						<?php echo Web357Framework\Functions::shortenURL($item->error_url); ?> <img src="<?php echo 'components/com_fix404errorlinks/assets/icons/open_link.png'; ?>" alt="link" width="9" height="9" /></a>
					</td>
										
					<td>
						<?php if(substr($item->error_code, 0, 1) == 3) : ?>
							<span class="label label-success badge bg-success" style="margin-right: 5px;">
								<?php echo $item->error_code; ?>
							</span>
						<?php else: ?>
							<span class="label label-important badge bg-danger" style="margin-right: 5px;" >
								<?php echo $item->error_code; ?>
							</span>
						<?php endif; ?>

						<span style="margin-left: 5px;">
							<?php echo $item->error_message; ?>
						</span>
					</td>
					
					<?php if ($this->fixed_error404_urls == 'fixed'): ?>
					<td>

						<small style="margin-right: 5px;">
							<span class="hasTooltip dottedUnderline" title="<?php echo JText::_('COM_FIX404ERRORLINKS_MATCH_TYPE_LBL'); ?>">
							<?php echo JText::_('COM_FIX404ERRORLINKS_'.strtoupper($redirect_match_type)); ?>
							<?php if ($redirect_regex): ?>
								(<?php echo JText::_('COM_FIX404ERRORLINKS_REGEX'); ?>)
							<?php endif; ?>
							</span>
						</small>
						
						<?php 
						switch ($redirect_match_type) 
						{
							case 'full_url':
								$source_url = str_replace('administrator', '', JURI::base(true)) . '' . $this->escape($redirect_source_url);
                                $source_url_txt = str_replace('administrator', '', $this->escape($redirect_source_url));
								$link = true;
								$link_target = true;
								break;
							case 'contains_string':
								$source_url = str_replace('administrator', '', JURI::base(true)) . '' . $this->escape($redirect_source_url) . '';
                                $source_url_txt = str_replace('administrator', '', $this->escape($redirect_source_url));
								$link = true;
								$link_target = true;
								break;
							case 'start_with':
								$source_url = str_replace('administrator', '', JURI::base(true)) . '' . $this->escape($redirect_source_url). '';
                                $source_url_txt = str_replace('administrator', '', $this->escape($redirect_source_url));
								$link = true;
								$link_target = true;
								break;
							case 'end_with':
								$source_url = str_replace('administrator', '', JURI::base(true)) . '' . $this->escape($redirect_source_url);
                                $source_url_txt = str_replace('administrator', '', $this->escape($redirect_source_url));
								$link = true;
								$link_target = true;
								break;
							case 'find_and_replace':
								$source_url = str_replace('administrator', '', JURI::base(true)) . '' . $this->escape($redirect_source_url) . '';
                                $source_url_txt = str_replace('administrator', '', $this->escape($redirect_source_url));
								$link = false;
								$link_target = false;
								break;
							default:
								$source_url = str_replace('administrator', '', JURI::base(true)) . '' . $this->escape($redirect_source_url);
                                $source_url_txt = str_replace('administrator', '', $this->escape($redirect_source_url));
								$link = true;
								$link_target = true;
								break;
						}
						?>
						
						<?php if ($link): ?>
						<a href="<?php echo $source_url; ?>" title="<?php echo $source_url; ?>" target="_blank" rel="noopener noreferrer">
							<?php echo Web357Framework\Functions::shortenURL($source_url_txt, 100); ?>
							<img src="components/com_fix404errorlinks/assets/icons/open_link.png" alt="link" width="9" height="9" />
						</a>
						<?php else: ?>
						<strong>
							"<?php echo Web357Framework\Functions::shortenURL($source_url_txt, 100); ?>"
						</strong>
						<?php endif; ?>

						<?php if ($redirect_action_type == 'redirect_to_menu_item' || $redirect_action_type == 'redirect_to_url'): ?>
										
							<?php if(substr($redirect_action_code, 0, 1) == 3) : ?>
								<span class="label label-success badge bg-success hasTooltip" style="margin-left: 10px; margin-right: 5px;" title="<?php echo JText::_('COM_FIX404ERRORLINKS_ACTION_TYPE_'.strtoupper($redirect_action_type)); ?> <?php echo JText::_('COM_FIX404ERRORLINKS_WITH'); ?> <?php echo $redirect_action_code; ?> <?php echo JText::_('COM_FIX404ERRORLINKS_HTTP_CODE'); ?>">
									<?php echo $redirect_action_code; ?>
								</span>
							<?php elseif(substr($redirect_action_code, 0, 1) == 4) : ?>
								<span class="label label-important badge bg-danger hasTooltip" style="margin-left: 10px; margin-right: 5px;" title="<?php echo JText::_('COM_FIX404ERRORLINKS_ACTION_TYPE_'.strtoupper($redirect_action_type)); ?> <?php echo JText::_('COM_FIX404ERRORLINKS_WITH'); ?> <?php echo $redirect_action_code; ?> <?php echo JText::_('COM_FIX404ERRORLINKS_HTTP_CODE'); ?>">
									<?php echo $redirect_action_code; ?>
								</span>
							<?php else: ?>
								<span class="label label-important badge bg-danger hasTooltip" style="margin-left: 10px; margin-right: 5px;" title="<?php echo $redirect_action_type; ?> <?php echo JText::_('COM_FIX404ERRORLINKS_WITH'); ?> <?php echo $redirect_action_code; ?> <?php echo JText::_('COM_FIX404ERRORLINKS_HTTP_CODE'); ?>">
									<?php echo $redirect_action_code; ?>
								</span>
							<?php endif; ?>

							<?php 
							if ($redirect_action_type == 'redirect_to_menu_item')
							{
								$url = $this->router->build('index.php?Itemid=' . intval($redirect_target_url));
								$url = $url->toString();
								$target_url = str_replace($this->live_site .'/administrator', $this->live_site, $url);
                                $target_url_txt = str_replace(str_replace('/administrator', '', JURI::base(true)), '', $url);
							}
							else 
							{
								if ($redirect_match_type == 'find_and_replace')
								{
									$target_url = $redirect_target_url;
								}
								else
								{
									if (strpos($redirect_target_url,'http') !== false)
                                    {
                                        $target_url = $redirect_target_url;
										$target_url_txt = $redirect_target_url;
                                    }
                                    elseif (strpos($redirect_target_url,'www') !== false)
                                    {
                                        $target_url = 'http://'.$redirect_target_url;
										$target_url_txt = 'http://'.$redirect_target_url;
                                    }
                                    else
                                    {
                                        $target_url = str_replace('administrator', '', JURI::base(true)).$this->escape($redirect_target_url);
                                        $target_url_txt = "/".$this->escape($redirect_target_url);
                                    }
								}
							}
							?>

							<?php if ($link_target): ?>
							<a href="<?php echo $target_url; ?>" target="_blank" rel="noopener noreferrer">
								<strong><?php echo Web357Framework\Functions::shortenURL($target_url_txt, 100); ?></strong> 
								<img src="components/com_fix404errorlinks/assets/icons/open_link.png" alt="open link" width="9" height="9" />
							</a>
							<?php else: ?>
								<strong>"<?php echo Web357Framework\Functions::shortenURL($target_url, 100); ?>"</strong> 
							<?php endif; ?>

						<?php elseif ($redirect_action_type == 'error_404'): ?>

							<span class="label label-important badge bg-danger hasTooltip" title="<?php echo JText::_('COM_FIX404ERRORLINKS_REDIRECT_TO_AN_ERROR_PAGE'); ?> <?php echo JText::_('COM_FIX404ERRORLINKS_WITH'); ?> <?php echo $redirect_action_code; ?> <?php echo JText::_('COM_FIX404ERRORLINKS_HTTP_CODE'); ?>">
								<?php echo JText::sprintf(JText::_('COM_FIX404ERRORLINKS_ERROR_CODE_PAGE'), $redirect_action_code); ?>
							</span>
							
						<?php elseif ($redirect_action_type == 'do_nothing'): ?>

							<span class="label label-default badge bg-primary" style="margin-left:10px;">
								<?php echo JText::_('COM_FIX404ERRORLINKS_ACTION_TYPE_'.strtoupper($redirect_action_type)); ?>
							</span>

						<?php endif; ?>

					</td>
					<?php endif; ?>

					<td>
						<span>
						<?php
						if (!empty($item->datetime_created))
						{
							echo JHtml::_('date', $item->datetime_created, JText::_('COM_FIX404ERRORLINKS_DEFAULT_DATE_FORMAT_FULL'));
						}
						else 
						{
							echo Factory::getDbo()->getNullDate();
						}
						?>
						</span>
					</td>

				</tr>
			<?php 
			endforeach; 
			?>
                        
            </tbody>
            <tfoot>
            <tr>
                <td colspan="12"><?php echo $this->pagination->getListFooter(); ?></td>
            </tr>
            </tfoot>
		</table>

		<?php
        // BEGIN: Display a nice message if all 404 Error Links have been resolved
        if (count($this->items) == 0):
        ?>
            <div class="alert-box success"><?php echo JText::_('COM_FIX404ERRORLINKS_CONGRATS_NO_ERROR_LINKS');?></div>
        <?php
        // END: Display a nice message if all 404 Error Links have been resolved
        endif;
		?>
		
        <?php echo Web357Framework\Functions::showFooter("com_fix404errorlinks", JText::_('COM_FIX404ERRORLINKS_CLEAN')); ?>

    </div><!-- .j-main-container -->

<input type="hidden" name="task" value="" />
<input type="hidden" name="boxchecked" value="0" />
<?php echo JHtml::_('form.token'); ?>
</div>
</form>

<script>
	window.toggleField = function (id, task, field) {

		var f = document.adminForm,
			i = 0,
			cbx, cb = f[id];

		if (!cb) return false;

		while (true) {
			cbx = f['cb' + i];

			if (!cbx) break;

			cbx.checked = false;
			i++;
		}

		var inputField = document.createElement('input');

		inputField.type = 'hidden';
		inputField.name = 'field';
		inputField.value = field;
		f.appendChild(inputField);

		cb.checked = true;
		f.boxchecked.value = 1;
		window.submitform(task);

		return false;
	};
</script>