<?php
/* ======================================================
 # Fix 404 Error Links for Joomla! - v2.2.5 (pro version)
 # -------------------------------------------------------
 # For Joomla! CMS (v3.x)
 # Author: Web357 (Yiannis Christodoulou)
 # Copyright (©) 2014-2022 Web357. All rights reserved.
 # License: GNU/GPLv3, http://www.gnu.org/licenses/gpl-3.0.html
 # Website: https:/www.web357.com
 # Demo: https://demo.web357.com/joomla/fix-404-error-links
 # Support: support@web357.com
 # Last modified: Thursday 08 June 2023, 01:53:23 AM
 ========================================================= */
defined('_JEXEC') or die;
use Joomla\CMS\Factory;

require_once __DIR__ . '/script.install.helper.php';

class Com_Fix404errorlinksInstallerScript extends Com_Fix404errorlinksInstallerScriptHelper
{
	public $name           	= 'Fix 404 Error Links (Pro version)';
	public $alias          	= 'fix404errorlinks';
	public $extension_type 	= 'component';

	public function onAfterInstall($route)
	{
		$this->createTable();
		$this->alterTable();
		$this->updateTable();
		$this->transferErrorLinksFromTheOlderVersion();
		$this->transferRedirectsFromTheOlderVersion();
		$this->insertSampleData();
		$this->dropTableFromOlderVersions();
		$this->deleteOldFiles();
	}

	public function uninstall($adapter)
	{
		$this->dropTable();
	}

	private function updateTable()
	{
		$db = Factory::getDBO();
		$subQueries = array();
		
		/**
		 * #__fix404errorlinks_redirects
		 */
		$subqueries['#__fix404errorlinks_redirects'] = array();
		if (method_exists($db, 'getTableFields'))
		{
			$columns = $db->getTableFields('#__fix404errorlinks_redirects');
			$columns = empty($columns['#__fix404errorlinks_redirects']) ? array() : $columns['#__fix404errorlinks_redirects'];
		}
		else
		{
			$columns = $db->getTableColumns('#__fix404errorlinks_redirects');
		}

		if (empty($columns['state']))
		{
			$subQueries['#__fix404errorlinks_redirects'][] = "add `state` TINYINT(1) NOT NULL DEFAULT 1";
			$subQueries['#__fix404errorlinks_redirects'][] = "add index `state` (`state`)";
		}

		if (empty($columns['source_url']))
		{
			$subQueries['#__fix404errorlinks_redirects'][] = "add `source_url` VARCHAR(2048) NOT NULL";
			$subQueries['#__fix404errorlinks_redirects'][] = "add index `source_url` (`source_url`(190))";
		}

		// indexes
		$subqueries['#__fix404errorlinks_redirects'] = array();
		$subQueries['#__fix404errorlinks_redirects'][] = array('state');
		$subQueries['#__fix404errorlinks_redirects'][] = array('source_url', 190);
		$subQueries['#__fix404errorlinks_redirects'][] = array('target_url', 190);
		$subQueries['#__fix404errorlinks_redirects'][] = array('match_type');
		$subQueries['#__fix404errorlinks_redirects'][] = array('source_match_http_code');
		$subQueries['#__fix404errorlinks_redirects'][] = array('action_type');
		$subQueries['#__fix404errorlinks_redirects'][] = array('action_code');

		$subqueries['#__fix404errorlinks_error404logs'] = array();
		$subQueries['#__fix404errorlinks_error404logs'][] = array('state');
		$subQueries['#__fix404errorlinks_error404logs'][] = array('error_url', 190);
		$subQueries['#__fix404errorlinks_error404logs'][] = array('error_code');

		// alter tables
		if (!empty($subQueries))
		{
			try
			{
				foreach ($subQueries as $table => $queries)
				{
					foreach ($queries as $index_arr)
					{
						$index = $index_arr[0];

						if (!$this->indexExist($table, $index))
						{
							// prepend query
							$query = 'ALTER TABLE ' . $db->qn($table) . ' ADD INDEX `'.$index_arr[0].'` (`'.$index_arr[0].'`'.(isset($index_arr[1])?'('.$index_arr[1].')':'').')';

							try
							{
								$db->setQuery($query);
								$db->query();
							}
							catch (RuntimeException $e)
							{
								throw new Exception($e->getMessage());
							}
						}
					}
				}
			}
			catch (Exception $e)
			{
				Factory::getApplication()
				        ->enqueueMessage(
					        'Error while upgrading the database : ' . $e->getMessage()
					        . '. Fix 404 Error Links will probably not operate properly. Please, contact as at support@web357.com as soon as possible.'
				        );
			}
		}
	}

	private function createTable()
	{
		$query = "CREATE TABLE IF NOT EXISTS `#__fix404errorlinks_redirects` (
			`id` int(11) UNSIGNED NOT NULL AUTO_INCREMENT,
			`ordering` INT(11) NOT NULL DEFAULT 0,
			`state` TINYINT(1) NOT NULL DEFAULT 1,
			`checked_out` INT(11) NOT NULL DEFAULT 0,
			`checked_out_time` DATETIME NULL DEFAULT NULL,
			`created_by` INT(11) NOT NULL DEFAULT 0,
			`modified_by` INT(11) NOT NULL DEFAULT 0,
			`source_url` VARCHAR(2048) NOT NULL DEFAULT '',
			`target_url` VARCHAR(2048) NOT NULL DEFAULT '',
			`regex` tinyint(1) NOT NULL DEFAULT 0,
			`match_type` VARCHAR(20) NOT NULL DEFAULT '',
			`source_match_http_code` int(3) NOT NULL DEFAULT 0,
			`last_access` DATETIME NULL DEFAULT NULL,
			`action_type` VARCHAR(25) NOT NULL DEFAULT '',
			`action_code` int(3) NOT NULL DEFAULT 0,
			`notes` TEXT NOT NULL,
			`hits` int(11) NOT NULL DEFAULT 0,
			PRIMARY KEY (`id`),
		  	KEY `source_url` (`source_url` (190)),
			KEY `state` (`state`),
			KEY `target_url` (`target_url` (190)),
			KEY `match_type` (`match_type`),
			KEY `source_match_http_code` (`source_match_http_code`),
			KEY `action_type` (`action_type`),
			KEY `action_code` (`action_code`)
			) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 DEFAULT COLLATE=utf8mb4_unicode_ci;";

		try
		{
			$this->db->setQuery($query);
			$this->db->execute();
		}
		catch (RuntimeException $e)
		{
			throw new Exception($e->getMessage());
		}

		$query = "CREATE TABLE IF NOT EXISTS `#__fix404errorlinks_error404logs` (
			`id` int(11) UNSIGNED NOT NULL AUTO_INCREMENT,
			`ordering` INT(11) NOT NULL DEFAULT 0,
			`state` TINYINT(1) NOT NULL DEFAULT 1,
			`checked_out` INT(11) NOT NULL DEFAULT 0,
			`checked_out_time` DATETIME NULL DEFAULT NULL,
			`created_by` INT(11) NOT NULL DEFAULT 0,
			`modified_by` INT(11) NOT NULL DEFAULT 0,
			`error_url` VARCHAR(2048) NOT NULL DEFAULT '',
			`error_code` int(3) NOT NULL DEFAULT 0,
			`error_message` VARCHAR(100) NOT NULL DEFAULT '',
			`hits` int(11) NOT NULL DEFAULT 0,
			`datetime_created` DATETIME NULL DEFAULT NULL,
			`mailsent` TINYINT(1) NOT NULL DEFAULT 0,
			PRIMARY KEY (`id`),
		  	UNIQUE KEY `error_url` (`error_url` (190)),
			KEY `state` (`state`),
			KEY `error_code` (`error_code`)
			) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 DEFAULT COLLATE=utf8mb4_unicode_ci;";

		try
		{
			$this->db->setQuery($query);
			$this->db->execute();
		}
		catch (RuntimeException $e)
		{
			throw new Exception($e->getMessage());
		}
	}

	private function insertSampleData()
	{
		// connect to db
		$db = Factory::getDBO();

		// BEGIN: Insert some Error links
		$query = $db->getQuery(true);
		$query->select('COUNT(*)');
		$query->from($db->quoteName('#__fix404errorlinks_error404logs'));
		$db->setQuery($query);

		try
		{
			$fix404_errorlogs = (int) $db->loadResult();
		}
		catch (RuntimeException $e)
		{
			JError::raiseError(500, $e->getMessage());
			return false;
		}

		if ($fix404_errorlogs < 1)
		{
			$sample_data_errorlinks 	= array();
			$sample_data_errorlinks[] 	= array(
				'state' 				=> 1,
				'created_by' 			=> (int) Factory::getUser()->get('id'),
				'modified_by' 			=> (int) Factory::getUser()->get('id'),
				'error_url' 			=> $db->quote('sample-error-a'),
				'error_code' 			=> $db->quote('404'),
				'error_message' 		=> $db->quote('URL invalid'),
				'hits' 					=> 59,
				'datetime_created' 		=> $db->quote('2019-03-26 14:31:53')
			);
			$sample_data_errorlinks[] 	= array(
				'state' 				=> 1,
				'created_by' 			=> (int) Factory::getUser()->get('id'),
				'modified_by' 			=> (int) Factory::getUser()->get('id'),
				'error_url' 			=> $db->quote('sample-error-b'),
				'error_code' 			=> $db->quote('404'),
				'error_message' 		=> $db->quote('URL invalid'),
				'hits' 					=> 42,
				'datetime_created' 		=> $db->quote('2019-03-25 12:40:04')
			);
			$sample_data_errorlinks[] 	= array(
				'state' 				=> 1,
				'created_by' 			=> (int) Factory::getUser()->get('id'),
				'modified_by' 			=> (int) Factory::getUser()->get('id'),
				'error_url' 			=> $db->quote('sample-error-c'),
				'error_code' 			=> $db->quote('404'),
				'error_message' 		=> $db->quote('URL invalid'),
				'hits' 					=> 38,
				'datetime_created' 		=> $db->quote('2019-02-24 07:03:13')
			);
			$sample_data_errorlinks[] 	= array(
				'state' 				=> 1,
				'created_by' 			=> (int) Factory::getUser()->get('id'),
				'modified_by' 			=> (int) Factory::getUser()->get('id'),
				'error_url' 			=> $db->quote('sample-error-d'),
				'error_code' 			=> $db->quote('404'),
				'error_message' 		=> $db->quote('URL invalid'),
				'hits' 					=> 29,
				'datetime_created' 		=> $db->quote('2019-02-24 03:11:21')
			);
			$sample_data_errorlinks[] 	= array(
				'state' 				=> 1,
				'created_by' 			=> (int) Factory::getUser()->get('id'),
				'modified_by' 			=> (int) Factory::getUser()->get('id'),
				'error_url' 			=> $db->quote('sample-error-e'),
				'error_code' 			=> $db->quote('404'),
				'error_message' 		=> $db->quote('URL invalid'),
				'hits' 					=> 22,
				'datetime_created' 		=> $db->quote('2019-02-24 01:30:14')
			);
			$sample_data_errorlinks[] 	= array(
				'state' 				=> 1,
				'created_by' 			=> (int) Factory::getUser()->get('id'),
				'modified_by' 			=> (int) Factory::getUser()->get('id'),
				'error_url' 			=> $db->quote('sample-error-f'),
				'error_code' 			=> $db->quote('404'),
				'error_message' 		=> $db->quote('URL invalid'),
				'hits' 					=> 11,
				'datetime_created' 		=> $db->quote('2019-01-23 08:55:44')
			);
			$sample_data_errorlinks[] 	= array(
				'state' 				=> 1,
				'created_by' 			=> (int) Factory::getUser()->get('id'),
				'modified_by' 			=> (int) Factory::getUser()->get('id'),
				'error_url' 			=> $db->quote('sample-error-g'),
				'error_code' 			=> $db->quote('404'),
				'error_message' 		=> $db->quote('URL invalid'),
				'hits' 					=> 4,
				'datetime_created' 		=> $db->quote('2018-12-20 16:32:57')
			);

			// Insert columns.
			$columns = array('state', 'created_by', 'modified_by', 'error_url', 'error_code', 'error_message', 'hits', 'datetime_created');
			
			// Prepare the insert query.
			for ($i=0; $i<count($sample_data_errorlinks); $i++)
			{
				$query = $db->getQuery(true);
				$query
				->insert($db->quoteName('#__fix404errorlinks_error404logs'))
				->columns($db->quoteName($columns))
				->values(implode(',', $sample_data_errorlinks[$i]));
				$db->setQuery($query);
				$db->execute();
			}
		}
		// END: Insert some Error links

		// BEGIN: Insert some Redirects
		$query = $db->getQuery(true);
		$query->select('COUNT(*)');
		$query->from($db->quoteName('#__fix404errorlinks_redirects'));
		$db->setQuery($query);

		try
		{
			$fix404_redirects = (int) $db->loadResult();
		}
		catch (RuntimeException $e)
		{
			JError::raiseError(500, $e->getMessage());
			return false;
		}

		if ($fix404_redirects < 1)
		{
			$sample_data_redirects 		= array();
			$sample_data_redirects[] 	= array(
				'ordering' 				=> 1,
				'state' 				=> 1,
				'created_by' 			=> (int) Factory::getUser()->get('id'),
				'modified_by' 			=> (int) Factory::getUser()->get('id'),
				'source_url' 			=> $db->quote('sample-error-f'),
				'target_url' 			=> $db->quote('index.php?sample-valid-url-a'),
				'regex'					=> 0,
				'match_type'	 		=> $db->quote('full_url'),
				'source_match_http_code'=> 404,
				'last_access' 			=> $db->quote('2019-03-26 11:40:18'),
				'action_type'			=> $db->quote('redirect_to_url'),
				'action_code'			=> 301,
				'notes'					=> $db->quote('Sample installation data.'),
				'hits' 					=> 24
			);
			$sample_data_redirects[] 	= array(
				'ordering' 				=> 2,
				'state' 				=> 1,
				'created_by' 			=> (int) Factory::getUser()->get('id'),
				'modified_by' 			=> (int) Factory::getUser()->get('id'),
				'source_url' 			=> $db->quote('sample-error-g'),
				'target_url' 			=> $db->quote('index.php?sample-valid-url-b'),
				'regex'					=> 0,
				'match_type'	 		=> $db->quote('full_url'),
				'source_match_http_code'=> 404,
				'last_access' 			=> $db->quote('2019-03-25 18:44:10'),
				'action_type'			=> $db->quote('redirect_to_url'),
				'action_code'			=> 301,
				'notes'					=> $db->quote('Sample installation data.'),
				'hits' 					=> 19
			);
			$sample_data_redirects[] 	= array(
				'ordering' 				=> 3,
				'state' 				=> 1,
				'created_by' 			=> (int) Factory::getUser()->get('id'),
				'modified_by' 			=> (int) Factory::getUser()->get('id'),
				'source_url' 			=> $db->quote('index.php?valid-url-a'),
				'target_url' 			=> $db->quote('index.php?valid-url-b'),
				'regex'					=> 0,
				'match_type'	 		=> $db->quote('full_url'),
				'source_match_http_code'=> 404,
				'last_access' 			=> $db->quote('2019-03-24 11:15:37'),
				'action_type'			=> $db->quote('redirect_to_url'),
				'action_code'			=> 301,
				'notes'					=> $db->quote('Sample installation data.'),
				'hits' 					=> 11
			);
			$sample_data_redirects[] 	= array(
				'ordering' 				=> 4,
				'state' 				=> 1,
				'created_by' 			=> (int) Factory::getUser()->get('id'),
				'modified_by' 			=> (int) Factory::getUser()->get('id'),
				'source_url' 			=> $db->quote('index.php?valid-url-c'),
				'target_url' 			=> $db->quote('index.php?valid-url-d'),
				'regex'					=> 0,
				'match_type'	 		=> $db->quote('full_url'),
				'source_match_http_code'=> 404,
				'last_access' 			=> $db->quote('2019-03-24 08:22:10'),
				'action_type'			=> $db->quote('redirect_to_url'),
				'action_code'			=> 301,
				'notes'					=> $db->quote('Sample installation data.'),
				'hits' 					=> 4
			);
			$sample_data_redirects[] 	= array(
				'ordering' 				=> 5,
				'state' 				=> 1,
				'created_by' 			=> (int) Factory::getUser()->get('id'),
				'modified_by' 			=> (int) Factory::getUser()->get('id'),
				'source_url' 			=> $db->quote('index.php?valid-url-e'),
				'target_url' 			=> $db->quote('index.php?valid-url-f'),
				'regex'					=> 0,
				'match_type'	 		=> $db->quote('full_url'),
				'source_match_http_code'=> 404,
				'last_access' 			=> $db->quote('2019-03-24 05:11:57'),
				'action_type'			=> $db->quote('redirect_to_url'),
				'action_code'			=> 301,
				'notes'					=> $db->quote('Sample installation data.'),
				'hits' 					=> 2
			);
			
			// Insert columns.
			$columns = array('ordering', 'state', 'created_by', 'modified_by', 'source_url', 'target_url', 'regex', 'match_type', 'source_match_http_code', 'last_access', 'action_type', 'action_code', 'notes', 'hits');
			
			// Prepare the insert query.
			for ($i=0; $i<count($sample_data_redirects); $i++)
			{
				$query = $db->getQuery(true);
				$query
				->insert($db->quoteName('#__fix404errorlinks_redirects'))
				->columns($db->quoteName($columns))
				->values(implode(',', $sample_data_redirects[$i]));
				$db->setQuery($query);
				$db->execute();
			}
		}
		// END: Insert some Redirects
	}

	public function indexExist($table, $index)
	{	
		$db = $this->db;

		// Check if index exists first
		$query = 'SHOW INDEX FROM ' . $table . ' WHERE KEY_NAME = ' . $db->quote($index);
        $db->setQuery($query);
		$db->execute();
		
        if ($db->loadResult())
        {
        	return true;
		}
		
		return false;
	}

	public function dropIndex($table, $index)
	{	
		$db = $this->db;

		// Check if index exists first
		$query = 'SHOW INDEX FROM ' . $db->quoteName('#__' . $table) . ' WHERE KEY_NAME = ' . $db->quote($index);
        $db->setQuery($query);
        $db->execute();

        if (!$db->loadResult())
        {
        	return;
        }

        // Remove index
        $query = 'ALTER TABLE ' . $db->quoteName('#__' . $table) . ' DROP INDEX ' . $db->quoteName($index);
        $db->setQuery($query);
        $db->execute(); 
	}

	private function dropTable()
	{
		// connect to db
		$db = Factory::getDBO();

		// Check first if the table exists
		$query = "SHOW TABLES LIKE '" . $db->getPrefix() . "fix404errorlinks_redirects'";
		$db->setQuery($query);
		$table_exist = $db->loadResult();
		if ($table_exist)
		{
			$query = "DROP TABLE `#__fix404errorlinks_redirects`";
			$db->setQuery($query);
			$db->execute();
		}

		// Check first if the table exists
		$query = "SHOW TABLES LIKE '" . $db->getPrefix() . "fix404errorlinks_error404logs'";
		$db->setQuery($query);
		$table_exist = $db->loadResult();
		if ($table_exist)
		{
			$query = "DROP TABLE `#__fix404errorlinks_error404logs`";
			$db->setQuery($query);
			$db->execute();
		}

	}

	// Drop the tables from previous versions
	private function dropTableFromOlderVersions()
	{
		// connect to db
		$db = Factory::getDBO();

		// Check first if the table exists
		$query = "SHOW TABLES LIKE '" . $db->getPrefix() . "fix404_redirects'";
		$db->setQuery($query);
		$table_exist = $db->loadResult();
		if ($table_exist)
		{
			$query = "DROP TABLE `#__fix404_redirects`";
			$db->setQuery($query);
			$db->execute();
		}

		// Check first if the table exists
		$query = "SHOW TABLES LIKE '" . $db->getPrefix() . "fix404_errorlogs'";
		$db->setQuery($query);
		$table_exist = $db->loadResult();
		if ($table_exist)
		{
			$query = "DROP TABLE `#__fix404_errorlogs`";
			$db->setQuery($query);
			$db->execute();
		}

		// Check first if the table exists
		$query = "SHOW TABLES LIKE '" . $db->getPrefix() . "fix404errrolinks_404errorlogs'";
		$db->setQuery($query);
		$table_exist = $db->loadResult();
		if ($table_exist)
		{
			$query = "DROP TABLE `#__fix404errrolinks_404errorlogs`";
			$db->setQuery($query);
			$db->execute();
		}
	}

	private function alterTable()
	{
		/**
		 * BEGIN: Add default values to columns
		 */
		// Check first if the column exists
		$query = "SHOW COLUMNS FROM `" . $this->db->getPrefix() . "fix404errorlinks_error404logs` LIKE 'ordering'";
		$this->db->setQuery($query);
		$has_field = $this->db->loadResult();
		if ($has_field)
		{
			// Then, add column
			$query = 'ALTER TABLE ' . $this->db->quoteName('#__fix404errorlinks_error404logs') . ' ALTER ' . $this->db->quoteName('ordering') . ' SET DEFAULT 0;';
			$this->db->setQuery($query);
			$this->db->execute();
		}

		// Check first if the column exists
		$query = "SHOW COLUMNS FROM `" . $this->db->getPrefix() . "fix404errorlinks_redirects` LIKE 'ordering'";
		$this->db->setQuery($query);
		$has_field = $this->db->loadResult();
		if ($has_field)
		{
			// Then, add column
			$query = 'ALTER TABLE ' . $this->db->quoteName('#__fix404errorlinks_redirects') . ' ALTER ' . $this->db->quoteName('ordering') . ' SET DEFAULT 0;';
			$this->db->setQuery($query);
			$this->db->execute();
		}

		// Check first if the column exists
		$query = "SHOW COLUMNS FROM `" . $this->db->getPrefix() . "fix404errorlinks_error404logs` LIKE 'checked_out'";
		$this->db->setQuery($query);
		$has_field = $this->db->loadResult();
		if ($has_field)
		{
			// Then, add column
			$query = 'ALTER TABLE ' . $this->db->quoteName('#__fix404errorlinks_error404logs') . ' ALTER ' . $this->db->quoteName('checked_out') . ' SET DEFAULT 0;';
			$this->db->setQuery($query);
			$this->db->execute();
		}

		// Check first if the column exists
		$query = "SHOW COLUMNS FROM `" . $this->db->getPrefix() . "fix404errorlinks_redirects` LIKE 'checked_out'";
		$this->db->setQuery($query);
		$has_field = $this->db->loadResult();
		if ($has_field)
		{
			// Then, add column
			$query = 'ALTER TABLE ' . $this->db->quoteName('#__fix404errorlinks_redirects') . ' ALTER ' . $this->db->quoteName('checked_out') . ' SET DEFAULT 0;';
			$this->db->setQuery($query);
			$this->db->execute();
		}

		// Check first if the column exists
		$query = "SHOW COLUMNS FROM `" . $this->db->getPrefix() . "fix404errorlinks_error404logs` LIKE 'checked_out_time'";
		$this->db->setQuery($query);
		$has_field = $this->db->loadResult();
		if ($has_field)
		{
			// Then, add column
			$query = 'ALTER TABLE ' . $this->db->quoteName('#__fix404errorlinks_error404logs') . ' CHANGE ' . $this->db->quoteName('checked_out_time') . ' ' . $this->db->quoteName('checked_out_time') . ' DATETIME NULL DEFAULT NULL;';
			$this->db->setQuery($query);
			$this->db->execute();
		}

		// Check first if the column exists
		$query = "SHOW COLUMNS FROM `" . $this->db->getPrefix() . "fix404errorlinks_redirects` LIKE 'checked_out_time'";
		$this->db->setQuery($query);
		$has_field = $this->db->loadResult();
		if ($has_field)
		{
			// Then, add column
			$query = 'ALTER TABLE ' . $this->db->quoteName('#__fix404errorlinks_redirects') . ' CHANGE ' . $this->db->quoteName('checked_out_time') . ' ' . $this->db->quoteName('checked_out_time') . ' DATETIME NULL DEFAULT NULL;';
			$this->db->setQuery($query);
			$this->db->execute();
		}
		/**
		 * END: Add default values to columns
		 */

		// Check first if the column exists
		$query = "SHOW COLUMNS FROM `" . $this->db->getPrefix() . "fix404errorlinks_error404logs` LIKE 'mailsent'";
		$this->db->setQuery($query);
		$has_field = $this->db->loadResult();
		if (!$has_field)
		{
			// Then, add column
			$query = 'ALTER TABLE ' . $this->db->quoteName('#__fix404errorlinks_error404logs') . ' ADD ' . $this->db->quoteName('mailsent') . ' TINYINT(1) NOT NULL DEFAULT 0;';
			$this->db->setQuery($query);
			$this->db->execute();
		}

		// Check first if the column exists - added in 2.1.0 source_match_http_code
		$query = "SHOW COLUMNS FROM `" . $this->db->getPrefix() . "fix404errorlinks_redirects` LIKE 'source_match_http_code'";
		$this->db->setQuery($query);
		$has_field = $this->db->loadResult();
		if (!$has_field)
		{
			// Then, add column
			$query = 'ALTER TABLE ' . $this->db->quoteName('#__fix404errorlinks_redirects') . ' ADD ' . $this->db->quoteName('source_match_http_code') . ' int(3) NOT NULL DEFAULT "404" AFTER ' . $this->db->quoteName('match_type') . ';';
			$this->db->setQuery($query);
			$this->db->execute();
		}
		
		// Remove index
		$query = 'ALTER TABLE ' . $this->db->quoteName('#__fix404errorlinks_redirects') . ' DROP INDEX ' . $this->db->quoteName('source_url');
		$this->db->setQuery($query);
		$this->db->execute(); 
		
		// Then, add unique key
		$query = 'ALTER TABLE ' . $this->db->quoteName('#__fix404errorlinks_redirects') . ' ADD KEY '.$this->db->quoteName('source_url').' ('.$this->db->quoteName('source_url').' (190));';
		$this->db->setQuery($query);
		$this->db->execute();
	}

	private function alterTableExample()
	{
		// Check first if the column exists
		$query = "SHOW COLUMNS FROM `" . $this->db->getPrefix() . "fix404errorlinks_redirects` LIKE 'match_type'";
		$this->db->setQuery($query);
		$has_field = $this->db->loadResult();
		if (!$has_field)
		{
			// Then, add column
			$query = 'ALTER TABLE ' . $this->db->quoteName('#__fix404errorlinks_redirects') . ' ADD ' . $this->db->quoteName('match_type') . ' VARCHAR(255) NOT NULL' . ' AFTER ' . $this->db->quoteName('regex') . ';';
			$this->db->setQuery($query);
			$this->db->execute();
		}

		// Remove index
		$query = 'ALTER TABLE ' . $this->db->quoteName('#__fix404errorlinks_redirects') . ' DROP INDEX ' . $this->db->quoteName('source_url');
		$this->db->setQuery($query);
		$this->db->execute(); 
		
		// Then, add unique key
		$query = 'ALTER TABLE ' . $this->db->quoteName('#__fix404errorlinks_redirects') . ' ADD KEY '.$this->db->quoteName('source_url').' ('.$this->db->quoteName('source_url').' (190));';
		$this->db->setQuery($query);
		$this->db->execute();
	}

	private function transferErrorLinksFromTheOlderVersion()
	{
		// BEGIN: Migrate from version 1.x to 2.x
		// connect to db
		$db = Factory::getDBO();

		// Check first if the column exists
		$query = "SHOW TABLES LIKE '" . $db->getPrefix() . "fix404_errorlogs'";
		$db->setQuery($query);
		$table_exist = $db->loadResult();
		if (!$table_exist)
		{
			return;
		}

		// get data
		$query = $db->getQuery(true);
		$query->select($db->quoteName('a.state'));
		$query->select($db->quoteName('a.error_url'));
		$query->select($db->quoteName('a.error_code'));
		$query->select($db->quoteName('a.error_message'));
		$query->select($db->quoteName('a.timestamp'));
		$query->group($db->quoteName('a.error_url'));
		$query->from($db->quoteName('#__fix404_errorlogs', 'a'));
		$query->select('(SELECT COUNT(*) FROM #__fix404_errorlogs WHERE state = 1 AND error_url = a.error_url AND error_code = a.error_code) AS ' . $db->quoteName('hits')); // get hits from each url
		$db->setQuery($query);

		try
		{
			$old_fix404_errorlinks = $db->loadObjectlist();
		}
		catch (RuntimeException $e)
		{
			JError::raiseError(500, $e->getMessage());
			return false;
		}

		if (!empty($old_fix404_errorlinks))
		{
			foreach ($old_fix404_errorlinks as $v)
			{
				// Create a new query object.
				$query = $db->getQuery(true);
						
				// Insert columns.
				$columns = array('state', 'created_by', 'modified_by', 'error_url', 'error_code', 'error_message', 'hits', 'datetime_created');
				
				// Insert values.
				$values = array($v->state, (int) Factory::getUser()->get('id'), (int) Factory::getUser()->get('id'), $db->quote($v->error_url), (int)$v->error_code, $db->quote($v->error_message), (int) $v->hits, $db->quote($v->timestamp));
				
				// Prepare the insert query.
				$query
					->insert($db->quoteName('#__fix404errorlinks_error404logs'))
					->columns($db->quoteName($columns))
					->values(implode(',', $values));

				// Set the query using our newly populated query object and execute it.
				$db->setQuery($query);
				$db->execute();
			}
		}
		// END: Migrate from version 1.x to 2.x
	}

	private function transferRedirectsFromTheOlderVersion()
	{
		// BEGIN: Migrate from version 1.x to 2.x
		// connect to db
		$db = Factory::getDBO();

		// Check first if the column exists
		$query = "SHOW TABLES LIKE '" . $db->getPrefix() . "fix404_redirects'";
		$db->setQuery($query);
		$table_exist = $db->loadResult();
		if (!$table_exist)
		{
			return;
		}

		// get data from #__fix404_redirects
		$query = $db->getQuery(true);
		$query->select('*');
		$query->from($db->quoteName('#__fix404_redirects'));
		$db->setQuery($query);

		try
		{
			$old_fix404_redirects = $db->loadObjectlist();
		}
		catch (RuntimeException $e)
		{
			JError::raiseError(500, $e->getMessage());
			return false;
		}

		// get data from com_fix404errorlinks
		$query = $db->getQuery(true);
		$query->select($db->quoteName('source_url'));
		$query->from($db->quoteName('#__fix404errorlinks_redirects'));
		$db->setQuery($query);

		try
		{
			$source_urls_arr_db = $db->loadColumn();
		}
		catch (RuntimeException $e)
		{
			JError::raiseError(500, $e->getMessage());
			return false;
		}

		if (!empty($old_fix404_redirects))
		{
			// insert from com_redirect to com_fix404errorlinks
			$num=1;

			foreach ($old_fix404_redirects as $old_fix404_redirect)
			{
				$old_urls_arr = unserialize($old_fix404_redirect->old_urls_arr);
				foreach ($old_urls_arr as $source_url=>$match_type)
				{
					if (!in_array($source_url, $source_urls_arr_db))
					{
						// Create a new query object.
						$query = $db->getQuery(true);
								
						// Insert columns.
						$columns = array('state', 'created_by', 'modified_by', 'source_url', 'target_url', 'notes', 'match_type', 'source_match_http_code', 'action_type', 'action_code');
						
						// Insert values.
						$values = array($old_fix404_redirect->state, (int) Factory::getUser()->get('id'), (int) Factory::getUser()->get('id'), $db->quote($source_url), $db->quote($old_fix404_redirect->destination_url), $db->quote($old_fix404_redirect->comment), $db->quote($match_type), 404, $db->quote('redirect_to_url'), 301);
						
						// Prepare the insert query.
						$query
							->insert($db->quoteName('#__fix404errorlinks_redirects'))
							->columns($db->quoteName($columns))
							->values(implode(',', $values));
						
						// Set the query using our newly populated query object and execute it.
						$db->setQuery($query);
						$db->execute();
					}
					else
					{

						// Create a new query object.
						$query = $db->getQuery(true);
						
						// Fields to update.
						$fields = array(
							$db->quoteName('state') . ' = ' . $old_fix404_redirect->state,
							$db->quoteName('created_by') . ' = ' . (int) Factory::getUser()->get('id'),
							$db->quoteName('modified_by') . ' = ' . (int) Factory::getUser()->get('id'),
							$db->quoteName('target_url') . ' = ' . $db->quote($old_fix404_redirect->destination_url),
							$db->quoteName('notes') . ' = ' . $db->quote($old_fix404_redirect->comment),
							$db->quoteName('match_type') . ' = ' . $db->quote($match_type),
							$db->quoteName('source_match_http_code') . ' = ' . 404,
							$db->quoteName('action_type') . ' = ' . $db->quote('redirect_to_url'),
							$db->quoteName('action_code') . ' = ' . 301

						);
						
						// Conditions for which records should be updated.
						$conditions = array(
							$db->quoteName('source_url') . ' = ' . $db->quote($source_url)
						);
						
						$query->update($db->quoteName('#__fix404errorlinks_redirects'))->set($fields)->where($conditions);
						
						$db->setQuery($query);
						$db->execute();

					}
				}
			$num++;
			}
		}
		// END: Migrate from version 1.x to 2.x
	}

	private function deleteOldFiles()
	{
		$this->delete(
			array(
				JPATH_SITE . '/administrator/components/com_fix404errorlinks/assets/icons/loading.gif',
				JPATH_SITE . '/administrator/components/com_fix404errorlinks/assets/images/notice.png',
				JPATH_SITE . '/administrator/components/com_fix404errorlinks/assets/images/success.png',
				JPATH_SITE . '/administrator/components/com_fix404errorlinks/assets/images/warning.png',
				JPATH_SITE . '/administrator/components/com_fix404errorlinks/assets/images/error.png',
				JPATH_SITE . '/administrator/components/com_fix404errorlinks/assets/css/default.css',
				JPATH_SITE . '/administrator/components/com_fix404errorlinks/assets/js/jquery-1.11.3.min.js',
				JPATH_SITE . '/administrator/components/com_fix404errorlinks/elements/disableredirectplugin.php',
				JPATH_SITE . '/administrator/components/com_fix404errorlinks/elements/oldurls.php',
				JPATH_SITE . '/administrator/components/com_fix404errorlinks/helpers/danger_strings_list_array.php',
				JPATH_SITE . '/administrator/components/com_fix404errorlinks/helpers/listhelper.php',
				JPATH_SITE . '/administrator/components/com_fix404errorlinks/install/',
				JPATH_SITE . '/administrator/components/com_fix404errorlinks/views/error404logsdetailed/'
			)
		);
	}
}