<?php
/* ======================================================
 # Fix 404 Error Links for Joomla! - v2.2.5 (pro version)
 # -------------------------------------------------------
 # For Joomla! CMS (v3.x)
 # Author: Web357 (Yiannis Christodoulou)
 # Copyright (©) 2014-2022 Web357. All rights reserved.
 # License: GNU/GPLv3, http://www.gnu.org/licenses/gpl-3.0.html
 # Website: https:/www.web357.com
 # Demo: https://demo.web357.com/joomla/fix-404-error-links
 # Support: support@web357.com
 # Last modified: Thursday 08 June 2023, 01:53:23 AM
 ========================================================= */
defined('_JEXEC') or die;

jimport('joomla.application.component.modellist');

/**
 * Methods supporting a list of Fix404errorlinks records.
 *
 * @since  1.6
 */
class Fix404errorlinksModelFix404errorlinks extends JModelList
{

/**
	* Constructor.
	*
	* @param   array  $config  An optional associative array of configuration settings.
	*
	* @see        JController
	* @since      1.6
	*/
	public function __construct($config = array())
	{
		parent::__construct($config);
	}

	public function getLatestUniqueErrorURLs()
	{
		$db = $this->getDbo();
		$model = JModelLegacy::getInstance('Error404logs', 'Fix404errorlinksModel', array('ignore_request' => true));
		$model->setState('filter.fixed_error404_urls', 'non_fixed');
		$model->setState('list.ordering', 'a.datetime_created');
		$model->setState('list.direction', 'DESC');
		$query = $model->getListQuery();
		$query->setLimit('5');

		try
		{
			$db->setQuery($query);
			return $db->loadObjectlist();
		}
		catch (RuntimeException $e)
		{
			JError::raiseError(500, $e->getMessage());
		}
	}

	/**
	 * Get the count of unique error urls
	 *
	 * @parameter ($days) e.g. 30
	 * @parameter ($fixed) e.g. 'fixed' or 'non-fixed, leave blank for all error links
	 * @return  (int) 
	 */
	public function getCountErrorURLs($days = '', $fixed = '')
	{
		$db = $this->getDbo();
		$model = JModelLegacy::getInstance('Error404logs', 'Fix404errorlinksModel', array('ignore_request' => true));
		if (!empty($fixed))
		{
			$model->setState('filter.fixed_error404_urls', $fixed);
		}
		else
		{
			$model->setState('filter.fixed_error404_urls', 'all');
		}
		$query = $model->getListQuery();

		if (!empty($days))
		{
			$query->where('a.datetime_created >= DATE(NOW()) - INTERVAL '.(int) $days.' DAY ');
		}

		try
		{
			$db->setQuery($query);
			return count($db->loadObjectlist());
		}
		catch (RuntimeException $e)
		{
			JError::raiseError(500, $e->getMessage());
		}
	}

	public function getMostHitErrorURLs()
	{
		$db = $this->getDbo();
		$model = JModelLegacy::getInstance('Error404logs', 'Fix404errorlinksModel', array('ignore_request' => true));
		$model->setState('filter.fixed_error404_urls', 'non_fixed');
		$query = $model->getListQuery();
		$query->setLimit('5');

		try
		{
			$db->setQuery($query);
			return $db->loadObjectlist();
		}
		catch (RuntimeException $e)
		{
			JError::raiseError(500, $e->getMessage());
		}
	}

	public function getMostHitRedirections()
	{
		$db = $this->getDbo();
		$model = JModelLegacy::getInstance('Redirects', 'Fix404errorlinksModel', array('ignore_request' => true));
		$model->setState('list.ordering', 'hits');
		$model->setState('list.direction', 'DESC');
		$query = $model->getListQuery();
		$query->setLimit('5');
		$query->where('a.state = 1');

		try
		{
			$db->setQuery($query);
			return $db->loadObjectlist();
		}
		catch (RuntimeException $e)
		{
			JError::raiseError(500, $e->getMessage());
		}
	}

	public function getCountRedirections()
	{
		$db = $this->getDbo();
		$model = JModelLegacy::getInstance('Redirects', 'Fix404errorlinksModel', array('ignore_request' => true));
		$query = $model->getListQuery();
		$query->where('a.state = 1');

		try
		{
			$db->setQuery($query);
			return count($db->loadObjectlist());
		}
		catch (RuntimeException $e)
		{
			JError::raiseError(500, $e->getMessage());
		}
	}
}