<?php
/* ======================================================
 # Fix 404 Error Links for Joomla! - v2.2.5 (pro version)
 # -------------------------------------------------------
 # For Joomla! CMS (v3.x)
 # Author: Web357 (Yiannis Christodoulou)
 # Copyright (©) 2014-2022 Web357. All rights reserved.
 # License: GNU/GPLv3, http://www.gnu.org/licenses/gpl-3.0.html
 # Website: https:/www.web357.com
 # Demo: https://demo.web357.com/joomla/fix-404-error-links
 # Support: support@web357.com
 # Last modified: Thursday 08 June 2023, 01:53:23 AM
 ========================================================= */
// No direct access to this file
defined('_JEXEC') or die;
use Joomla\CMS\Factory;
JHtml::addIncludePath(JPATH_COMPONENT . '/helpers/');
JHtml::_('bootstrap.tooltip');
JFormHelper::loadFieldClass('text');

class JFormFieldW357url extends JFormFieldText
{
    /**
     *  Method to render the input field
     *
     *  @return  string  
     */
    function getInput()
    {   
        // Adds an extra info label next to input
		$html 	= array();
		$html[] = parent::getInput();

        // Adds a link next to input
		$preview = $this->element['preview'];
		$field = 'jform_'.$this->element['name'];

        if ($preview)
        {
			$live_url = str_replace('/administrator','',JURI::base());
			$empty_url_txt = JText::_('COM_FIX404ERRORLINKS_EMPTY_URL');
			$preview_link_txt = JText::_('COM_FIX404ERRORLINKS_PREVIEW_LINK');
			$javascript = <<<JS

			function urlRedirection(e)
			{
				var field_url = document.getElementById(e).value;

				if (field_url) 
				{
					if (field_url.match(/http:\/\//) || field_url.match(/www./))
					{
						if (field_url.match(/www./))
						{
							var url_to_redirect = "http://" + field_url;
						}
						else
						{
							var url_to_redirect = field_url;
						}
					}
					else
					{
						var url_to_redirect = "$live_url" + field_url;
					}

					window.open(url_to_redirect, '_blank');
				}
				else
				{
					alert("$empty_url_txt");
					return false;
				}
			}

			function showURL(th,e)
			{
				var field_url = document.getElementById(e).value;
				if (field_url) 
				{
					if (field_url.match(/http:\/\//) || field_url.match(/www./))
					{
						if (field_url.match(/www./))
						{
							var url_to_redirect = "http://" + field_url;
						}
						else
						{
							var url_to_redirect = field_url;
						}
					}
					else
					{
						var url_to_redirect = "$live_url" + field_url;
					}

					th.title = "$preview_link_txt" + ": " + url_to_redirect;
				}
			}
JS;
			Factory::getDocument()->addScriptDeclaration($javascript);
			
            //$html[] = '<button type="button" class="btn btn-small" onclick="urlRedirection(\''.$field.'\')" style="margin-left: 5px;" title="'.JText::_('COM_FIX404ERRORLINKS_PREVIEW_LINK').'" onmouseover="showURL(this, \''.$field.'\')"><span class="icon-link"></span></button>';
        }

        return implode('', $html);
    }
}