<?php
/* ======================================================
 # Fix 404 Error Links for Joomla! - v2.2.5 (pro version)
 # -------------------------------------------------------
 # For Joomla! CMS (v3.x)
 # Author: Web357 (Yiannis Christodoulou)
 # Copyright (©) 2014-2022 Web357. All rights reserved.
 # License: GNU/GPLv3, http://www.gnu.org/licenses/gpl-3.0.html
 # Website: https:/www.web357.com
 # Demo: https://demo.web357.com/joomla/fix-404-error-links
 # Support: support@web357.com
 # Last modified: Thursday 08 June 2023, 01:53:23 AM
 ========================================================= */
// No direct access to this file
defined('_JEXEC') or die;
use Joomla\CMS\Factory;
JHtml::addIncludePath(JPATH_COMPONENT . '/helpers/');
JHtml::_('bootstrap.tooltip');

class JFormFieldW357menuitem extends JFormFieldMenuitem
{
    /**
     *  Method to render the input field
     *
     *  @return  string  
     */
    function getInput()
    {   
        // Adds an extra info label next to input
		$html 	= array();
		$html[] = parent::getInput();

        // Adds a link next to input
		$preview = $this->element['preview'] == 'true' ? true : false;
		$preview_link_txt = JText::_('COM_FIX404ERRORLINKS_PREVIEW_LINK');
		$field = 'jform_'.$this->element['name'];

		if ($preview)
        {
			$live_url = str_replace('/administrator','',JURI::base());
			$empty_url_txt = JText::_('COM_FIX404ERRORLINKS_EMPTY_URL');
			$javascript = <<<JS

			function menuitemRedirection(e)
			{
				var field_menu_item = document.getElementById(e).value;

				if (field_menu_item) 
				{
					var menu_item_url_to_redirect = "$live_url" + "index.php?Itemid=" + field_menu_item;
					window.open(menu_item_url_to_redirect, '_blank');
				}
				else
				{
					alert("$empty_url_txt");
					return false;
				}
			}

			function showMenuItemURL(th,e)
			{
				var field_menu_item = document.getElementById(e).value;
				if (field_menu_item) 
				{
					var menu_item_url_to_redirect = "$live_url" + "index.php?Itemid=" + field_menu_item;
					th.title = "$preview_link_txt" + ": " + menu_item_url_to_redirect;
				}
			}
JS;
			Factory::getDocument()->addScriptDeclaration($javascript);
			
            //$html[] = '<button type="button" class="btn btn-small" onclick="menuitemRedirection(\''.$field.'\')" style="margin-left: 5px;" title="'.JText::_('COM_FIX404ERRORLINKS_PREVIEW_LINK').'" onmouseover="showMenuItemURL(this, \''.$field.'\')"><span class="icon-link"></span></button>';
        }

        return implode('', $html);
    }
}