<?php
/* ======================================================
 # Fix 404 Error Links for Joomla! - v2.2.5 (pro version)
 # -------------------------------------------------------
 # For Joomla! CMS (v3.x)
 # Author: Web357 (Yiannis Christodoulou)
 # Copyright (©) 2014-2022 Web357. All rights reserved.
 # License: GNU/GPLv3, http://www.gnu.org/licenses/gpl-3.0.html
 # Website: https:/www.web357.com
 # Demo: https://demo.web357.com/joomla/fix-404-error-links
 # Support: support@web357.com
 # Last modified: Thursday 08 June 2023, 01:53:23 AM
 ========================================================= */
defined('_JEXEC') or die;
use Joomla\CMS\Factory;
// import the Joomla modellist library
jimport('joomla.application.component.modellist');

class Fix404errorlinksModelError404logs extends JModelList
{
	public function __construct($config = array()) {
        if (empty($config['filter_fields'])) {
            $config['filter_fields'] = array(
                'id', 'a.id',
                'error_url', 'a.error_url',
                'error_code', 'a.error_code',
                'error_message', 'a.error_message',
                'hits', 'a.hits',
                'state', 'a.state',
                'datetime_created', 'a.datetime_created'
            );
        }

        parent::__construct($config);
    }
	
	protected function populateState($ordering = null, $direction = null)
	{
        // Initialise variables.
        $app = Factory::getApplication('administrator');

        // Load the filter state.
        $search = $app->getUserStateFromRequest($this->context . '.filter.search', 'filter_search');
        $this->setState('filter.search', $search);

        $published = $app->getUserStateFromRequest($this->context . '.filter.state', 'filter_published', '', 'string');
        $this->setState('filter.state', $published);

        // List state information.
        $limit = 0;
        
        // Receive & set list options
        $default_limit = $app->getUserStateFromRequest('global.list.limit', 'limit', $app->get('list_limit'), 'INT');
        if ($list = $app->getUserStateFromRequest($this->context . '.list', 'list', array(), 'array')){
            if (isset($list['limit'])){
                $limit = (int)$list['limit'];
            } else {
                $limit = $default_limit;
            }
        } else {
             $limit = $default_limit;
        }
        $this->setState('list.limit', $limit);
         
        $value = $app->getUserStateFromRequest($this->context . '.limitstart', 'limitstart', 0);
        $limitstart = ($limit != 0 ? (floor($value / $limit) * $limit) : 0);
        $this->setState('list.start', $limitstart);        

        // Load the parameters.
        $params = JComponentHelper::getParams('com_fix404errorlinks');
        $this->setState('params', $params);

        // List state information.
        parent::populateState('a.hits', 'desc');
    }

	 /**
     * Method to get a store id based on model configuration state.
     *
     * This is necessary because the model is used by the component and
     * different modules that might need different sets of data or different
     * ordering requirements.
     *
     * @param	string		$id	A prefix for the store id.
     * @return	string		A store id.
     * @since	1.6
     */
    protected function getStoreId($id = '') {
        // Compile the store id.
        $id.= ':' . $this->getState('filter.search');
        $id.= ':' . $this->getState('filter.state');

        return parent::getStoreId($id);
    }

    // get redirect urls
	public static function getRedirects()
	{	
		$db = Factory::getDBO();
		$model = JModelLegacy::getInstance('Redirects', 'Fix404errorlinksModel', array('ignore_request' => true));
        $model->setState('filter.state', '1');
        $query = $model->getListQuery();
        $db->setQuery($query);
        
		try
		{
			return $db->loadObjectlist();
		}
		catch (RuntimeException $e)
		{
			JError::raiseError(500, $e->getMessage());
			return false;
		}
	}
   
    // get redirect urls
	public static function getRedirectDetailsFromSourceURL($source_url)
	{	
		$db = Factory::getDBO();
		$query = $db->getQuery(true);
		$query->select($db->quoteName('id'));
		$query->select($db->quoteName('source_url'));
		$query->select($db->quoteName('target_url'));
        $query->select($db->quoteName('match_type'));
        $query->select($db->quoteName('source_match_http_code'));
		$query->select($db->quoteName('action_type'));
		$query->select($db->quoteName('action_code'));
		$query->select($db->quoteName('regex'));
        $query->from($db->quoteName('#__fix404errorlinks_redirects'));
        $conditions_like_arr = array();

        // full_url
        $conditions_like_arr[] = '(match_type = '.$db->Quote('full_url').' AND (IF (regex=1, '.$db->Quote('' . $db->escape($source_url, true) . '').' REGEXP CONCAT("^", source_url, "$"), source_url = '.$db->Quote('' . $db->escape($source_url, true) . '').')))';
        
        // contains_string
        $conditions_like_arr[] = '(match_type = '.$db->Quote('contains_string').' AND (IF (regex=1, '.$db->Quote('' . $db->escape($source_url, true) . '').' REGEXP source_url, '.$db->Quote('' . $db->escape($source_url, true) . '').' LIKE CONCAT("%", source_url, "%"))))';
        
        // start_with
        $conditions_like_arr[] = '(match_type = '.$db->Quote('start_with').' AND (IF (regex=1, '.$db->Quote('' . $db->escape($source_url, true) . '').' REGEXP CONCAT("^", source_url), '.$db->Quote('' . $db->escape($source_url, true) . '').' LIKE CONCAT( source_url, "%"))))';
        
        // end_with
        $conditions_like_arr[] = '(match_type = '.$db->Quote('end_with').' AND (IF (regex=1, '.$db->Quote('' . $db->escape($source_url, true) . '').' REGEXP CONCAT(source_url, "$"), '.$db->Quote('' . $db->escape($source_url, true) . '').' LIKE CONCAT("%", source_url))))';
        
        // find_and_replace
        $conditions_like_arr[] = '(match_type = '.$db->Quote('find_and_replace').' AND (IF (regex=1, '.$db->Quote('' . $db->escape($source_url, true) . '').' REGEXP source_url, '.$db->Quote('' . $db->escape($source_url, true) . '').' LIKE CONCAT("%", source_url, "%"))))';
        
        $query->where('1=1')->andWhere($conditions_like_arr,'OR');
        $query->where($db->quoteName('state') . ' = 1');
        $query->where('('.$db->quoteName('action_type') . ' = '.$db->quote('redirect_to_url') . ' OR ' .$db->quoteName('action_type') . ' = '.$db->quote('redirect_to_menu_item'). ' OR ' .$db->quoteName('action_type') . ' = '.$db->quote('do_nothing').')');

        $db->setQuery($query);

		try
		{
			return $db->loadObject();
		}
		catch (RuntimeException $e)
		{
			JError::raiseError(500, $e->getMessage());
			return false;
		}
	}

    public function getDangerStringsList()
    {
        $default_danger_strings_arr = array(
			"phpmyadmin",
			"admin_area",
			"checkadmin",
			"webmaster", 
			"sysadm", 
		);

        // Get Component Params
		$comParams                          = JComponentHelper::getParams('com_fix404errorlinks');
        $danger_strings_list_default_value  = implode("\n", $default_danger_strings_arr);
        $danger_strings_list                = $comParams->get('dangerstringslist', $danger_strings_list_default_value);
        $danger_strings_list_arr            = explode("\n", $danger_strings_list);
        $danger_strings_list_arr            = array_map('trim',$danger_strings_list_arr);

        return (array) $danger_strings_list_arr;
    }

    // Check if is a danger url
	public function isDangerURL($source_url)
	{	
        $danger_strings_list_arr = $this->getDangerStringsList();

        // Check if the error url is included in the danger strings list array
        if (!empty($danger_strings_list_arr))
        {
            foreach ($danger_strings_list_arr as $danger_string)
            {
                $danger_string = trim($danger_string);
                if (!empty($danger_string) && strpos($source_url, $danger_string) !== false) // check if danger string exists on the given url
                {
                    return true;
                }
            }
        }

        return false;
	}

    protected function getListQuery()
	{		
		// get Redirects
        $redirects = $this->getRedirects();
       
		// Create a new query object.
		$db = $this->getDbo();
        $query = $db->getQuery(true);
		
		// Select the required fields from the table.
        $query->select(
                $this->getState(
                        'list.select', 'a.*'
                )
        );
        $query->from('#__fix404errorlinks_error404logs AS a');
        $query->group('a.error_url');

		// Join over the users for the checked out user.
		$query->select('uc.name AS editor');
		$query->join('LEFT', '#__users AS uc ON uc.id=a.checked_out');
		
		// Join over the user field 'created_by'
		$query->select('created_by.name AS created_by');
		$query->join('LEFT', '#__users AS created_by ON created_by.id = a.created_by');
        
        // BEGIN: Filter by fixed_error404_urls
        $conditions_like_arr = array();
        $conditions_not_like_arr = array();
		$state_fixed_error404_urls = $this->getState('filter.fixed_error404_urls');
        $fixed_error404_urls = (!empty($state_fixed_error404_urls)) ? $state_fixed_error404_urls : 'non_fixed';
        switch ($fixed_error404_urls) 
        {
            case 'non_fixed':
                // non fixed
                foreach ($redirects as $redirect)
                {
                    $redirect->source_url = str_replace('?', '\?', $redirect->source_url); // shorturl.at/azRY8
                    $redirect->source_url = str_replace('+', '\+', $redirect->source_url); // shorturl.at/azRY8

                    switch ($redirect->match_type)
                    {
                        case 'full_url':
                            if($redirect->regex)
                            {
                                $source_url = $db->Quote('^' . $db->escape($redirect->source_url, true) . '$');
                                $conditions_not_like_arr[] = 'a.error_url NOT REGEXP '.$source_url;
                            }
                            else
                            {
                                $source_url = $db->Quote('' . $db->escape($redirect->source_url, true) . '');
                                $conditions_not_like_arr[] = 'a.error_url != '.$source_url;
                            }
                            break;
                        case 'contains_string':
                            if($redirect->regex)
                            {
                                $source_url = $db->Quote('' . $db->escape($redirect->source_url, true) . '');
                                $conditions_not_like_arr[] = 'a.error_url NOT REGEXP '.$source_url;
                            }
                            else
                            {
                                $source_url = $db->Quote('%' . $db->escape($redirect->source_url, true) . '%');
                                $conditions_not_like_arr[] = 'a.error_url NOT LIKE '.$source_url;
                            }
                            break;
                        case 'start_with':
                            if($redirect->regex)
                            {
                                $source_url = $db->Quote('^' . $db->escape($redirect->source_url, true) . '');
                                $conditions_not_like_arr[] = 'a.error_url NOT REGEXP '.$source_url;
                            }
                            else
                            {
                                $source_url = $db->Quote('' . $db->escape($redirect->source_url, true) . '%');
                                $conditions_not_like_arr[] = 'a.error_url NOT LIKE '.$source_url;
                            }
                            break;
                        case 'end_with':
                            if($redirect->regex)
                            {
                                $source_url = $db->Quote('' . $db->escape($redirect->source_url, true) . '$');
                                $conditions_not_like_arr[] = 'a.error_url NOT REGEXP '.$source_url;
                            }
                            else
                            {
                                $source_url = $db->Quote('%' . $db->escape($redirect->source_url, true) . '');
                                $conditions_not_like_arr[] = 'a.error_url NOT LIKE '.$source_url;
                            }
                            break;
                        case 'find_and_replace':
                            if($redirect->regex)
                            {
                                $source_url = $db->Quote('' . $db->escape($redirect->source_url, true) . '');
                                $conditions_not_like_arr[] = 'a.error_url NOT REGEXP '.$source_url;
                            }
                            else
                            {
                                $source_url = $db->Quote('%' . $db->escape($redirect->source_url, true) . '%');
                                $conditions_not_like_arr[] = 'a.error_url NOT LIKE '.$source_url;
                            }                               
                            break;
                        default:
                            if($redirect->regex)
                            {
                                $source_url = $db->Quote('' . $db->escape($redirect->source_url, true) . '');
                                $conditions_not_like_arr[] = 'a.error_url NOT REGEXP '.$source_url;
                            }
                            else
                            {
                                $source_url = $db->Quote('%' . $db->escape($redirect->source_url, true) . '%');
                                $conditions_not_like_arr[] = 'a.error_url NOT LIKE '.$source_url;
                            }
                            break;

                    }
                }
            break;
            case 'fixed':
                if (empty($redirects))
                {
                    $conditions_like_arr[] = '1=2';
                }

                // fixed
                foreach ($redirects as $redirect)
                {
                    $redirect->source_url = str_replace('?', '\?', $redirect->source_url); // shorturl.at/azRY8
                    $redirect->source_url = str_replace('+', '\+', $redirect->source_url); // shorturl.at/azRY8
                    
                    switch ($redirect->match_type)
                    {
                        case 'full_url':
                            if($redirect->regex)
                            {
                                $source_url = $db->Quote('^' . $db->escape($redirect->source_url, true) . '$');
                                $conditions_like_arr[] = 'a.error_url REGEXP '.$source_url;
                            }
                            else
                            {
                                $source_url = $db->Quote('' . $db->escape($redirect->source_url, true) . '');
                                $conditions_like_arr[] = 'a.error_url = '.$source_url;
                            }
                            break;
                        case 'contains_string':
                            if($redirect->regex)
                            {
                                $source_url = $db->Quote('' . $db->escape($redirect->source_url, true) . '');
                                $conditions_like_arr[] = 'a.error_url REGEXP '.$source_url;
                            }
                            else
                            {
                                $source_url = $db->Quote('%' . $db->escape($redirect->source_url, true) . '%');
                                $conditions_like_arr[] = 'a.error_url LIKE '.$source_url;
                            }
                            break;
                        case 'start_with':
                            if($redirect->regex)
                            {
                                $source_url = $db->Quote('^' . $db->escape($redirect->source_url, true) . '');
                                $conditions_like_arr[] = 'a.error_url REGEXP '.$source_url;
                            }
                            else
                            {
                                $source_url = $db->Quote('' . $db->escape($redirect->source_url, true) . '%');
                                $conditions_like_arr[] = 'a.error_url LIKE '.$source_url;
                            }
                            break;
                        case 'end_with':
                            if($redirect->regex)
                            {
                                $source_url = $db->Quote('' . $db->escape($redirect->source_url, true) . '$');
                                $conditions_like_arr[] = 'a.error_url REGEXP '.$source_url;
                            }
                            else
                            {
                                $source_url = $db->Quote('%' . $db->escape($redirect->source_url, true) . '');
                                $conditions_like_arr[] = 'a.error_url LIKE '.$source_url;
                            }
                            break;
                        case 'find_and_replace':
                            if($redirect->regex)
                            {
                                $source_url = $db->Quote('' . $db->escape($redirect->source_url, true) . '');
                                $conditions_like_arr[] = 'a.error_url REGEXP '.$source_url;
                            }
                            else
                            {
                                $source_url = $db->Quote('%' . $db->escape($redirect->source_url, true) . '%');
                                $conditions_like_arr[] = 'a.error_url LIKE '.$source_url;
                            }                               
                            break;
                        default:
                            if($redirect->regex)
                            {
                                $source_url = $db->Quote('' . $db->escape($redirect->source_url, true) . '');
                                $conditions_like_arr[] = 'a.error_url REGEXP '.$source_url;
                            }
                            else
                            {
                                $source_url = $db->Quote('%' . $db->escape($redirect->source_url, true) . '%');
                                $conditions_like_arr[] = 'a.error_url LIKE '.$source_url;
                            }
                            break;
                    }
                }
            break;
            default:
                // show all
        }

        if (!empty($conditions_not_like_arr))
        {
            $query->where('1=1')->andWhere($conditions_not_like_arr,'AND');
        }

        if (!empty($conditions_like_arr))
        {
            $query->where('1=1')->andWhere($conditions_like_arr,'OR');
        }
        // END: Filter by fixed_error404_urls

        // Filter by danger_urls
		$danger_urls = $this->getState('filter.danger_urls');
        $danger_strings_list_arr = $this->getDangerStringsList();

		if (!empty($danger_urls))
		{
            switch ($danger_urls) 
            {
                case 'is_danger':
		            $query->where("a.error_url REGEXP '" . implode($danger_strings_list_arr, "|") . "'");
                    break;
                case 'non_danger':
		            $query->where("a.error_url NOT REGEXP '" . implode($danger_strings_list_arr, "|") . "'");
                    break;
            }
        }

        // Filter by type_of_visitor
		$type_of_visitor = $this->getState('filter.type_of_visitor');
		if (!empty($type_of_visitor))
		{
            switch ($type_of_visitor) 
            {
                case 'bot':
		            $query->where("a.user_agent LIKE ".$db->Quote('%' . $db->escape('bot', true) . '%'));
                    break;
                case 'human':
		            $query->where("a.user_agent NOT LIKE ".$db->Quote('%' . $db->escape('bot', true) . '%'));
                    break;
            }
        }
	
		// Filter by published state
		$published = $this->getState('filter.state');
		if (is_numeric($published)) {
			$query->where('a.state = '.(int) $published);
		} else if ($published === '') {
            $query->where('a.state = 1');
		}
		
        // Filter by search in title
        $search = $this->getState('filter.search');
        if (!empty($search)) {
            if (stripos($search, 'id:') === 0) {
                $query->where('a.id = ' . (int) substr($search, 3));
            } else {
                $search = $db->Quote('%' . $db->escape($search, true) . '%');
                $query->where('( a.error_url LIKE '.$search.'  OR a.error_code LIKE '.$search.' OR a.error_message LIKE '.$search.')');
            }
        }

        // Filter by action_code
		$action_code = $this->getState('filter.action_code');
		if (!empty($action_code))
		{
			$query->where('a.error_code = ' . (int) $action_code);
        }

        // Filter by date_range
		$date_range = $this->getState('filter.date_range');
		if (!empty($date_range))
		{
			// Filter by date
            switch ($date_range) {
                case '3m':
                    $query->where('a.datetime_created >= DATE(NOW()) - INTERVAL 3 MONTH');
                    break;
                case '30d':
                    $query->where('a.datetime_created >= DATE(NOW()) - INTERVAL 30 DAY');
                    break;
                case '7d':
                    $query->where('a.datetime_created >= DATE(NOW()) - INTERVAL 7 DAY');
                    break;
                case 'today':
                    $query->where('DATE(a.datetime_created) = CURDATE()');
                    break;
                default:
                    // all days
            }
        }

        // Add the list ordering clause.
		$orderCol  = $this->state->get('list.ordering', "a.hits");
		$orderDirn = $this->state->get('list.direction', "DESC");

		if ($orderCol && $orderDirn)
		{
			$query->order($db->escape($orderCol . ' ' . $orderDirn));
        }

		return $query;
    }
	
	public function getItems()
	{
        $items = parent::getItems();
        return $items;
    }

    public function getFixedErrorURLs()
    {        
        // Get the model
		$db = Factory::getDBO();
        $query = $this->getListQuery();
        $db->setQuery($query);

        try
		{
			return $db->loadObjectlist();
		}
		catch (RuntimeException $e)
		{
			JError::raiseError(500, $e->getMessage());
			return false;
        }
    }

    public function deleteErrorURLs($ids = array())
    {
        if (empty($ids))
        {
            return;
        }

		$db = $this->getDbo();
        $query = $db->getQuery(true);
        $conditions = array(
            $db->quoteName('id') . ' IN (' . implode(',',$ids) . ')'
        );
        $query->delete($db->quoteName('#__fix404errorlinks_error404logs'));
        $query->where($conditions);

        try
        {
            $db->setQuery($query);
            $db->execute();
        }
        catch (RuntimeException $e)
        {
            JError::raiseError(500, $e->getMessage());
            return false;
        }
    }
}