<?php
/* ======================================================
 # Fix 404 Error Links for Joomla! - v2.2.5 (pro version)
 # -------------------------------------------------------
 # For Joomla! CMS (v3.x)
 # Author: Web357 (Yiannis Christodoulou)
 # Copyright (©) 2014-2022 Web357. All rights reserved.
 # License: GNU/GPLv3, http://www.gnu.org/licenses/gpl-3.0.html
 # Website: https:/www.web357.com
 # Demo: https://demo.web357.com/joomla/fix-404-error-links
 # Support: support@web357.com
 # Last modified: Thursday 08 June 2023, 01:53:23 AM
 ========================================================= */
// No direct access to this file
defined('_JEXEC') or die;
use Joomla\CMS\Factory;
abstract class Fix404errorlinksHelper
{
	public static function addSubmenu($submenu) 
	{
		JHtmlSidebar::addEntry(JText::_('Control Panel'), 'index.php?option=com_fix404errorlinks', $submenu == 'fix404errorlinks');
		JHtmlSidebar::addEntry(JText::_('COM_FIX404ERRORLINKS_ERROR_404_LINKS'), 'index.php?option=com_fix404errorlinks&view=error404logs&list[fullordering]=a.hits DESC', $submenu == 'error404logs');
		JHtmlSidebar::addEntry(JText::_('COM_FIX404ERRORLINKS_REDIRECTS'), 'index.php?option=com_fix404errorlinks&view=redirects', $submenu == 'redirects');
		JHtmlSidebar::addEntry(JText::_('COM_FIX404ERRORLINKS_OPTIONS'), 'index.php?option=com_config&view=component&component=com_fix404errorlinks', $submenu == 'settingscore');
	}

	/**
	 * Gets a list of the actions that can be performed.
	 *
	 * @return    JObject
	 */
	/**
	 *	Get the actions
	 */
	public static function getActions($Id = 0)
	{
		jimport('joomla.access.access');

		$user	= Factory::getUser();
		$result	= new JObject;

		if (empty($Id)){
			$assetName = 'com_fix404errorlinks';
		} else {
			$assetName = 'com_fix404errorlinks.message.'.(int) $Id;
		};

		$actions = array('core.admin', 'core.manage', 'core.create', 'core.edit', 'core.edit.own', 'core.edit.state', 'core.delete');

		foreach ($actions as $action){
			$result->set($action, $user->authorise($action, $assetName));
		};

		return $result;
    }
    
    /**
     * Fix deprecated issues for idn_to_ascii
     *
     * @param [type] $url
     * @return void
     */
    public static function idnToAscii($url)
    {
        if (extension_loaded('intl')) 
        {
            if (version_compare(phpversion(), '7.2', '>')) 
            {
                if (defined('INTL_IDNA_VARIANT_UTS46')) 
                {
                    return (idn_to_ascii($url, 0, INTL_IDNA_VARIANT_UTS46) ?: $url);
                }
            }

            return (idn_to_ascii($url) ?: $url);
        }
        
        return $url;
    }

    /**
     * Fix deprecated issues for idn_to_ascii
     *
     * @param [type] $url
     * @return void
     */
    public static function idnToUtf8($url)
    {
        if (extension_loaded('intl')) 
        {
            if (version_compare(phpversion(), '7.2', '>')) 
            {
                if (defined('INTL_IDNA_VARIANT_UTS46')) 
                {
                    return idn_to_utf8($url, 0, INTL_IDNA_VARIANT_UTS46) ?: $url;
                }
                
                return idn_to_utf8($url) ?: $url;
            } 
            else 
            {
                return idn_to_utf8($url) ?: $url;
            }

            return idn_to_utf8($url) ?: $url;
        }

        return $url;
    }

    /**
     * A map of integer HTTP 1.1 response codes to the full HTTP Status for the headers.
     *
     * @var    object
     * @since  3.4
     * @link   http://www.iana.org/assignments/http-status-codes/
     */
    public static function getHttpStatusCodeText($http_status_code = 0)
    {
        $http_status_code_arr = array(
			100 => 'HTTP/1.1 100 Continue',
			101 => 'HTTP/1.1 101 Switching Protocols',
			102 => 'HTTP/1.1 102 Processing',
			200 => 'HTTP/1.1 200 OK',
			201 => 'HTTP/1.1 201 Created',
			202 => 'HTTP/1.1 202 Accepted',
			203 => 'HTTP/1.1 203 Non-Authoritative Information',
			204 => 'HTTP/1.1 204 No Content',
			205 => 'HTTP/1.1 205 Reset Content',
			206 => 'HTTP/1.1 206 Partial Content',
			207 => 'HTTP/1.1 207 Multi-Status',
			208 => 'HTTP/1.1 208 Already Reported',
			226 => 'HTTP/1.1 226 IM Used',
			300 => 'HTTP/1.1 300 Multiple Choices',
			301 => 'HTTP/1.1 301 Moved Permanently',
			302 => 'HTTP/1.1 302 Found',
			303 => 'HTTP/1.1 303 See other',
			304 => 'HTTP/1.1 304 Not Modified',
			305 => 'HTTP/1.1 305 Use Proxy',
			306 => 'HTTP/1.1 306 (Unused)',
			307 => 'HTTP/1.1 307 Temporary Redirect',
			308 => 'HTTP/1.1 308 Permanent Redirect',
			400 => 'HTTP/1.1 400 Bad Request',
			401 => 'HTTP/1.1 401 Unauthorized',
			402 => 'HTTP/1.1 402 Payment Required',
			403 => 'HTTP/1.1 403 Forbidden',
			404 => 'HTTP/1.1 404 Not Found',
			405 => 'HTTP/1.1 405 Method Not Allowed',
			406 => 'HTTP/1.1 406 Not Acceptable',
			407 => 'HTTP/1.1 407 Proxy Authentication Required',
			408 => 'HTTP/1.1 408 Request Timeout',
			409 => 'HTTP/1.1 409 Conflict',
			410 => 'HTTP/1.1 410 Gone',
			411 => 'HTTP/1.1 411 Length Required',
			412 => 'HTTP/1.1 412 Precondition Failed',
			413 => 'HTTP/1.1 413 Payload Too Large',
			414 => 'HTTP/1.1 414 URI Too Long',
			415 => 'HTTP/1.1 415 Unsupported Media Type',
			416 => 'HTTP/1.1 416 Requested Range Not Satisfiable',
			417 => 'HTTP/1.1 417 Expectation Failed',
			418 => 'HTTP/1.1 418 I\'m a teapot',
			422 => 'HTTP/1.1 422 Unprocessable Entity',
			423 => 'HTTP/1.1 423 Locked',
			424 => 'HTTP/1.1 424 Failed Dependency',
			425 => 'HTTP/1.1 425 Reserved for WebDAV advanced collections expired proposal',
			426 => 'HTTP/1.1 426 Upgrade Required',
			428 => 'HTTP/1.1 428 Precondition Required',
			429 => 'HTTP/1.1 429 Too Many Requests',
			431 => 'HTTP/1.1 431 Request Header Fields Too Large',
			451 => 'HTTP/1.1 451 Unavailable For Legal Reasons',
			500 => 'HTTP/1.1 500 Internal Server Error',
			501 => 'HTTP/1.1 501 Not Implemented',
			502 => 'HTTP/1.1 502 Bad Gateway',
			503 => 'HTTP/1.1 503 Service Unavailable',
			504 => 'HTTP/1.1 504 Gateway Timeout',
			505 => 'HTTP/1.1 505 HTTP Version Not Supported',
			506 => 'HTTP/1.1 506 Variant Also Negotiates (Experimental)',
			507 => 'HTTP/1.1 507 Insufficient Storage',
			508 => 'HTTP/1.1 508 Loop Detected',
			510 => 'HTTP/1.1 510 Not Extended',
			511 => 'HTTP/1.1 511 Network Authentication Required',
        );
        
        if ($http_status_code == 0)
		{
			$http_status_code = 404;
		}

        return (string) $http_status_code_arr[$http_status_code];
    }

	public static function renderTooltip($id = 0, $title = '', $content = '')
	{
		$content = htmlspecialchars($content, ENT_QUOTES, 'UTF-8');

		if (version_compare(JVERSION, '4.0', 'gt')) 
		{
			// Joomla! 4
			$html = '<span class="icon-info-2" aria-labelledby="tooltip-'.$id.'" aria-hidden="true"></span>';
			$html .= '<div role="tooltip" id="tooltip-'.$id.'">'.nl2br($content).'</div>';
		}
		else
		{
			// Joomla! 3
			$html = '<span class="hasTooltip" title="'.nl2br($content).'">';
			$html .= '<i class="icon-info-2"></i>';
			$html .= '</span>';
		}

		return $html;
	}
}