<?php
/* ======================================================
 # Fix 404 Error Links for Joomla! - v2.2.5 (pro version)
 # -------------------------------------------------------
 # For Joomla! CMS (v3.x)
 # Author: Web357 (Yiannis Christodoulou)
 # Copyright (©) 2014-2022 Web357. All rights reserved.
 # License: GNU/GPLv3, http://www.gnu.org/licenses/gpl-3.0.html
 # Website: https:/www.web357.com
 # Demo: https://demo.web357.com/joomla/fix-404-error-links
 # Support: support@web357.com
 # Last modified: Thursday 08 June 2023, 01:53:23 AM
 ========================================================= */
defined('_JEXEC') or die;
use Joomla\CMS\Factory;

// plugin helper
jimport('joomla.plugin.helper');

// Check if Web357 Framework plugin exists and is enabled
if(!JPluginHelper::isEnabled('system', 'web357framework'))
{
	$msg = JText::_('COM_FIX404ERRORLINKS_WEB357FRAMEWORK_PLUGIN_REQUIRED');
	Factory::getApplication()->enqueueMessage($msg, 'error');
	return false;
}

// Check the Joomla! version. The plugin is not working for Joomla! 2.5
if (version_compare(JVERSION, '3.0', 'lt'))
{
	$msg = JText::_('COM_FIX404ERRORLINKS_J25_CHECKER');
	Factory::getApplication()->enqueueMessage($msg, 'error');
	return false;
}

// Load Web357Framework's language
Web357Framework\Functions::loadWeb357FrameworkLanguage();

// Check if the plugin exists
if(!JPluginHelper::isEnabled('system', 'fix404errorlinks'))
{
	// build url
	$fix404_task_url = JUri::getInstance(JRoute::_(JURI::getInstance()->toString())); // current url
	$fix404_task_url->setVar('fix404_task', 'activate_plugin');

	// activate the plugin
	$fix404_task = Factory::getApplication()->input->get('fix404_task', '', 'STRING');
	if ($fix404_task === 'activate_plugin')
	{
		// Activate Plugin
		$db = Factory::getDbo();
		$query = $db->getQuery(true);

		// Fields to update.
		$fields = array(
			$db->quoteName('enabled') . ' = 1'
		);

		// Conditions for which records should be updated.
		$conditions = array(
			$db->quoteName('type') . ' = ' . $db->quote('plugin'),
			$db->quoteName('element') . ' = ' . $db->quote('fix404errorlinks'),
			$db->quoteName('folder') . ' = ' . $db->quote('system'),
		);

		$query->update($db->quoteName('#__extensions'))->set($fields)->where($conditions);
		$db->setQuery($query);

		try
		{
			$db->execute();
		}
		catch (RuntimeException $e)
		{
			JError::raiseWarning(500, $e->getMessage());
			return false;
		}

		// remove the var (fix404_task) from the url and redirect to the previous page
		$uri = JUri::getInstance(JRoute::_(JURI::getInstance()->toString()));
		$uri->delVar('fix404_task');
		Factory::getApplication()->redirect($uri);
	}

	// message
	$msg = JText::sprintf(JText::_('COM_FIX404ERRORLINKS_FIX404ERRORLINKS_PLUGIN_REQUIRED'), $fix404_task_url);
	Factory::getApplication()->enqueueMessage($msg, 'error');
	return false;
}

// Check if Redirect Joomla! system plugin is disabled
if(JPluginHelper::isEnabled('system', 'redirect'))
{
	$msg = JText::_('COM_FIX404ERRORLINKS_SYSTEM_REDIRECT_CHECKER');
	Factory::getApplication()->enqueueMessage($msg, 'error');
}

// Check if the sh404sef plugin exists
if(JPluginHelper::isEnabled('system', 'sh404sef'))
{
	if (Sh404sefFactory::getConfig()->notFoundErrorHandling != 2) // Check if overrides joomla! 404 error page
	{
		$msg = JText::_('COM_FIX404ERRORLINKS_SYSTEM_SH404SEF_CHECKER');
		Factory::getApplication()->enqueueMessage($msg, 'error');
	}
}

// Check if Virtuemart's handle_404 is disabled
// Check if Virtuemart is installed
$db = Factory::getDbo();
$query = $db->getQuery(true);
$query->select('COUNT(*)');
$query->from($db->quoteName('#__extensions'));
$query->where($db->quoteName('type') . ' = '. $db->quote('component'));
$query->where($db->quoteName('element') . ' = '. $db->quote('com_virtuemart'));
$query->where($db->quoteName('enabled') . ' = 1');
$db->setQuery($query);

try
{
    $vm_enabled = $db->loadResult();
}
catch (RuntimeException $e)
{
    JError::raiseError(500, $e->getMessage());
    return false;
}

if($vm_enabled > 0)
{
	// Check first if the table exists
	$db = Factory::getDbo();
	$query = "SHOW TABLES LIKE '" . $db->getPrefix() . "virtuemart_configs'";
	$db->setQuery($query);
	$table_exist = $db->loadResult();

	if ($table_exist)
	{
		// get handle_404 value from #__virtuemart_configs 
		$db = Factory::getDbo();
		$query = $db->getQuery(true);
		$query->select($db->quoteName('config'));
		$query->from($db->quoteName('#__virtuemart_configs'));
		$db->setQuery($query);

		try
		{
			$vm_config = $db->loadResult();
		}
		catch (RuntimeException $e)
		{
			JError::raiseError(500, $e->getMessage());
			return false;
		}
		
		if (!empty($vm_config))
		{
			$vm_config_arr = explode("|", $vm_config);
			$vm_handle_404 = false;
			foreach ($vm_config_arr as $vm_config_value)
			{
				if ($vm_config_value == 'handle_404="1"')
				{
					$vm_handle_404 = true;
				}
			}
		}
		else 
		{
			$vm_handle_404 = false;
		}
	
		// message
		if ($vm_handle_404)
		{
			// If you are using "Virtuemart", navigate to "Configuration > Shopfront > Enable VirtueMart 404 error handling" and ensure that is unchecked.
			$msg = JText::_('COM_FIX404ERRORLINKS_VIRTUEMART_CHECKER');
			Factory::getApplication()->enqueueMessage($msg, 'error');
		}
	}
}

if (version_compare(JVERSION, '3.3', 'ge') && version_compare(JVERSION, '4.0', 'lt'))
{
	// joomla 3.x
	JHtml::_('behavior.tabstate');
}

// Added for Joomla 3.0
if(!defined('DS'))
{
	define('DS',DIRECTORY_SEPARATOR);
}

// ACL
if (!Factory::getUser()->authorise('core.manage', 'com_fix404errorlinks'))
{
	return JError::raiseWarning(404, JText::_('JERROR_ALERTNOAUTHOR'));
}

// CSS
Factory::getDocument()->addStyleSheet(JURI::root(true).'/administrator/components/com_fix404errorlinks/assets/css/backend-fix404errorlinks.css?v=20230608015323');

// JS
JHtml::_('jquery.framework', false);
Factory::getDocument()->addScript(JURI::root(true).'/administrator/components/com_fix404errorlinks/assets/js/backend-fix404errorlinks.js?v=20230608015323');

if (version_compare(JVERSION, '4.0', 'lt'))
{
	// Load cms libraries
	JLoader::registerPrefix('J', JPATH_PLATFORM . '/cms');

	// Load joomla libraries without overwrite
	JLoader::registerPrefix('J', JPATH_PLATFORM . '/joomla',false);
}

// require helper files
JLoader::register('Fix404errorlinksHelper', dirname(__FILE__) . DS . 'helpers' . DS . 'helper.php');

// import joomla controller library
jimport('joomla.application.component.controller');

// Get an instance of the controller prefixed by Estore
$controller = JControllerLegacy::getInstance('Fix404errorlinks');

// Perform the Request task
$controller->execute(Factory::getApplication()->input->get('task'));

// Redirect if set by the controller
$controller->redirect();