<?php
/* ======================================================
 # Fix 404 Error Links for Joomla! - v2.2.5 (pro version)
 # -------------------------------------------------------
 # For Joomla! CMS (v3.x)
 # Author: Web357 (Yiannis Christodoulou)
 # Copyright (©) 2014-2022 Web357. All rights reserved.
 # License: GNU/GPLv3, http://www.gnu.org/licenses/gpl-3.0.html
 # Website: https:/www.web357.com
 # Demo: https://demo.web357.com/joomla/fix-404-error-links
 # Support: support@web357.com
 # Last modified: Thursday 08 June 2023, 01:53:23 AM
 ========================================================= */
// No direct access.
defined('_JEXEC') or die;

jimport('joomla.application.component.controlleradmin');
use Joomla\CMS\Factory;
use Joomla\Utilities\ArrayHelper;

/**
 * Redirects list controller class.
 *
 * @since  1.6
 */
class Fix404errorlinksControllerRedirects extends JControllerAdmin
{
	/**
	 * Method to clone existing Redirects
	 *
	 * @return void
	 */
	public function duplicate()
	{
		// Check for request forgeries
		Jsession::checkToken() or jexit(JText::_('JINVALID_TOKEN'));

		// Get id(s)
		$pks = $this->input->post->get('cid', array(), 'array');

		try
		{
			if (empty($pks))
			{
				throw new Exception(JText::_('COM_FIX404ERRORLINKS_NO_ELEMENT_SELECTED'));
			}

			ArrayHelper::toInteger($pks);
			$model = $this->getModel();
			$model->duplicate($pks);
			$this->setMessage(Jtext::_('COM_FIX404ERRORLINKS_ITEMS_SUCCESS_DUPLICATED'));
		}
		catch (Exception $e)
		{
			Factory::getApplication()->enqueueMessage($e->getMessage(), 'warning');
		}

		$this->setRedirect('index.php?option=com_fix404errorlinks&view=redirects');
	}

	/**
	 * Proxy for getModel.
	 *
	 * @param   string  $name    Optional. Model name
	 * @param   string  $prefix  Optional. Class prefix
	 * @param   array   $config  Optional. Configuration array for model
	 *
	 * @return  object	The Model
	 *
	 * @since    1.6
	 */
	public function getModel($name = 'redirect', $prefix = 'Fix404errorlinksModel', $config = array())
	{
		$model = parent::getModel($name, $prefix, array('ignore_request' => true));

		return $model;
	}

	/**
	 * Method to save the submitted ordering values for records via AJAX.
	 *
	 * @return  void
	 *
	 * @since   3.0
	 */
	public function saveOrderAjax()
	{
		// Get the input
		$input = Factory::getApplication()->input;
		$pks   = $input->post->get('cid', array(), 'array');
		$order = $input->post->get('order', array(), 'array');

		// Sanitize the input
		ArrayHelper::toInteger($pks);
		ArrayHelper::toInteger($order);

		// Get the model
		$model = $this->getModel();

		// Save the ordering
		$return = $model->saveorder($pks, $order);

		if ($return)
		{
			echo "1";
		}

		// Close the application
		Factory::getApplication()->close();
	}

	// import from "redirect" joomla! core component
	public function comRedirectImport()
	{	
		$view = Factory::getApplication()->input->get('view', 'redirects', 'STRING');
		
		// Get datetime
		$jdate = new JDate;
		$sql_datetime = $jdate->toSql();
		$joomla_datetime = JHtml::_('date', $sql_datetime, JText::_('COM_FIX404ERRORLINKS_DEFAULT_DATE_FORMAT'));
		
		// connect to db
		$db = Factory::getDBO();
		
		// get data from com_redirect
		$query = $db->getQuery(true);
		$query->select('*');
		$query->from($db->quoteName('#__redirect_links'));
		$db->setQuery($query);

		try
		{
			$com_redirect_links = $db->loadObjectlist();
		}
		catch (RuntimeException $e)
		{
			JError::raiseError(500, $e->getMessage());
			return false;
		}

		// get data from com_fix404errorlinks
		$query = $db->getQuery(true);
		$query->select($db->quoteName('source_url'));
		$query->from($db->quoteName('#__fix404errorlinks_redirects'));
		$db->setQuery($query);

		try
		{
			$source_urls_arr_db = $db->loadColumn();
		}
		catch (RuntimeException $e)
		{
			JError::raiseError(500, $e->getMessage());
			return false;
		}

		// insert from com_redirect to com_fix404errorlinks
		$num=1;
		foreach ($com_redirect_links as $com_redirect_link)
		{
			$status = JText::_('COM_FIX404ERRORLINKS_IMPORTED');
			$juri_base = str_replace('/administrator', '', JURI::base());
			$source_url = str_replace($juri_base, '', $com_redirect_link->old_url);

			// check if old_urls_arr already exists in #__fix404errorlinks_redirects
			$notes = JText::sprintf(JText::_('COM_FIX404ERRORLINKS_TRANSFERED_FROM_COM_REDIRECT'), $joomla_datetime, $status);

			if (!in_array($source_url, $source_urls_arr_db))
			{
				// Create a new query object.
				$query = $db->getQuery(true);
				
				// Insert columns.
				$columns = array('source_url', 'target_url', 'notes', 'state', 'match_type', 'source_match_http_code', 'action_type', 'action_code', 'created_by', 'modified_by');
				
				// Insert values.
				$values = array($db->quote($source_url), $db->quote($com_redirect_link->new_url), $db->quote($notes), $com_redirect_link->published, $db->quote('full_url'), 404, $db->quote('redirect_to_url'), $com_redirect_link->header, (int) Factory::getUser()->get('id'), (int) Factory::getUser()->get('id'));
				
				// Prepare the insert query.
				$query
					->insert($db->quoteName('#__fix404errorlinks_redirects'))
					->columns($db->quoteName($columns))
					->values(implode(',', $values));
				
				// Set the query using our newly populated query object and execute it.
				$db->setQuery($query);
				$db->execute();
			}
			else
			{
				// Create a new query object.
				$query = $db->getQuery(true);
				
				// Fields to update.
				$fields = array(
					$db->quoteName('target_url') . ' = ' . $db->quote($com_redirect_link->new_url),
					$db->quoteName('notes') . ' = ' . $db->quote($notes),
					$db->quoteName('match_type') . ' = ' . $db->quote('full_url'),
					$db->quoteName('source_match_http_code') . ' = ' . $com_redirect_link->header,
					$db->quoteName('action_type') . ' = ' . $db->quote('redirect_to_url'),
					$db->quoteName('action_code') . ' = ' . $com_redirect_link->header,
					$db->quoteName('state') . ' = ' . $com_redirect_link->published,
					$db->quoteName('created_by') . ' = ' . (int) Factory::getUser()->get('id'),
					$db->quoteName('modified_by') . ' = ' . (int) Factory::getUser()->get('id')
				);
				
				// Conditions for which records should be updated.
				$conditions = array(
					$db->quoteName('source_url') . ' = ' . $db->quote($source_url)
				);
				
				$query->update($db->quoteName('#__fix404errorlinks_redirects'))->set($fields)->where($conditions);
				
				$db->setQuery($query);
				$db->execute();

				$status = JText::_('COM_FIX404ERRORLINKS_UPDATED');
			}
		
		$num++;
		}

		// Redirect to the list screen.
		$count_com_redirect_links = count($com_redirect_links);
		$this->setRedirect(JRoute::_('index.php?option=com_fix404errorlinks&view='.$view, false), JText::sprintf(JText::_('COM_FIX404ERRORLINKS_ADDED_FROM_COM_REDIRECTS'), $count_com_redirect_links, $status), 'message');
	}
}