<?php
/* ======================================================
 # Fix 404 Error Links for Joomla! - v2.2.5 (pro version)
 # -------------------------------------------------------
 # For Joomla! CMS (v3.x)
 # Author: Web357 (Yiannis Christodoulou)
 # Copyright (©) 2014-2022 Web357. All rights reserved.
 # License: GNU/GPLv3, http://www.gnu.org/licenses/gpl-3.0.html
 # Website: https:/www.web357.com
 # Demo: https://demo.web357.com/joomla/fix-404-error-links
 # Support: support@web357.com
 # Last modified: Thursday 08 June 2023, 01:53:23 AM
 ========================================================= */
// No direct access
defined('_JEXEC') or die;
use Joomla\CMS\Factory;
jimport('joomla.application.component.controllerform');

/**
 * Redirection controller class.
 *
 * @since  1.6
 */
class Fix404errorlinksControllerRedirect extends JControllerForm
{
	/**
	 * Constructor
	 *
	 * @throws Exception
	 */
	public function __construct()
	{
		$this->view_list = 'redirects';
		parent::__construct();
	}

	protected function postSaveHook(JModelLegacy $model, $validData = array())
	{
		// Redirect back to the "error404logs".
		$input = Factory::getApplication()->input;
		$task = $input->getString('task', '');
		$goback = Factory::getApplication()->input->get('goback', '', 'STRING');

		return true;
	}
}
