<?php
/* ======================================================
 # Fix 404 Error Links for Joomla! - v2.2.5 (pro version)
 # -------------------------------------------------------
 # For Joomla! CMS (v3.x)
 # Author: Web357 (Yiannis Christodoulou)
 # Copyright (©) 2014-2022 Web357. All rights reserved.
 # License: GNU/GPLv3, http://www.gnu.org/licenses/gpl-3.0.html
 # Website: https:/www.web357.com
 # Demo: https://demo.web357.com/joomla/fix-404-error-links
 # Support: support@web357.com
 # Last modified: Thursday 08 June 2023, 01:53:23 AM
 ========================================================= */
defined('_JEXEC') or die;

use Joomla\Utilities\ArrayHelper;
use Joomla\CMS\Factory;

// import Joomla controlleradmin library
jimport('joomla.application.component.controlleradmin');

class Fix404errorlinksControllerError404logs extends JControllerAdmin
{
	public function getModel($name = 'Error404logs', $prefix = 'Fix404errorlinksModel', $config = array('ignore_request' => true))
	{
		return parent::getModel($name, $prefix, $config);
	}
	
	public function getErrorUrlFromId($id)
	{
		$db = Factory::getDbo();
		$query = $db->getQuery(true);
		$query->select($db->quoteName('error_url'));
		$query->from($db->quoteName('#__fix404errorlinks_error404logs'));
		$query->where($db->quoteName('id') . ' = '. $id);
		$db->setQuery($query);

		try
		{
			return $db->loadResult();
		}
		catch (RuntimeException $e)
		{
			JError::raiseError(500, $e->getMessage());
			return false;
		}
	}

	public function deletelogs()
	{
		$view = Factory::getApplication()->input->get('view', 'error404logs', 'STRING');

		// connect to db
		$db = Factory::getDBO();
 
		// Get the input
		$input = Factory::getApplication()->input;
		$cids = $input->post->get('cid', array(), 'array');

		// Sanitize the input
		if (version_compare(JVERSION, '4.0', 'ge'))
		{
			// j4
			ArrayHelper::toInteger($cids);
		}
		else
		{
			JArrayHelper::toInteger($cids);
		}

		// Delete all ids where error_url
		foreach ($cids as $cid)
		{
			$query = $db->getQuery(true);
			$conditions = array(
				$db->quoteName('error_url') . ' = ' . $db->quote($this->getErrorUrlFromId($cid))
			);
			$query->delete($db->quoteName('#__fix404errorlinks_error404logs'));
			$query->where($conditions);

			try
			{
				$db->setQuery($query);
				$db->execute();
			}
			catch (RuntimeException $e)
			{
				JError::raiseError(500, $e->getMessage());
				return false;
			}
		}
 
		// Redirect to the list screen.
		$this->setRedirect(JRoute::_('index.php?option=com_fix404errorlinks&view='.$view, false), JText::_('COM_FIX404ERRORLINKS_DELETED_SUCCESSFULLY'), 'message');
	}

	public function deleteFixed404ErrorURLs()
	{
		$view = Factory::getApplication()->input->get('view', 'error404logs', 'STRING');

		// Get the model
		$model = JModelLegacy::getInstance('Error404logs', 'Fix404errorlinksModel', array('ignore_request' => true));
		$model->setState('filter.fixed_error404_urls', 'fixed');

		// Save the ordering
		$fixed_error_urls = $model->getFixedErrorURLs();

		if (!empty($fixed_error_urls))
		{
			$ids = array();
			foreach ($fixed_error_urls as $item)
			{
				$ids[] = $item->id;
			}

			$model->deleteErrorURLs($ids);
		}

		// Redirect to the list screen.
		$this->setRedirect(JRoute::_('index.php?option=com_fix404errorlinks&view='.$view, false), JText::_('COM_FIX404ERRORLINKS_FIXED_404_ERROR_URLS_DELETED_SUCCESSFULLY'), 'message');
	}

	public function deleteAllLogs()
	{	
		$view = Factory::getApplication()->input->get('view', 'error404logs', 'STRING');

		// Delete all 404 logs
		$db = Factory::getDBO();
		$query = $db->getQuery(true);
		$query->delete($db->quoteName('#__fix404errorlinks_error404logs'));
		$db->setQuery($query);
		$db->execute();
 
		// Redirect to the list screen.
		$this->setRedirect(JRoute::_('index.php?option=com_fix404errorlinks&view='.$view, false), JText::_('COM_FIX404ERRORLINKS_ALL_404_ERROR_LOGS_DELETED_SUCCESSFULLY'), 'message');
	}

	/**
	 * Method to save the submitted ordering values for records via AJAX.
	 *
	 * @return  void
	 *
	 * @since   3.0
	 */
	public function saveOrderAjax()
	{
		// Get the input
		$input = Factory::getApplication()->input;
		$pks = $input->post->get('cid', array(), 'array');
		$order = $input->post->get('order', array(), 'array');

		// Sanitize the input
		if (version_compare(JVERSION, '4.0', 'ge'))
		{
			// j4
			ArrayHelper::toInteger($pks);
			ArrayHelper::toInteger($order);
		}
		else
		{
			JArrayHelper::toInteger($pks);
			JArrayHelper::toInteger($order);
		}

		// Get the model
		$model = $this->getModel();

		// Save the ordering
		$return = $model->saveorder($pks, $order);

		if ($return)
		{
			echo "1";
		}

		// Close the application
		Factory::getApplication()->close();
	}
}