<?php
/**
 * @version $Id: default.php 272 2014-05-21 10:25:49Z michal $
 * @package DJ-Catalog2
 * @copyright Copyright (C) 2012 DJ-Extensions.com LTD, All rights reserved.
 * @license http://www.gnu.org/licenses GNU/GPL
 * @author url: http://dj-extensions.com
 * @author email contact@dj-extensions.com
 * @developer Michal Olczyk - michal.olczyk@design-joomla.eu
 *
 * DJ-Catalog2 is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * DJ-Catalog2 is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with DJ-Catalog2. If not, see <http://www.gnu.org/licenses/>.
 *
 */

// no direct access
defined('_JEXEC') or die;

JHtml::_('behavior.tooltip');

$listOrder	= $this->state->get('list.ordering');
$listDirn	= $this->state->get('list.direction');
$now = JFactory::getDate()->toUnix();

$params = JComponentHelper::getParams('com_djcatalog2');

$status_states = array(
		-1	=> array(
				'task'				=> 'subscribe',
				'text'				=> '',
				'active_title'		=> 'COM_DJCATALOG2_STATUS_CANCELED',
				'inactive_title'	=> 'COM_DJCATALOG2_STATUS_ACTIVE',
				'tip'				=> true,
				'active_class'		=> 'unpublish',
				'inactive_class'	=> 'publish'
		),
		0	=> array(
				'task'				=> 'subscribe',
				'text'				=> '',
				'active_title'		=> 'COM_DJCATALOG2_STATUS_EXPIRED',
				'inactive_title'	=> 'COM_DJCATALOG2_STATUS_ACTIVE',
				'tip'				=> true,
				'active_class'		=> 'unpublish',
				'inactive_class'	=> 'publish'
		),
		1	=> array(
				'task'				=> 'unsubscribe',
				'text'				=> '',
				'active_title'		=> 'COM_DJCATALOG2_STATUS_ACTIVE',
				'inactive_title'	=> 'COM_DJCATALOG2_STATUS_CANCELED',
				'tip'				=> true,
				'active_class'		=> 'publish',
				'inactive_class'	=> 'unpublish'
		)
);

?>
<form action="<?php echo JRoute::_('index.php?option=com_djcatalog2&view=subscriptions');?>" method="post" name="adminForm" id="adminForm">
	<?php if(!empty( $this->sidebar)): ?>
	<div id="j-sidebar-container" class="span2">
		<?php echo $this->sidebar; ?>
	</div>
	<div id="j-main-container" class="span10">
	<?php else : ?>
		<div id="j-main-container">
	<?php endif;?>
	
	<div id="filter-bar" class="btn-toolbar">
		
		<div class="filter-search btn-group pull-left">
			<label class="element-invisible" for="filter_search"><?php echo JText::_('JSEARCH_FILTER_LABEL'); ?></label>
			<input type="text" class="input-xxlarge" placeholder="search by name, user name, login, email, order id or type id:ID for specific subscription" name="filter_search" id="filter_search" value="<?php echo $this->escape($this->state->get('filter.search')); ?>" />
			
		</div>
		<div class="btn-group pull-left">
			<button type="submit" class="btn"><?php echo JText::_('JSEARCH_FILTER_SUBMIT'); ?></button>
			<button type="button" class="btn" onclick="document.id('filter_search').value='';this.form.submit();"><?php echo JText::_('JSEARCH_FILTER_CLEAR'); ?></button>
		</div>
		
		<div class="btn-group pull-right hidden-phone">
			<label for="limit" class="element-invisible"><?php echo JText::_('JFIELD_PLG_SEARCH_SEARCHLIMIT_DESC');?></label>
			<?php echo $this->pagination->getLimitBox(); ?>
		</div>
	</div>
	<div class="clearfix"> </div>

	<table class="adminlist table-striped table">
		<thead>
			<tr>
				<th width="1%" class="center">
					<?php echo JHtml::_('grid.checkall'); ?>
				</th>
				<th width="1%" class="center">
					<?php echo JHtml::_('grid.sort', 'JGRID_HEADING_ID', 'a.id', $listDirn, $listOrder); ?>
				</th>
				<th width="10%">
					<?php echo JHtml::_('grid.sort', 'COM_DJCATALOG2_NAME', 'a.item_name', $listDirn, $listOrder); ?>
				</th>
				<th width="10%">
					<?php echo JHtml::_('grid.sort', 'COM_DJCATALOG2_CUSTOMER', 'a.user_id', $listDirn, $listOrder); ?>
				</th>
				<th width="10%">
					<?php echo JHtml::_('grid.sort', 'COM_DJCATALOG2_ORDER', 'a.order_id', $listDirn, $listOrder); ?>
				</th>
				<th width="5%" class="center">
					<?php echo JHtml::_('grid.sort', 'COM_DJCATALOG2_STATUS', 'a.status', $listDirn, $listOrder); ?>
				</th>
				<th width="10%" class="center">
					<?php echo JHtml::_('grid.sort', 'COM_DJCATALOG2_START_DATE', 'a.start_date', $listDirn, $listOrder); ?>
				</th>
				<th width="10%" class="center">
					<?php echo JHtml::_('grid.sort', 'COM_DJCATALOG2_EXPIRE_DATE', 'a.expire_date', $listDirn, $listOrder); ?>
				</th>
			</tr>
		</thead>
		<tfoot>
			<tr>
				<td colspan="8">
					<?php echo $this->pagination->getListFooter(); ?>
				</td>
			</tr>
		</tfoot>
		<tbody>
		<?php foreach ($this->items as $i => $item) :
			$ordering	= ($listOrder == 'a.created');
			?>
			<tr class="row<?php echo $i % 2; ?>">
				<td class="center">
					<?php echo JHtml::_('grid.id', $i, $item->id); ?>
				</td>
				<td class="center">
					<span class="editlinktip hasTip" title="<?php echo JText::_( 'COM_DJCATALOG2_EDIT_TOOLTIP' );?>::<?php echo $this->escape($item->id); ?>">
						<a href="<?php echo JRoute::_('index.php?option=com_djcatalog2&task=subscription.edit&id='.$item->id);?>">
							<?php echo (int) $item->id; ?></a>
						</span>
				</td>
				<td>
					<span class="editlinktip hasTip" title="<?php echo JText::_( 'COM_DJCATALOG2_EDIT_TOOLTIP' );?>::<?php echo $this->escape($item->id); ?>">
						<a href="<?php echo JRoute::_('index.php?option=com_djcatalog2&task=subscription.edit&id='.$item->id);?>">
							<?php echo $this->escape($item->item_name); ?></a>
						</span>
				</td>
				<td>
					<span class="editlinktip hasTip" title="<?php echo $this->escape($item->name); ?>::login: <?php echo $this->escape($item->username); ?>&lt;br /&gt;<?php echo $this->escape($item->email); ?>">
					<a target="_blank" href="<?php echo JRoute::_('index.php?option=com_users&task=user.edit&id='.$item->user_id);?>">
							<?php echo $this->escape($item->name); ?></a>
						</span>
				</td>
				<td>
					<?php if($item->order_number) { ?>
					<a target="_blank" href="<?php echo JRoute::_('index.php?option=com_djcatalog2&task=order.edit&id='.$item->order_id);?>">
							<?php echo str_pad($item->order_number, 5, '0', STR_PAD_LEFT); ?></a>
					<?php } else { echo '-'; } ?>
				</td>
				<td>
					<?php echo JHtml::_('jgrid.state', $status_states, $item->status, $i, 'subscriptions.', true); ?>
					<small class="text-<?php echo $item->status==1 ? 'success':'error'; ?>"><?php echo JText::_($status_states[$item->status]['active_title']); ?></small>
				</td>
				<td class="center">
					<?php echo JHTML::_('date', $item->start_date, $params->get('date_format_datetime', 'd/m/Y H:i')); ?>
				</td>
				<td class="center">
					<span class="btn-small btn-<?php echo ($now < JFactory::getDate($item->expire_date)->toUnix() ? $item->status==1 ? 'success' : 'warning' : 'danger'); ?>">
					<?php echo !intval($item->expire_date) ? JText::_('COM_DJCATALOG2_NULL_DATE') : JHTML::_('date', $item->expire_date, $params->get('date_format_datetime', 'd/m/Y H:i')); ?></span>
				</td>
			</tr>
			<?php endforeach; ?>
		</tbody>
	</table>

	<div>
		<input type="hidden" name="task" value="" />
		<input type="hidden" name="boxchecked" value="0" />
		<input type="hidden" name="filter_order" value="<?php echo $listOrder; ?>" />
		<input type="hidden" name="filter_order_Dir" value="<?php echo $listDirn; ?>" />
		<?php echo JHtml::_('form.token'); ?>
	</div>
	</div>
</form>

