<?php
/**
 * @package DJ-Catalog2
 * @copyright Copyright (C) DJ-Extensions.com, All rights reserved.
 * @license http://www.gnu.org/licenses GNU/GPL
 * @author url: http://dj-extensions.com
 * @author email contact@dj-extensions.com
 */
// no direct access
defined('_JEXEC') or die;

JHtml::_('bootstrap.tooltip');

$user		= JFactory::getUser();
$userId		= $user->get('id');
$listOrder	= $this->state->get('list.ordering');
$listDirn	= $this->state->get('list.direction');
$saveOrder	= false;
$parent_id = JFactory::getApplication()->input->getInt('item_id',null);
?>
<form action="<?php echo JRoute::_('index.php?option=com_djcatalog2&view=relateditems&tmpl=component');?>" method="post" name="adminForm" id="adminForm">
	<div id="j-main-container">
	<div class="btn-toolbar">
		<button class="btn button" type="button" onclick="javascript:Joomla.submitbutton('relateditems.assign')"><?php echo JText::_('JAPPLY'); ?></button>
		<button class="btn button" type="button" onclick="javascript:Joomla.submitbutton('relateditems.assignclose')"><?php echo JText::_('JSAVE'); ?></button>
		<button class="btn button" type="button" onclick="window.parent.jQuery('#djc_related_modal').modal('hide');return false;"><?php echo JText::_('JTOOLBAR_CLOSE'); ?></button>
	</div>
	<div class="clearfix"> </div>
	
	<div class="btn-toolbar">
		<div class="filter-search btn-group pull-left">
			<label class="element-invisible" for="filter_search"><?php echo JText::_('JSEARCH_FILTER_LABEL'); ?></label>
			<input type="text" name="filter_search" id="filter_search" value="<?php echo $this->escape($this->state->get('filter.search')); ?>"  />
		</div>
		<div class="btn-group pull-left">
			<button type="submit" class="btn"><?php echo JText::_('JSEARCH_FILTER_SUBMIT'); ?></button>
			<button type="button" class="btn" onclick="document.getElementById('filter_search').value='';this.form.submit();"><?php echo JText::_('JSEARCH_FILTER_CLEAR'); ?></button>
		</div>
	</div>
	
	<div class="clearfix"> </div>
	
	<div class="btn-toolbar">
		<div class="btn-group pull-right hidden-phone">
			<label for="limit" class="element-invisible"><?php echo JText::_('JFIELD_PLG_SEARCH_SEARCHLIMIT_DESC');?></label>
			<?php echo $this->pagination->getLimitBox(); ?>
		</div>
		<div class="btn-group pull-right hidden-phone">
			<select name="filter_published" class="inputbox" onchange="this.form.submit()">
				<option value=""><?php echo JText::_('JOPTION_SELECT_PUBLISHED');?></option>
				<?php echo JHtml::_('select.options', array(JHtml::_('select.option', '1', 'JPUBLISHED'),JHtml::_('select.option', '0', 'JUNPUBLISHED')), 'value', 'text', $this->state->get('filter.published'), true);?>
			</select>
		</div>
		<div class="btn-group pull-right hidden-phone">	
		<?php echo JHTML::_('select.genericlist', $this->categories, 'filter_category', 'class="inputbox" onchange="this.form.submit()"', 'value', 'text', $this->state->get('filter.category')); ?>
		</div>
		<div class="btn-group pull-right hidden-phone">
		<?php 
				$producers_first_option = new stdClass();
				$producers_first_option->id = '';
				$producers_first_option->name = '- '.JText::_('COM_DJCATALOG2_SELECT_PRODUCER').' -';
				$producers_first_option->published = null;
				$producers = count($this->producers) ? array_merge(array($producers_first_option),$this->producers) : array($producers_first_option);
				echo JHTML::_('select.genericlist', $producers, 'filter_producer', 'class="inputbox" onchange="this.form.submit()"', 'id', 'name', $this->state->get('filter.producer'));
			?>
		</div>
	</div>
	
	<div class="clearfix"> </div>
	<table class="table table-striped">
		<thead>
			<tr>
				<th width="1%">
					<input type="checkbox" name="checkall-toggle" value="" title="<?php echo JText::_('JGLOBAL_CHECK_ALL'); ?>" onclick="Joomla.checkAll(this)" />
				</th>
				<th width="75" align="center">
					<?php echo JText::_('COM_DJCATALOG2_IMAGE'); ?>
				</th>
				<th>
					<?php echo JHtml::_('grid.sort', 'COM_DJCATALOG2_NAME', 'a.name', $listDirn, $listOrder); ?>
				</th>
				<th width="15%"  class="title">
					<?php echo JHTML::_('grid.sort',  'COM_DJCATALOG2_CATEGORY', 'category_name', $listDirn, $listOrder ); ?>
				</th>
				<th width="15%"  class="title">
					<?php echo JHTML::_('grid.sort',  'COM_DJCATALOG2_PRODUCER', 'producer_name', $listDirn, $listOrder ); ?>
				</th>
				<th class="title">
				
				</th>
				<th width="1%" class="nowrap">
					<?php echo JHtml::_('grid.sort', 'JGRID_HEADING_ID', 'a.id', $listDirn, $listOrder); ?>
				</th>
			</tr>
		</thead>
		<tfoot>
			<tr>
				<td colspan="7">
					<?php echo $this->pagination->getListFooter(); ?>
				</td>
			</tr>
		</tfoot>
		<tbody>
		<?php foreach ($this->items as $i => $item) :
			$item->max_ordering = 0; //??
			$ordering	= false;
			$canCheckin	= $user->authorise('core.manage',		'com_checkin') || $item->checked_out==$user->get('id') || $item->checked_out==0;
			?>
			<tr class="row<?php echo $i % 2; ?>">
				<td class="center">
					<?php if (!$item->checked_out && $item->id != $parent_id) { ?>
						<input type="checkbox" id="cb<?php echo $i; ?>" name="cid[]" value="<?php echo $item->id?>" onclick="isChecked(this.checked);" title="<?php echo JText::sprintf('JGRID_CHECKBOX_ROW_N', ($i + 1));?>" <?php if ($item->related_count > 0) echo 'checked="yes"'?> />
					    <?php echo '<input type="hidden" name="listed_cid[]" value="'.$item->id.'" />'; ?>
					<?php } else { ?>
						<?php 
						  echo JHtml::_('jgrid.checkedout', $i, $item->editor, $item->checked_out_time, 'items.', false); ?>
					<?php } ?>
				</td>
				<td align="center">
					<?php 
					if ($item->item_image) { ?><img alt="<?php echo $item->image_caption; ?>" src="<?php echo DJCatalog2ImageHelper::getImageUrl($item->image_fullpath,'thumb'); ?>"/><?php }
					else { ?><img src="<?php echo str_replace('/administrator', '', JURI::base()).'components/com_djcatalog2/assets/images/noimage.jpg'; ?>" alt="" /><?php }?>
				</td>
				<td>
					<?php if ($item->checked_out) : ?>
						<?php echo JHtml::_('jgrid.checkedout', $i, $item->editor, $item->checked_out_time, 'items.', false); ?>
						<?php echo $this->escape($item->name); ?>
					<?php else: ?>
						<?php echo $this->escape($item->name); ?>
					<?php endif; ?>
						
					<p class="smallsub"><?php echo JText::sprintf('JGLOBAL_LIST_ALIAS', $this->escape($item->alias));?></p>
				</td>
				<td>
					<?php echo $this->escape($item->category_name); ?>
				</td>
				<td>
					<?php echo $this->escape($item->producer_name); ?>
				</td>
				<td>
				
				<div class="form">
					<div class="control-group">
						<label for="related_description-<?php echo $item->id; ?>" class="hide"><?php echo JText::_('COM_DJCATALOG2_DESCRIPTION'); ?></label>
						<textarea name="related[<?php echo $item->id; ?>][description]" id="related_description-<?php echo $item->id; ?>" placeholder="<?php echo JText::_('COM_DJCATALOG2_DESCRIPTION'); ?>"><?php echo htmlspecialchars($item->related_description); ?></textarea>
					</div>
				</div>
				
				</td>
				<td class="center">
					<?php echo (int) $item->id; ?>
				</td>
			</tr>
			<?php endforeach; ?>
		</tbody>
	</table>
	<div class="clr"></div>
	<div class="filter-select fltrt">
		<button class="btn button" type="button" onclick="javascript: Joomla.submitbutton('relateditems.assign')"><?php echo JText::_('JAPPLY'); ?></button>
		<button class="btn button" type="button" onclick="javascript:Joomla.submitbutton('relateditems.assignclose')"><?php echo JText::_('JSAVE'); ?></button>
		<button class="btn button" type="button" onclick="window.parent.SqueezeBox.close();"><?php echo JText::_('JTOOLBAR_CLOSE'); ?></button>
	</div>
	<div>
		<input type="hidden" name="task" value="" />
		<input type="hidden" name="item_id" value="<?php echo $parent_id; ?>" />
		<input type="hidden" name="boxchecked" value="0" />
		<input type="hidden" name="filter_order" value="<?php echo $listOrder; ?>" />
		<input type="hidden" name="filter_order_Dir" value="<?php echo $listDirn; ?>" />
		<?php echo JHtml::_('form.token'); ?>
	</div>
	</div>
</form>
