<?php
/**
 * @package DJ-Catalog2
 * @copyright Copyright (C) DJ-Extensions.com, All rights reserved.
 * @license http://www.gnu.org/licenses GNU/GPL
 * @author url: http://dj-extensions.com
 * @author email contact@dj-extensions.com
 */

defined('_JEXEC') or die;

jimport('joomla.application.component.view');

class Djcatalog2ViewProducer extends JViewLegacy {
	
	protected $itemId;
	
	public function display($tpl = null)
	{
		$app = JFactory::getApplication();
		$this->itemId = $app->input->getInt('itemId',0);
		
		if (!$this->itemId) {
			echo JText::_('COM_DJCATALOG2_SAVE_PRODUCER_FIRST');
			return;
		}
		
		$db = JFactory::getDbo();
	
		$query = $db->getQuery(true);
		$query->select('f.*');
		$query->from('#__djc2_producers_extra_fields AS f');
		$query->select('CASE '
					.'WHEN (f.type=\'text\' OR f.type=\'textarea\' OR f.type=\'html\') ' 
					.'THEN vt.value '
					.'WHEN (f.type=\'calendar\') ' 
					.'THEN vd.value '
					.'WHEN (f.type=\'checkbox\' OR f.type=\'select\' OR f.type=\'bool\' OR f.type=\'multiselect\' OR f.type=\'radio\' OR f.type=\'color\' OR f.type=\'multicolor\') '
					.'THEN GROUP_CONCAT(vi.value SEPARATOR \'|\')'
					.'ELSE "" END AS field_value');
		$query->join('LEFT','#__djc2_producers_extra_fields_values_text AS vt ON f.id=vt.field_id AND vt.item_id='.(int)$this->itemId);
		$query->join('LEFT','#__djc2_producers_extra_fields_values_int AS vi ON f.id=vi.field_id AND vi.item_id='.(int)$this->itemId);
		$query->join('LEFT','#__djc2_producers_extra_fields_values_date AS vd ON f.id=vd.field_id AND vd.item_id='.(int)$this->itemId);
		$query->join('INNER','#__djc2_producers AS i ON i.id= ' . $this->itemId);
		$query->where('(f.language = i.language OR f.language = ' . $db->quote('*') . ')');
		$query->group('f.id');
		$query->order('f.ordering asc');
		//echo str_replace('#_', 'jos', (string)$query);die();
		$db->setQuery($query);
		$this->fields = ($db->loadObjectList('id'));

		if (count($this->fields)) {
			$fieldIds = array_keys($this->fields);
			$db->setQuery('SELECT * FROM #__djc2_producers_extra_fields_options WHERE field_id IN ('.implode(',', $fieldIds).') ORDER BY field_id ASC, ordering ASC');
			$optionList = $db->loadObjectList();
			
			foreach($this->fields as $field_id => $field) {
				foreach ($optionList as $optionRow) {
					if ($optionRow->field_id == $field_id) {
						if (empty($field->optionlist)) {
							$this->fields[$field_id]->optionlist = array();
						}
						$this->fields[$field_id]->optionlist[] = $optionRow;
					}
				}
			}
		} else {
			return;
		}
		
		parent::display($tpl);
	}
}
?>