<?php
/**
 * @package DJ-Catalog2
 * @copyright Copyright (C) DJ-Extensions.com, All rights reserved.
 * @license http://www.gnu.org/licenses GNU/GPL
 * @author url: http://dj-extensions.com
 * @author email contact@dj-extensions.com
 */

// no direct access
defined('_JEXEC') or die;

$document = JFactory::getDocument();

JHtml::_('bootstrap.tooltip');
JHtml::_('behavior.formvalidator');
JHtml::_('formbehavior.chosen', 'select');
JHtml::_('behavior.tabstate');

$document->addScript(JURI::root() . "administrator/components/com_djcatalog2/views/producer/producer.js");
$document->addScript(JURI::root() . "components/com_djcatalog2/assets/nicEdit/nicEdit.js");

/** new Calendar setup **/
DJCatalog2HtmlHelper::initCalendarScripts();

?>
<script type="text/javascript">
	Joomla.submitbutton = function(task)
	{
		if (task == 'producer.cancel' || document.formvalidator.isValid(document.getElementById('producer-form'))) {
			<?php echo $this->form->getField('description')->save(); ?>
			Joomla.submitform(task, document.getElementById('producer-form'));
		}
		else {
			alert('<?php echo $this->escape(JText::_('JGLOBAL_VALIDATION_FORM_FAILED'));?>');
		}
	}
</script>
<form action="<?php echo JRoute::_('index.php?option=com_djcatalog2&view=producer&layout=edit&id='.(int) $this->item->id); ?>" method="post" name="adminForm" id="producer-form" class="form-validate" enctype="multipart/form-data">
	<div class="form-inline form-inline-header">
		<?php echo $this->form->getControlGroup('name'); ?>
		<?php echo $this->form->getControlGroup('alias'); ?>
	</div>
	
	<div class="form-horizontal">
		<fieldset>
		
		<?php echo JHtml::_('bootstrap.startTabSet', 'myTab', array('active' => 'details')); ?>
		<?php echo JHtml::_('bootstrap.addTab', 'myTab', 'details', JText::_('COM_DJCATALOG2_EDIT')); ?>
			<div class="row-fluid">
				<div class="span9">
					<h4><?php echo $this->form->getLabel('description'); ?></h4>
					<fieldset class="adminform">
						<?php echo $this->form->getInput('description'); ?>
					</fieldset>
					<fieldset class="adminform">
						<div id="itemAttributes"></div>
					</fieldset>
				</div>
				<div class="span3">
					<div class="form-vertical">
						<?php echo $this->form->getControlGroup('cat_id'); ?>
						<?php echo $this->form->getControlGroup('published'); ?>
						<?php echo $this->form->getControlGroup('language'); ?>
						<?php echo $this->form->getControlGroup('id'); ?>
					</div>
				</div>
			</div>
		<?php echo JHtml::_('bootstrap.endTab'); ?>
		
		<?php if (JLanguageAssociations::isEnabled()) : ?>
			<?php echo JHtml::_('bootstrap.addTab', 'myTab', 'associations', JText::_('COM_DJCATALOG2_ASSOCIATIONS')); ?>
				<fieldset class="adminform">
					<div class="row-fluid">
						<div class="span12">
							<?php echo JLayoutHelper::render('joomla.edit.associations', $this);  ?>
						</div>
					</div>
				</fieldset>
			<?php echo JHtml::_('bootstrap.endTab'); ?>
		<?php endif; ?>
		
		<?php echo JHtml::_('bootstrap.addTab', 'myTab', 'publishing', JText::_('JGLOBAL_FIELDSET_PUBLISHING')); ?>
			<div class="row-fluid">
				<div class="span12">
					<?php echo $this->form->getControlGroup('heading'); ?>
					<?php echo $this->form->getControlGroup('metatitle'); ?>
					<?php echo $this->form->getControlGroup('metadesc'); ?>
					<?php echo $this->form->getControlGroup('created'); ?>
					<?php echo $this->form->getControlGroup('created_by'); ?>
				</div>
			</div>
		<?php echo JHtml::_('bootstrap.endTab'); ?>
		<?php echo JHtml::_('bootstrap.addTab', 'myTab', 'images', JText::_('COM_DJCATALOG2_IMAGES')); ?>
			<div class="row-fluid">
				<div class="span12">
					<?php echo DJCatalog2ImageHelper::renderInput('producer', JFactory::getApplication()->input->getInt('id', null), (bool)JComponentHelper::getParams('com_djcatalog2')->get('multiple_image_upload', true)); ?>
				</div>
			</div>
		<?php echo JHtml::_('bootstrap.endTab'); ?>
		<?php echo JHtml::_('bootstrap.endTabSet'); ?>
		
		</fieldset>
	</div>
	<input type="hidden" name="task" value="" />
	<?php echo JHtml::_('form.token'); ?>
</form>