/**
 * @version 3.x
 * @package DJ-Catalog2
 * @copyright Copyright (C) 2013 DJ-Extensions.com, All rights reserved.
 * @license DJ-Extensions.com Proprietary Use License
 * @author url: http://dj-extensions.com
 * @author email contact@dj-extensions.com
 * @developer Michał Olczyk michal.olczyk@design-joomla.eu
 *
 */

(function($){
	$(document).ready(function() {
		djRenderForm();
	});

	function djRenderForm() {
		var itemId = $('#jform_id').val();
		
		if (!itemId || itemId == 0) {
			var vars = {};
		    var parts = window.location.href.replace(/[?&]+([^=&]+)=([^&]*)/gi, function(m,key,value) {
		        vars[key] = value;
		    });
		    if (vars['id'] > 0) {
		    	itemId = vars['id'];
		    }
		}
		
		if ($('#itemAttributes').length > 0) {
			
			var textareas = $('#itemAttributes').find('textarea.nicEdit');
			if (textareas.length > 0) {
				textareas.each(function(){
					var textarea = $(this);
					if (textarea.nicEditor != null && textarea.nicEditor) {
						textarea.nicEditor.removeInstance(textarea.id);
						textarea.nicEditor = null;
					}
				});
			}
			
			var calendars = $('#itemAttributes').find('input.djc_calendar');
			if (calendars.length > 0) {
				calendars.each(function(){
					var calendar = $(this);
					if (typeof(calendar.hasCalendar) != 'undefined') {
						calendars.hasCalendar = null;
					}
				});
			}
			$.ajax({
				url : 'index.php?option=com_djcatalog2&view=producer&layout=extrafields&format=raw&itemId='
					+ itemId,
				type: 'post'
				
			}).done(function(resp){
				$('#itemAttributes').html(resp);
				var textareas = $('#itemAttributes').find('textarea.nicEdit');
				if (textareas.length > 0) {
					var myNicEditor = new nicEditor();
					textareas.each(function(){
						var textarea = $(this);
						textarea.nicEditor = new nicEditor({fullPanel : true, xhtml: true, iconsPath: '../components/com_djcatalog2/assets/nicEdit/nicEditorIcons.gif'}).panelInstance(textarea.attr('id'),{hasPanel : true});
						textarea.nicEditor.addEvent('blur',function(){
							if (textarea.nicEditor) {
								var editor = textarea.nicEditor.instanceById(textarea.id);
								if (editor) {
									editor.saveContent();
								}
							}
						});
					});
				}
				
				//var calendars = $('#itemAttributes').find('input.djc_calendar');
				var calendars = $('#itemAttributes').find('.field-calendar');
				if (calendars.length > 0) {
					calendars.each(function(){
						JoomlaCalendar.init($(this)[0]);
					});
				} else {
					calendars = $('#itemAttributes').find('input.djc_calendar');
					if (calendars.length > 0) {
						calendars.each(function(){
							var calendar = $(this);
							if (typeof(calendar.hasCalendar) === 'undefined') {
								Calendar.setup({
									inputField: calendar.attr('id'),
									ifFormat: "%Y-%m-%d",
									//ifFormat: "%Y-%m-%d %H:%M:%S",
									daFormat: "%Y-%m-%d",
									button: calendar.attr('id') + "_img",
									align: "Tl",
									singleClick: true
								});
								calendar.hasCalendar = true;
							}
						});
					}
				}
			});
		}
	}
})(jQuery);