<?php
/**
 * @package DJ-Catalog2
 * @copyright Copyright (C) DJ-Extensions.com, All rights reserved.
 * @license http://www.gnu.org/licenses GNU/GPL
 * @author url: http://dj-extensions.com
 * @author email contact@dj-extensions.com
 *
 */

// No direct access
defined('_JEXEC') or die;

jimport('joomla.application.component.view');

class Djcatalog2ViewPrices extends JViewLegacy
{
	protected $items;
	protected $pagination;
	protected $state;

	public function display($tpl = null)
	{
		$actions = (array)JHelperContent::getActions('com_djcatalog2');
		if ($actions['djcatalog2.admin.prices'] == false && $actions['djcatalog2.admin.catalogue'] == false) {
			throw new JAccessExceptionNotallowed(JText::_('JERROR_ALERTNOAUTHOR'), 403);
		}
		
		$this->state		= $this->get('State');
		
		if ($this->getLayout() == 'combinations') {
			$this->items		= $this->get('Combinations');
			
			if ($this->state->get('filter.item') > 0) {
				$itemModel = JModelLegacy::getInstance('Item', 'DJCatalog2Model', array('ignore_request'=>true));
				$this->parent_item = $itemModel->getItem($this->state->get('filter.item'));
			}
			
		} else {
			$this->items		= $this->get('Items');
		}
		$this->pagination	= $this->get('Pagination');
		$this->producers		= $this->get('Producers');
		
		$model = $this->getModel();
		$this->dimension_units = $model->getUnits('length');
		$this->weight_units = $model->getUnits('weight');
		
		$categories = Djc2Categories::getInstance();
		
		$this->categories = $categories->getOptionList('- '.JText::_('COM_DJCATALOG2_SELECT_CATEGORY').' -');
		
		// Check for errors.
		if (count($errors = $this->get('Errors'))) {
			JError::raiseError(500, implode("\n", $errors));
			return false;
		}
		$this->addToolbar();
		if (class_exists('JHtmlSidebar')){
            $this->sidebar = JHtmlSidebar::render();
        }
        
		$version = new JVersion;
		if (version_compare($version->getShortVersion(), '3.0.0', '<')) {
			$tpl = 'legacy';
		}
        
		parent::display($tpl);
	}

	protected function addToolbar()
	{
		JToolBarHelper::title(JText::_('COM_DJCATALOG2_PRICES_AND_STOCK'), 'generic.png');

		JToolBarHelper::custom('items.set_prices', 'edit', null,'COM_DJCATALOG2_UPDATE_ITEM_DATA', false);
		//JToolBarHelper::divider();
		JToolBarHelper::preferences('com_djcatalog2', '450', '900');
		JToolBarHelper::divider();
	}
}
