<?php
/**
 * @package DJ-Catalog2
 * @copyright Copyright (C) DJ-Extensions.com, All rights reserved.
 * @license http://www.gnu.org/licenses GNU/GPL
 * @author url: http://dj-extensions.com
 * @author email contact@dj-extensions.com
 *
 */
// no direct access
defined('_JEXEC') or die;

JHtml::_('bootstrap.tooltip');

$user		= JFactory::getUser();
$userId		= $user->get('id');
$listOrder	= $this->state->get('list.ordering');
$listDirn	= $this->state->get('list.direction');
$saveOrder	= $listOrder == 'a.ordering';

$db = JFactory::getDbo();

$params = JComponentHelper::getParams('com_djcatalog2');

$net_prices = (bool)((int)$params->get('price_including_tax', 1) == 0);

$has_group = (bool)$this->state->get('filter.customergroup', false);

$onstock = array();
$onstock[] = JHtml::_('select.option', 0, JText::_('JNO'));
$onstock[] = JHtml::_('select.option', 1, JText::_('JYES'));
$onstock[] = JHtml::_('select.option', 2, JText::_('COM_DJCATALOG2_ALWAYS'));

$dimension_units = $this->dimension_units;
$weight_units = $this->weight_units;

$item_id = $this->state->get('filter_item');
?>
<form action="<?php echo JRoute::_('index.php?option=com_djcatalog2&view=prices&layout=combinations&item_id='.(int)$item_id);?>" method="post" name="adminForm" id="adminForm">
	<?php if(!empty( $this->sidebar)): ?>
	<div id="j-sidebar-container" class="span2">
		<?php echo $this->sidebar; ?>
	</div>
	<div id="j-main-container" class="span10">
	<?php else: ?>
		<div id="j-main-container">
	<?php endif;?>
	
	<?php if ($this->state->get('filter.item') > 0 ) {?>
		<?php if (!empty($this->parent_item->id)) {?>
			<div class="alert alert-info">
				<?php echo JText::sprintf('COM_DJCATALOG2_NOTICE_COMBINATIONS_ITEMS_LIST', $this->escape($this->parent_item->name)); ?>
				<a class="btn btn-primary btn-mini" href="<?php echo JRoute::_('index.php?option=com_djcatalog2&view=prices&filter_item=0'); ?>"><?php echo JText::_('COM_DJCATALOG2_CHILD_ITEMS_GO_BACK'); ?></a>
			</div>
		<?php } else {?>
			<div class="alert alert-error">
				<?php echo JText::_('COM_DJCATALOG2_NOTICE_COMBINATIONS_LIST_MISSING_PARENT'); ?>
				<a class="btn btn-primary btn-mini" href="<?php echo JRoute::_('index.php?option=com_djcatalog2&view=prices&filter_item=0'); ?>"><?php echo JText::_('COM_DJCATALOG2_CHILD_ITEMS_GO_BACK'); ?></a>
			</div>
		<?php } ?>
		
	<?php } ?>
	
	<div id="filter-bar" class="btn-toolbar">
		<div class="btn-group pull-right hidden-phone">
			<label for="limit" class="element-invisible"><?php echo JText::_('JFIELD_PLG_SEARCH_SEARCHLIMIT_DESC');?></label>
			<?php echo $this->pagination->getLimitBox(); ?>
		</div>
		
		<div class="btn-group pull-right hidden-phone">	
			<?php /*?><label for="filter_customergroup"><?php echo JText::_('COM_DJCATALOG2_FILTER_CUSTOMERGROUP')?></label><?php */ ?>
			<?php 
			$groups = array();
			$groups[] = JHtml::_('select.option', '0', '- '.JText::_('COM_DJCATALOG2_GLOBAL_PRICES').' -');
			$db->setQuery('select id, name from #__djc2_customer_groups order by name asc');
			$db_groups = $db->loadObjectList();
	
			foreach ($db_groups as $group) {
				$groups[] = JHtml::_('select.option', $group->id, $group->name);
			}
			?>
			<select id="filter_cusomtergroup" name="filter_customergroup" class="inputbox" onchange="this.form.submit()">
				<?php 
				echo JHtml::_('select.options', $groups, 'value', 'text', ($this->state->get('filter.customergroup')), true);?>
			</select>
		</div>
	</div>
	<div class="clearfix"> </div>
	<table class="table table-striped">
		<thead>
			<tr>
				<th class="title" width="20%">
					<?php echo JHtml::_('grid.sort', 'COM_DJCATALOG2_NAME', 'a.name', $listDirn, $listOrder); ?>
				</th>
				<th class="center">
					<?php echo JHTML::_('grid.sort',  'COM_DJCATALOG2_SKU', 'a.sku', $listDirn, $listOrder ); ?>
				</th>
				<?php if ($has_group) { ?>
					<th width="15%" class="center">
						<?php echo JText::_('COM_DJCATALOG2_BASE_PRODUCT_PRICE'); ?>
						<p class="smallsub"><small>[<?php echo JText::_(($net_prices) ? 'COM_DJCATALOG2_PRICE_EXCL_TAX' : 'COM_DJCATALOG2_PRICE_INCL_TAX'); ?>]</small></p>
					</th>
				<?php } ?>
				
				<th width="10%" class="center">
					<?php echo JText::_('COM_DJCATALOG2_PRICE_EXCL_TAX'); ?>
				</th>
				<th width="10%" class="center">
					<?php echo JText::_('COM_DJCATALOG2_PRICE_INCL_TAX'); ?>
				</th>
				<th width="10%" class="center">
					<?php echo JHTML::_('grid.sort',  'COM_DJCATALOG2_STOCK', 'a.stock', $listDirn, $listOrder ); ?>
				</th>
				<th width="20%" class="center">
					<?php echo JText::_('COM_DJCATALOG2_DIMENSIONS_LBL'); ?>
				</th>
				<th width="10%" class="center">
					<?php echo JText::_('COM_DJCATALOG2_WEIGHT'); ?>
				</th>
				<th width="1%" class="nowrap">
					<?php echo JHtml::_('grid.sort', 'JGRID_HEADING_ID', 'a.id', $listDirn, $listOrder); ?>
				</th>
			</tr>
		</thead>
		<tfoot>
			<tr>
				<td colspan="<?php echo ($has_group) ? '9' : '8'; ?>">
					<?php echo $this->pagination->getListFooter(); ?>
				</td>
			</tr>
		</tfoot>
		<tbody>
		<?php foreach ($this->items as $i => $item) :
				$product_price = null;
				if ($has_group && $item->group_price > 0) {
					$product_price = $item->group_price;
				} else if (!$has_group) {
					$product_price = $item->price ? $item->price : 0.00;
				}
				?>
			<tr class="row<?php echo $i % 2; ?>">
				<td>
					<a target="_blank" href="<?php echo JRoute::_('index.php?option=com_djcatalog2&task=item.edit&id='.$item->item_id);?>"><?php echo $this->escape($item->name); ?></a>
					<p class="smallsub">
						<?php echo JText::sprintf('JGLOBAL_LIST_ALIAS', $this->escape($item->alias));?><br />
					</p>
					<ul>
						<?php foreach($item->fields as $field) {?>
							<li><?php echo $field->field_name?>: <strong><?php echo $field->field_value;?></strong>
						<?php } ?>
					</ul>
				</td>
				<td class="center">
					<?php echo $this->escape($item->sku); ?>
				</td>
				<?php if ($has_group) { ?>
					<td class="center">
						<input class="input input-mini inputbox readonly" type="text" readonly="readonly" value="<?php echo $item->price > 0.0 ? $item->price : 0.00; ?>" />
					</td>
				<?php } ?>
				
				<?php if ($net_prices) { ?>
					<td class="center">
						<input data-taxrate="<?php echo floatval($item->tax_rate); ?>" data-type="net" data-target="djc_tax_price_<?php echo $item->id; ?>" class="input input-mini inputbox djc_price" type="text" value="<?php echo $product_price; ?>" name="djc_prices[<?php echo $item->id ?>][new]" />
						<input type="hidden" name="djc_prices[<?php echo $item->id ?>][old]" value="<?php echo $product_price; ?>" />
					</td>
					<td class="center">
						<input id="djc_tax_price_<?php echo $item->id; ?>" class="input input-mini inputbox djc_tax_price readonly" type="text" readonly="readonly" />
					</td>
				<?php } else { ?>
					<td class="center">
						<input id="djc_tax_price_<?php echo $item->id; ?>" class="input input-mini inputbox djc_tax_price readonly" type="text" readonly="readonly" />
					</td>
					<td class="center">
						<input data-taxrate="<?php echo floatval($item->tax_rate); ?>" data-type="gross" data-target="djc_tax_price_<?php echo $item->id; ?>" class="input input-mini inputbox djc_price" type="text" value="<?php echo $product_price; ?>" name="djc_prices[<?php echo $item->id ?>][new]" />
						<input type="hidden" name="djc_prices[<?php echo $item->id ?>][old]" value="<?php echo $product_price; ?>" />
					</td>
				<?php } ?>
				<td class="center">
					<div class="input-append">
						<input class="input input-mini inputbox djc_stock" type="text" value="<?php echo $item->stock; ?>" name="djc_prices[<?php echo $item->id ?>][stock]"  <?php if ($has_group) echo 'disabled="disabled"'; ?> />
					</div>
				</td>
				<td class="center">
					<div class="input-append">
						<input class="input input-mini inputbox djc_stock" type="text" value="<?php echo $item->length; ?>" name="djc_prices[<?php echo $item->id ?>][length]"  <?php if ($has_group) echo 'disabled="disabled"'; ?> />
						<br /><input class="input input-mini inputbox djc_stock" type="text" value="<?php echo $item->width; ?>" name="djc_prices[<?php echo $item->id ?>][width]" <?php if ($has_group) echo 'disabled="disabled"'; ?>  />
						<br /><input class="input input-mini inputbox djc_stock" type="text" value="<?php echo $item->height; ?>" name="djc_prices[<?php echo $item->id ?>][height]" <?php if ($has_group) echo 'disabled="disabled"'; ?>  />
						<br /><select name="djc_prices[<?php echo $item->id?>][dimensions_unit]" class="input input-small " disabled="disabled">
							<?php 
							echo JHtml::_('select.options', $dimension_units, 'value', 'text', $item->dimensions_unit, true); ?>
						</select>
					</div>
				</td>
				<td class="center">
					<div class="input-append">
						<input class="input input-mini inputbox djc_stock" type="text" value="<?php echo $item->weight; ?>" name="djc_prices[<?php echo $item->id ?>][weight]"  <?php if ($has_group) echo 'disabled="disabled"'; ?> />
						<br /><select name="djc_prices[<?php echo $item->id?>][weight_unit]" class="input input-small " disabled="disabled">
								<?php 
								echo JHtml::_('select.options', $weight_units, 'value', 'text', $item->weight_unit, true);?>
							</select>
					</div>
				</td>
				<td class="center">
					<?php echo (int) $item->id; ?>
				</td>
			</tr>
			<?php endforeach; ?>
		</tbody>
	</table>

	<div>
		<input type="hidden" name="task" value="" />
		<input type="hidden" name="target" value="combinations" />
		<input type="hidden" name="boxchecked" value="0" />
		<input type="hidden" name="filter_order" value="<?php echo $listOrder; ?>" />
		<input type="hidden" name="filter_order_Dir" value="<?php echo $listDirn; ?>" />
		<?php echo JHtml::_('form.token'); ?>
	</div>
</form>


<script type="text/javascript">
(function($){
	$(document).ready(function() {
		$('input.djc_price').on('keyup change click', function(){
			djValidatePrice($(this));
		});

		$('input.djc_price').trigger('change');
	});


	function djValidatePrice(priceInput) {
		//var r = new RegExp("\,", "i");
		//var t = new RegExp("[^0-9\,\.]+", "i");
		//priceInput.setProperty('value', priceInput.getProperty('value').replace(r, "."));
		//priceInput.setProperty('value', priceInput.getProperty('value').replace(t, ""));
	
	
		var price = priceInput.val();
		
		// valid format
		var valid_price = new RegExp(/^(\d+|\d+\.\d+)$/);
		
		// comma instead of dot
		var wrong_decimal = new RegExp(/\,/g);
		
		// non allowed characters
		var restricted = new RegExp(/[^\d+\.]/g);
		
		// replace comma with a dot
		price = price.replace(wrong_decimal, ".");
		
		if (valid_price.test(price) == false) {
			// remove illegal chars
			price = price.replace(restricted, '');
		}
		
		if (valid_price.test(price) == false) {
			// too many dots in here
			parts = price.split('.');
			if (parts.length > 2 ) {
				price = parts[0] + '.' + parts[1];
			}
		}
		priceInput.val(price);

		var inputType = priceInput.attr('data-type');
		var taxRate = priceInput.attr('data-taxrate');

		if (inputType == 'gross') {
			djPriceFromGross($('#' + priceInput.attr('data-target')), price, taxRate);
		} else if (inputType == 'net') {
			djPriceFromNet($('#' + priceInput.attr('data-target')), price, taxRate);
		}
	}

	function djPriceFromGross(element, price, taxrate) {
		price = parseFloat(price);
		taxrate = parseFloat(taxrate);
		if (!price || !(taxrate >= 0)) {
			element.val('');
			return;
		}

		var netPrice = (price * 100) / (100 + taxrate);
		element.val(netPrice.toFixed(2));
	}

	function djPriceFromNet(element, price, taxrate) {
		price = parseFloat(price);
		taxrate = parseFloat(taxrate);

		if (!price || !(taxrate >= 0)) {
			element.val('');
			return;
		}

		var grossPrice = price * ((100 + taxrate)/100) ;
		element.val(grossPrice.toFixed(2));
	}
})(jQuery);
</script>
