<?php
/**
 * @package DJ-Catalog2
 * @copyright Copyright (C) DJ-Extensions.com, All rights reserved.
 * @license http://www.gnu.org/licenses GNU/GPL
 * @author url: http://dj-extensions.com
 * @author email contact@dj-extensions.com
 *
 */
use Joomla\Utilities\ArrayHelper;

// no direct access
defined('_JEXEC') or die;

$pricesModel = JModelLegacy::getInstance('Prices', 'DJCatalog2Model', array('ignore_request'=>true));
$dimension_units = $pricesModel->getUnits('length');
$weight_units = $pricesModel->getUnits('weight');
$targetOpts = array(
	JHtmlSelect::option(1, 'COM_DJCATALOG2_BATCH_TARGET_MAINITEM'),
	JHtmlSelect::option(2, 'COM_DJCATALOG2_BATCH_TARGET_COMBINATIONS'),
	JHtmlSelect::option(3, 'COM_DJCATALOG2_BATCH_TARGET_BOTH')
);

JFactory::getDocument()->addScriptDeclaration(
	'
		jQuery(document).ready(function($){
			var langSelector = $("#batch-language-id");
			var langCopy = $("#batch-language-copy");
			
			$(langCopy).hide();
			langSelector.on("change", function(){
				if (langSelector.val() != 0 || langSelector.val() != "") {
					$(langCopy).show();
				} else {
					$(langCopy).hide();
				}
			});
		});
			'
	);

?>
<div class="container-fluid">

	<?php $lang = $this->state->get('filter.language');
		if($lang && JLanguageAssociations::isEnabled()) {?>
	<div class="row-fluid">
		<div class="control-group span6">
			<div class="controls">
				<label id="batch-language-lbl" for="batch-language-id" class="modalTooltip" title="<?php echo JHtml::_('tooltipText', 'COM_DJCATALOG2_BATCH_COPY_LANGUAGE', 'COM_DJCATALOG2_BATCH_COPY_LANGUAGE_DESC'); ?>">
					<?php echo JText::_('COM_DJCATALOG2_BATCH_COPY_LANGUAGE'); ?>
				</label>
				<select name="batch[language_id]" class="inputbox" id="batch-language-id">
					<option value=""><?php echo JText::_('COM_DJCATALOG2_BATCH_LANGUAGE_DONT_COPY'); ?></option>
					<?php echo JHtml::_('select.options', JHtml::_('contentlanguage.existing', true, true), 'value', 'text'); ?>
				</select>
				
				<div id="batch-language-copy" class="control-group radio">
					<div class="controls">
						<label for="batch[language_copy]y" id="batch[move_copy]y-lbl" class="radio">
							<input type="radio" name="batch[language_copy]" id="batch[language_copy]y" value="y">
							<?php echo JText::_('COM_DJCATALOG2_BATCH_LANGUAGE_COPY_ASSIGNMENTS'); ?>
						</label>
						<label for="batch[language_copy]n" id="batch[move_copy]n-lbl" class="radio">
							<input type="radio" name="batch[language_copy]" id="batch[language_copy]n" value="n">
							<?php echo JText::_('COM_DJCATALOG2_BATCH_LANGUAGE_DONT_COPY_ASSIGNMENTS'); ?>
						</label>
					</div>
				</div>
			</div>
		</div>
	</div>
	<?php } ?>
	<div class="row-fluid">
		<div class="control-group span6">
			<div class="controls">
				<label><?php echo JText::_('COM_DJCATALOG2_CATEGORY_BATCH_LBL'); ?></label>
				<?php echo JHtml::_('select.genericlist', $this->categories, 'batch[category]', '', 'value', 'text', null, 'batch-category'); ?>
				
				<div class="control-group radio">
					<div class="controls">
						<label for="batch-category-add" class="radio">
							<input type="radio" id="batch-category-add" name="batch[category_moveadd]" value="a" />
							<?php echo JText::_('COM_DJCATALOG2_CATEGORY_BATCH_ADD'); ?>
						</label>
						<label for="batch-category-move" class="radio">
							<input type="radio" id="batch-category-move" name="batch[category_moveadd]" value="m" />
							<?php echo JText::_('COM_DJCATALOG2_CATEGORY_BATCH_MOVE'); ?>
						</label>
					</div>
					
					<p><?php echo JText::_('COM_DJCATALOG2_CATEGORY_BATCH_INFO');?></p>
				</div>
			</div>
		</div>
		
		<div class="control-group span6">
			<div class="controls">
				<label><?php echo JText::_('COM_DJCATALOG2_PRODUCER_BATCH_LBL'); ?></label>
				<?php 
				$producers = array();
				$producers[] = ArrayHelper::toObject(array('id' => '', 'name'=>'- '.JText::_('COM_DJCATALOG2_SELECT_PRODUCER').' -', 'published' => null));
				$producers[] = ArrayHelper::toObject(array('id' => '-1', 'name'=>'- '.JText::_('JNONE').' -', 'published' => null));
				$producers = count($this->producers) ? array_merge($producers,$this->producers) : $producers;
				echo JHtml::_('select.genericlist', $producers, 'batch[producer]', '', 'id', 'name', null, 'batch-producer');
				?>
			</div>
		</div>
	</div>
	<div class="row-fluid">
		<div class="control-group span6">
			<div class="controls">
				<label for="batch-price"><?php echo JText::_('COM_DJCATALOG2_PRICE_BATCH_LBL'); ?></label>
				<input type="text" value="" autocomplete="off" name="batch[price]" id="batch-price" class="input-medium" placeholder="<?php echo JText::_('COM_DJCATALOG2_PRICE');?>" />
			</div>
			<div class="controls">
				<label for="batch-special_price"><?php echo JText::_('COM_DJCATALOG2_SPECIAL_PRICE_BATCH_LBL'); ?></label>
				<input type="text" value="" autocomplete="off" name="batch[special_price]" id="batch-special_price" class="input-medium" placeholder="<?php echo JText::_('COM_DJCATALOG2_SPECIAL_PRICE');?>" />
			</div>
			<select name="batch[prices_target]" class="input input-medium">
				<?php 
				echo JHtml::_('select.options', $targetOpts, 'value', 'text', null, true); ?>
			</select>
		</div>
		<div class="control-group span6">
			<div class="controls">
				<label for="batch-length"><?php echo JText::_('COM_DJCATALOG2_DIMENSIONS_BATCH_LBL'); ?></label>
				<input type="text" value="" autocomplete="off" name="batch[length]" id="batch-length" class="input-medium" placeholder="<?php echo JText::_('COM_DJCATALOG2_LENGTH');?>" />
				<input type="text" value="" autocomplete="off" name="batch[width]" id="batch-width" class="input-medium" placeholder="<?php echo JText::_('COM_DJCATALOG2_WIDTH');?>" />
				<input type="text" value="" autocomplete="off" name="batch[height]" id="batch-height" class="input-medium" placeholder="<?php echo JText::_('COM_DJCATALOG2_HEIGHT');?>" />
				<br />
				<select name="batch[dimensions_unit]" class="input input-medium">
					<?php 
					echo JHtml::_('select.options', $dimension_units, 'value', 'text', null, true); ?>
				</select>
				<select name="batch[dimensions_target]" class="input input-medium">
					<?php 
					echo JHtml::_('select.options', $targetOpts, 'value', 'text', null, true); ?>
				</select>
			</div>
			<div class="controls">
				<label for="batch-weight"><?php echo JText::_('COM_DJCATALOG2_WEIGHT_BATCH_LBL'); ?></label>
				<input type="text" value="" autocomplete="off" name="batch[weight]" id="batch-weight" class="input-medium" placeholder="<?php echo JText::_('COM_DJCATALOG2_WEIGHT');?>" />
				<br />
				<select name="batch[weight_unit]" class="input input-small ">
					<?php 
					echo JHtml::_('select.options', $weight_units, 'value', 'text', null, true);?>
				</select>
				<select name="batch[weight_target]" class="input input-medium">
					<?php 
					echo JHtml::_('select.options', $targetOpts, 'value', 'text', null, true); ?>
				</select>
			</div>
		</div>
	</div>
</div>
