<?php
/**
 * @package DJ-Catalog2
 * @copyright Copyright (C) DJ-Extensions.com, All rights reserved.
 * @license http://www.gnu.org/licenses GNU/GPL
 * @author url: http://dj-extensions.com
 * @author email contact@dj-extensions.com
 *
 */

// no direct access
defined('_JEXEC') or die;

JHtml::_('bootstrap.tooltip');

$listOrder	= $this->state->get('list.ordering');
$listDirn	= $this->state->get('list.direction');
$customer_type = $this->state->get('filter.customer_type', 'registered');

?>
<form action="<?php echo JRoute::_('index.php?option=com_djcatalog2&view=customers');?>" method="post" name="adminForm" id="adminForm">
    <?php if(!empty( $this->sidebar)): ?>
    <div id="j-sidebar-container" class="span2">
        <?php echo $this->sidebar; ?>
    </div>
    <div id="j-main-container" class="span10">
        <?php else : ?>
        <div id="j-main-container">
            <?php endif;?>
            <div id="filter-bar" class="btn-toolbar">
                <div class="filter-search btn-group pull-left">
                    <label class="element-invisible" for="filter_search"><?php echo JText::_('JSEARCH_FILTER_LABEL'); ?></label>
                    <input type="text" name="filter_search" id="filter_search" value="<?php echo $this->escape($this->state->get('filter.search')); ?>"  />
                </div>
                <div class="btn-group pull-left">
                    <button type="submit" class="btn"><?php echo JText::_('JSEARCH_FILTER_SUBMIT'); ?></button>
                    <button type="button" class="btn" onclick="document.getElementById('filter_search').value='';this.form.submit();"><?php echo JText::_('JSEARCH_FILTER_CLEAR'); ?></button>
                </div>
                <div class="btn-group pull-right hidden-phone">
                    <label for="limit" class="element-invisible"><?php echo JText::_('JFIELD_PLG_SEARCH_SEARCHLIMIT_DESC');?></label>
                    <?php echo $this->pagination->getLimitBox(); ?>
                </div>
            </div>
            <div class="js-stools-container-filters clearfix">
                <div class="btn-toolbar">
                    <div class="btn-group ">
                        <select name="filter_customer_type" class="inputbox" onchange="this.form.submit()">
                            <?php
                            echo JHtml::_('select.options', array(
                                JHtml::_('select.option', 'registered', 'COM_DJCATALOG2_OPT_REGISTRED'),
                            	JHtml::_('select.option', 'guest', 'COM_DJCATALOG2_OPT_GUEST'),
                            ), 'value', 'text', $customer_type, true);?>
                        </select>
                    </div>
                </div>
            </div>
            <div class="clearfix"> </div>
            <table class="table table-striped">
                <thead>
                <tr>
                    <th width="1%" class="hidden-phone">
                        <input type="checkbox" name="checkall-toggle" value="" title="<?php echo JText::_('JGLOBAL_CHECK_ALL'); ?>" onclick="Joomla.checkAll(this)" />
                    </th>
                    <th class="left">
                        <?php echo JHtml::_('grid.sort', 'COM_DJCATALOG2_JUSER', 'u.username' , $listDirn, $listOrder); ?>
                    </th>
                    <th width="15%">
                        <?php echo JHtml::_('grid.sort', 'COM_DJCATALOG2_EMAIL', 'u.email', $listDirn, $listOrder); ?>
                    </th>
                    <th colspan="5" width="50%">
                        <?php echo JText::_('COM_DJCATALOG2_BILLING_DETAILS'); ?>
                    </th>
                    <?php if ($customer_type == 'registered') {?>
                    	<th class="center nowrap">
	                        <?php echo JText::_('COM_DJCATALOG2_VENDORS'); ?>
	                    </th>
                    <?php } ?>
                    <th width="1%" class="nowrap">
                        <?php echo JHtml::_('grid.sort', 'JGRID_HEADING_ID', 'u.id', $listDirn, $listOrder); ?>
                    </th>
                </tr>
                </thead>
                <tfoot>
                <tr>
                    <td colspan="10">
                        <?php echo $this->pagination->getListFooter(); ?>
                    </td>
                </tr>
                </tfoot>
                <tbody>
                <?php

                foreach ($this->items as $i => $item) :
                    ?>
                    <tr class="row<?php echo $i % 2; ?>">

                        <td class="center">
                            <?php if(isset($item->_user_id)) : ?>
                                <?php echo JHtml::_('grid.id', $i, (int)$item->_user_id.','.(int)$item->id); ?>
                            <?php endif; ?>
                        </td>

                        <td>
                            <?php if(isset($item->username)) : ?>
                                <span class="editlinktip hasTip" title="<?php echo JText::_( 'COM_DJCATALOG2_EDIT_TOOLTIP' );?>::<?php echo $this->escape($item->username); ?>">
                            <a href="<?php echo JRoute::_('index.php?option=com_users&task=user.edit&id='.$item->_user_id);?>">
                                <?php echo $this->escape($item->username); ?></a>
                        </span>

                                <?php
                                /*?>
                                <span class="editlinktip hasTip" title="<?php echo JText::_( 'COM_DJCATALOG2_EDIT_TOOLTIP' );?>::<?php echo $this->escape($item->username); ?>">
                                    <a href="<?php echo JRoute::_('index.php?option=com_djcatalog2&task=customer.edit&cid[]='.(int)$item->_user_id.','.(empty($item->id) ? 0 : (int)$item->id));  ?>">
                                    <?php echo $item->username; ?></a>
                                </span>
                                <?php */ ?>

                                <p class="smallsub">
                                    <?php echo $this->escape($item->name); ?>
                                </p>
                            <?php endif; ?>
                            <?php if(isset($item->guestname)) : ?>
                                <?php echo $item->guestname; ?>
                            <?php endif;?>
                        </td>



                        <?php /* ?>
				<td class="center">

					[<a href="<?php echo JRoute::_('index.php?option=com_djcatalog2&task=customer.edit&cid[]='.(int)$item->_user_id.','.(empty($item->id) ? 0 : (int)$item->id));  ?>"><?php echo JText::_('COM_DJCATALOG2_EDIT_PROFILE'); ?></a>]
					[<a href="<?php echo JRoute::_('index.php?option=com_users&task=user.edit&id='.$item->_user_id);?>"><?php echo JText::_('COM_DJCATALOG2_EDIT_USER'); ?></a>]
				</td>
				<?php */ ?>

                        <td class="center">
                            <a href="mailto:<?php echo $this->escape($item->email); ?>"><?php echo $this->escape($item->email); ?></a>
                        </td>


                        <td class="center">
                            <?php if(isset($item->_user_id)) : ?>
                                <?php if ($item->id) { ?>
                                    <span class="editlinktip hasTip" title="<?php echo JText::_( 'COM_DJCATALOG2_EDIT_TOOLTIP' );?>::<?php echo $this->escape($item->username); ?>">
                                    <a href="<?php echo JRoute::_('index.php?option=com_djcatalog2&task=customer.edit&cid[]='.(int)$item->_user_id.','.(int)$item->id); ?>">
                                        <?php echo $item->firstname.' '.$item->lastname; ?></a>
                                </span>
                                <?php } ?>
                            <?php endif; ?>
                        </td>


                        <td class="center">
                            <?php echo $item->company; ?>
                        </td>
                        <td class="center">
                            <?php echo $item->city ? $item->postcode.' '.$item->city: ''; ?>
                        </td>
                        <td class="center">
                            <?php echo $item->address;?>
                        </td>
                        <td class="center">
                            <?php echo $item->country_name; ?>
                        </td>
                        
                        <?php if ($customer_type == 'registered') {?>
                        	<td class="center">
                        		<?php if (!empty($item->_vendors)) {?>
                        			<?php 
                        			$vendors=[]; 
                        			foreach($item->_vendors as $vendor) {
                        				//$vendors[] = htmlspecialchars($vendor->name. ' <' . $vendor->email .'>');
                        				$vendors[] = '<a target="_blank" href="'.JRoute::_('index.php?option=com_users&task=user.edit&id=' . $vendor->id). '">' . htmlspecialchars($vendor->name) . '</a>';
                        			}
                        			echo implode(', ', $vendors);
                        			?>
                        		<?php } ?>
                        	</td>
                        <?php } ?>

                        <td class="center">
                            <?php if(isset($item->_user_id)) : ?>
                                <?php echo (int) $item->_user_id; ?>
                            <?php endif; ?>
                        </td>
                    </tr>
                <?php endforeach; ?>
                </tbody>
            </table>

            <div>
                <input type="hidden" name="task" value="" />
                <input type="hidden" name="boxchecked" value="0" />
                <input type="hidden" name="filter_order" value="<?php echo $listOrder; ?>" />
                <input type="hidden" name="filter_order_Dir" value="<?php echo $listDirn; ?>" />
                <?php echo JHtml::_('form.token'); ?>
            </div>
        </div>
</form>

