<?php
/**
 * @package DJ-Catalog2
 * @copyright Copyright (C) DJ-Extensions.com, All rights reserved.
 * @license http://www.gnu.org/licenses GNU/GPL
 * @author url: http://dj-extensions.com
 * @author email contact@dj-extensions.com
 *
 */

defined('_JEXEC') or die('Restricted access'); 

$user = JFactory::getUser();
$actions = (array)JHelperContent::getActions('com_djcatalog2');
$accessIcons = array();

if ($actions['djcatalog2.admin.catalogue'] || $actions['djcatalog2.access.catalogue']) {
	$accessIcons[] = array(
		'title' => JText::_('COM_DJCATALOG2_ITEMS'),
		'link' => 'index.php?option=com_djcatalog2&amp;view=items',
		'icon' => JUri::base(true) . '/components/com_djcatalog2/assets/images/icon-48-item.png'
	);
	if ($actions['djcatalog2.admin.catalogue']) {
		$accessIcons[] = array(
			'title' => JText::_('COM_DJCATALOG2_NEW_ITEM'),
			'link' => 'index.php?option=com_djcatalog2&amp;task=item.add',
			'icon' => JUri::base(true) . '/components/com_djcatalog2/assets/images/new_product.png'
		);
	}
	$accessIcons[] = array(
		'title' => JText::_('COM_DJCATALOG2_CATEGORIES'),
		'link' => 'index.php?option=com_djcatalog2&amp;view=categories',
		'icon' => JUri::base(true) . '/components/com_djcatalog2/assets/images/icon-48-category.png'
	);
	if ($actions['djcatalog2.admin.catalogue']) {
		$accessIcons[] = array(
			'title' => JText::_('COM_DJCATALOG2_NEW_CATEGORY'),
			'link' => 'index.php?option=com_djcatalog2&amp;task=category.add',
			'icon' => JUri::base(true) . '/components/com_djcatalog2/assets/images/new_category.png'
		);
	}
	$accessIcons[] = array(
		'title' => JText::_('COM_DJCATALOG2_PRODUCERS'),
		'link' => 'index.php?option=com_djcatalog2&amp;view=producers',
		'icon' => JUri::base(true) . '/components/com_djcatalog2/assets/images/icon-48-producer.png'
	);
	if ($actions['djcatalog2.admin.catalogue']) {
		$accessIcons[] = array(
			'title' => JText::_('COM_DJCATALOG2_NEW_PRODUCER'),
			'link' => 'index.php?option=com_djcatalog2&amp;task=producer.add',
			'icon' => JUri::base(true) . '/components/com_djcatalog2/assets/images/new_producer.png'
		);
	}
	$accessIcons[] = array(
		'title' => JText::_('COM_DJCATALOG2_FIELDGROUPS'),
		'link' => 'index.php?option=com_djcatalog2&amp;view=fieldgroups',
		'icon' => JUri::base(true) . '/components/com_djcatalog2/assets/images/icon-48-fieldgroups.png'
	);
	if ($actions['djcatalog2.admin.catalogue']) {
		$accessIcons[] = array(
			'title' => JText::_('COM_DJCATALOG2_NEW_FIELDGROUP'),
			'link' => 'index.php?option=com_djcatalog2&amp;task=fieldgroup.add',
			'icon' => JUri::base(true) . '/components/com_djcatalog2/assets/images/new_fieldgroup.png'
		);
	}
	$accessIcons[] = array(
		'title' => JText::_('COM_DJCATALOG2_FIELDS'),
		'link' => 'index.php?option=com_djcatalog2&amp;view=fields',
		'icon' => JUri::base(true) . '/components/com_djcatalog2/assets/images/icon-48-extrafields.png'
	);
	if ($actions['djcatalog2.admin.catalogue']) {
		$accessIcons[] = array(
			'title' => JText::_('COM_DJCATALOG2_NEW_FIELD'),
			'link' => 'index.php?option=com_djcatalog2&amp;task=field.add',
			'icon' => JUri::base(true) . '/components/com_djcatalog2/assets/images/new_extrafield.png'
		);
	}
}

if ($actions['djcatalog2.admin.orders'] || $actions['djcatalog2.access.orders']) {
	$accessIcons[] = array(
		'title' => JText::_('COM_DJCATALOG2_QUERIES'),
		'link' => 'index.php?option=com_djcatalog2&amp;view=queries',
		'icon' => JUri::base(true) . '/components/com_djcatalog2/assets/images/icon-48-queries.png'
	);
	$accessIcons[] = array(
		'title' => JText::_('COM_DJCATALOG2_ORDERS'),
		'link' => 'index.php?option=com_djcatalog2&amp;view=orders',
		'icon' => JUri::base(true) . '/components/com_djcatalog2/assets/images/icon-48-orders.png'
	);
	$accessIcons[] = array(
		'title' => JText::_('COM_DJCATALOG2_SUBSCRIPTIONS'),
		'link' => 'index.php?option=com_djcatalog2&amp;view=subscriptions',
		'icon' => JUri::base(true) . '/components/com_djcatalog2/assets/images/icon-48-orders.png'
	);
}

if ($actions['djcatalog2.admin.misc_settings']) {
	$accessIcons[] = array(
		'title' => JText::_('COM_DJCATALOG2_COUNTRIES'),
		'link' => 'index.php?option=com_djcatalog2&amp;view=countries',
		'icon' => JUri::base(true) . '/components/com_djcatalog2/assets/images/icon-48-countries.png'
	);
	/*$accessIcons[] = array(
		'title' => JText::_('COM_DJCATALOG2_COUNTRIES'),
		'link' => 'index.php?option=com_djcatalog2&amp;view=countries',
		'icon' => JUri::base(true) . '/components/com_djcatalog2/assets/images/icon-48-countries.png'
	);*/
}

if ($user->authorise('core.admin', 'com_djcatalog2') || $user->authorise('core.options', 'com_djcatalog2')) {
	$accessIcons[] = array(
		'title' => JText::_('COM_DJCATALOG2_IMAGES_MANAGER'),
		'link' => 'index.php?option=com_djcatalog2&amp;view=thumbs',
		'icon' => JUri::base(true) . '/components/com_djcatalog2/assets/images/icon-48-resize.png'
	);
	$accessIcons[] = array(
		'title' => JText::_('JOPTIONS'),
		'link' => 'index.php?option=com_config&amp;view=component&amp;component=com_djcatalog2&amp;path=&amp;return='.urlencode(base64_encode(JUri::getInstance()->toString())),
		'icon' => JUri::base(true) . '/components/com_djcatalog2/assets/images/icon-48-config.png'
	);
}

$accessIcons[] = array(
	'title' => JText::_('COM_DJCATALOG2_DOCUMENTATION'),
	'link' => 'http://dj-extensions.com/extensions/dj-catalog2',
	'icon' => JUri::base(true) . '/components/com_djcatalog2/assets/images/icon-48-documentation.png',
	'target' => '_blank'
);
$accessIcons[] = array(
	'title' => JText::_('COM_DJCATALOG2_CPANEL_ADD_NEW_FEATURES'),
	'link' => 'https://connect.dj-extensions.com/tjk/form/DJCatalog2extensionsform/formperma/oIXL7SKpPt7XxKHXzLhEWlTSxM1EduFSFHvwEXvZerg',
	'icon' => JUri::base(true) . '/components/com_djcatalog2/assets/images/icon-48-new-features.png',
	'target' => '_blank',
	'onclick' => 'zforms_open_window(this.href, 648, 700); return false'
);

?>

<form action="index.php" method="post" name="adminForm" id="adminForm">
<?php if(!empty( $this->sidebar)): ?>
	<div id="j-sidebar-container" class="span2">
		<?php echo $this->sidebar; ?>
	</div>
	<div id="j-main-container" class="span10">
	<?php else: ?>
	<div id="j-main-container">
	<?php endif;?>
		<div class="djc_control_panel clearfix">
			<div class="cpanel-left">
				<div class="cpanel">
					<?php foreach ($accessIcons as $pos => $icon) { ?>
						<div class="icon">
							<a href="<?php echo $icon['link']; ?>" <?php if (isset($icon['target'])) { echo 'target="'.$icon['target'].'"'; }?> <?php if (isset($icon['onclick'])) { echo 'onclick="'.$icon['onclick'].'"'; }?>>
								<img alt="<?php echo $icon['title']?>" src="<?php echo $icon['icon']; ?>" />
								<span><?php echo $icon['title']; ?></span>
							</a>
						</div>
						
						<?php if (($pos+1) % 5 == 0 || $pos + 1 >= count($accessIcons)) {?>
							<div style="clear: both"></div>
						<?php } ?>
					<?php } ?>
				</div>
			</div>
			<div class="cpanel-right">
				<div class="djlic_cpanel cpanel">
					<div style="float:right;">
						<?php 
						$user = JFactory::getUser();
						if ($user->authorise('core.admin', 'com_djcatalog2')){
							echo DJLicense::getSubscription('Catalog2'); 
						}?>
					</div>
				</div>
			</div>
		</div>

	<input type="hidden" name="option" value="com_djcatalog2" />
	<input type="hidden" name="c" value="cpanel" />
	<input type="hidden" name="task" value="" />
	<input type="hidden" name="view" value="cpanel" />
	<input type="hidden" name="boxchecked" value="0" />
	<?php echo JHTML::_( 'form.token' ); ?>
</div>
</form>
<div style="clear: both" class="clr"></div>
<?php echo DJCATFOOTER; ?>

<script type="text/javascript">
	Joomla.submitbutton = function(task)
	{
		if (task == 'toggleModeDefault' || task == 'toggleModeCatalog') {
			var okay = confirm('<?php echo JText::_('COM_DJCATALOG2_TOGGLE_MODE_WARNING'); ?>');
			if (!okay) {
				return; 
			}
			if (task == 'toggleModeDefault') {
				window.location.href = '<?php echo JRoute::_('index.php?option=com_djcatalog2&task=toggleMode&mode=default', false); ?>';
			} else if (task == 'toggleModeCatalog') {
				window.location.href = '<?php echo JRoute::_('index.php?option=com_djcatalog2&task=toggleMode&mode=catalog', false); ?>';
			}
		}
	}
</script>

<script type="text/javascript">
	function zforms_open_window(url, height, width){var leftPos = 0;var topPos = 0;if(screen){leftPos = (screen.width - width) / 2;topPos = (screen.height - height) / 2;window.open(url, null, 'width='+width+',height='+height+',left='+leftPos+',top='+topPos+', toolbar=0, location=0, status=1, scrollbars=1, resizable=1');}}
</script>