<?php
/**
 * @package DJ-Catalog2
 * @copyright Copyright (C) DJ-Extensions.com, All rights reserved.
 * @license http://www.gnu.org/licenses GNU/GPL
 * @author url: http://dj-extensions.com
 * @author email contact@dj-extensions.com
 */

use Joomla\Utilities\ArrayHelper;

// no direct access
defined('_JEXEC') or die;

$pricesModel = JModelLegacy::getInstance('Prices', 'DJCatalog2Model', array('ignore_request' => true));
$dimension_units = $pricesModel->getUnits('length');
$weight_units = $pricesModel->getUnits('weight');
$targetOpts = array(
    JHtmlSelect::option(1, 'COM_DJCATALOG2_BATCH_TARGET_MAINITEM'),
    JHtmlSelect::option(2, 'COM_DJCATALOG2_BATCH_TARGET_COMBINATIONS'),
    JHtmlSelect::option(3, 'COM_DJCATALOG2_BATCH_TARGET_BOTH')
);

JFactory::getDocument()->addScriptDeclaration(
    '
		jQuery(document).ready(function($){
			var langSelector = $("#batch-language-id");
			var langCopy = $("#batch-language-copy");
			
			$(langCopy).hide();
			langSelector.on("change", function(){
				if (langSelector.val() != 0 || langSelector.val() != "") {
					$(langCopy).show();
				} else {
					$(langCopy).hide();
				}
			});
		});
			'
);

?>
<div class="container-fluid">
    <div class="row-fluid">
        <div class="control-group span6">
            <div class="controls">
                <label id="batch-language-lbl" for="batch-language-id" class="modalTooltip"
                       title="<?php echo JHtml::_('tooltipText', 'COM_DJCATALOG2_BATCH_COPY_LANGUAGE', 'COM_DJCATALOG2_BATCH_COPY_LANGUAGE_DESC'); ?>">
                    <?php echo JText::_('COM_DJCATALOG2_BATCH_COPY_LANGUAGE'); ?>
                </label>
                <select name="batch[language_id]" class="inputbox" id="batch-language-id">
                    <option value=""><?php echo JText::_('COM_DJCATALOG2_BATCH_LANGUAGE_DONT_COPY'); ?></option>
                    <?php echo JHtml::_('select.options', JHtml::_('contentlanguage.existing', true, true), 'value', 'text'); ?>
                </select>

                <div id="batch-language-copy" class="control-group radio">
                    <div class="control-group">
                        <div class="controls">
                            <fieldset id="batch_move_copy" class="btn-group radio">
                                <input type="radio" id="batch_move_copy0" name="jform[available]" value="move"
                                       checked="checked"> <label for="batch_move_copy0" class="btn active btn-success">
                                    <?php echo JText::_('JLIB_HTML_BATCH_MOVE'); ?> </label>

                                <input type="radio" id="batch_move_copy1" name="jform[available]" value="copy"> <label
                                        for="batch_move_copy1" class="btn">
                                    <?php echo JText::_('JLIB_HTML_BATCH_COPY'); ?> </label>
                            </fieldset>
                        </div>
                    </div>

                    <div class="controls">
                        <label for="batch[language_copy]y" id="batch[move_copy]y-lbl" class="radio">
                            <input type="radio" name="batch[language_copy]" id="batch[language_copy]y" value="y">
                            <?php echo JText::_('COM_DJCATALOG2_BATCH_LANGUAGE_COPY_ASSIGNMENTS'); ?>
                        </label>
                        <label for="batch[language_copy]n" id="batch[move_copy]n-lbl" class="radio">
                            <input type="radio" name="batch[language_copy]" id="batch[language_copy]n" value="n">
                            <?php echo JText::_('COM_DJCATALOG2_BATCH_LANGUAGE_DONT_COPY_ASSIGNMENTS'); ?>
                        </label>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
