<?php
/**
 * @package DJ-Catalog2
 * @copyright Copyright (C) DJ-Extensions.com, All rights reserved.
 * @license http://www.gnu.org/licenses GNU/GPL
 * @author url: http://dj-extensions.com
 * @author email contact@dj-extensions.com
 */

defined('_JEXEC') or die('Restricted access');

JHtml::_('jquery.framework');
JHtml::_('behavior.tooltip');

?>
<div>
	<div id="j-sidebar-container" class="span2">
		<?php echo $this->sidebar; ?>
	</div>
	<div id="j-main-container" class="span10 form-horizontal">
		<fieldset>
 			<textarea rows="10" cols="50" id="djc_batchopt_log" disabled="disabled" style="width: 100%"></textarea>
			<div class="control-group">
				<div class="control-label">&nbsp;</div>
				<div class="controls djc_batchopt_log_wrapper"></div>
			</div>
			<div class="control-group">
				<div class="control-label">&nbsp;</div>
				<div class="controls djc_batchopt">
					<div style="clear: both" class="clr"></div>
					<div id="djc_progress_bar_outer" class="progress input-xxlarge">
						<div id="djc_progress_bar" class="bar"></div>
					</div>
					<div id="djc_progress_percent" class="input-xxlarge text-center">0%</div>
					<div id="djc_batch_return" style="display: none;" class="input-xxlarge text-center">
						<a href="index.php?option=com_djcatalog2&view=<?php echo $this->type ?>">Back</a>
					</div>
				</div>
			</div>


			<div style="clear: both">
				<br/> <br/>
			</div>
		</fieldset>
	</div>
</div>

<?php if (count($this->items) && !empty($this->batch) && $this->type) : ?>
	<script>
		jQuery(document).ready(function () {

			var cid = JSON.parse('<?php echo json_encode($this->items) ?>');
			var type = '<?php echo $this->type ?>';
			var batchOpt = JSON.parse('<?php echo json_encode($this->batch) ?>');

			var recProgressBar = jQuery('#djc_progress_bar');
			var recProgressPercent = jQuery('#djc_progress_percent');

			var cursor = 0;

			initBatch();

			function initBatch() {


				jQuery.ajax({
					url: 'index.php?option=com_djcatalog2&task=batch.' + type,
					data: {
						id: cid[cursor],
						batch: batchOpt,
						cursor: cursor
					},
					method: 'post',
					encoding: 'utf-8',
				}).done(function (response) {

					var data = JSON.parse(response);
					console.log(data);

					var log = '[' + ((data.success) ? 'V' : 'X') + '] : ' + data.message + ((data.error.length) ? ' : ' + data.error : ' ');

					jQuery('#djc_batchopt_log').append(log + "\r\n");

					updateProgress(cursor);

					cursor++;
					if (cursor < cid.length) {
						initBatch();
					} else {
						jQuery('#djc_batch_return').show();
					}
				});
			}

			function updateProgress(cursor) {

				var percentage = ((cursor + 1) / cid.length) * 100;

				recProgressBar.css('width', percentage + '%');
				recProgressPercent.html(Math.floor(percentage) + '%');
			}


		});
	</script>
<?php endif; ?>
