<?php
/**
 * @package DJ-Catalog2
 * @copyright Copyright (C) 2012 DJ-Extensions.com LTD, All rights reserved.
 * @license http://www.gnu.org/licenses GNU/GPL
 * @author url: http://dj-extensions.com
 * @author email contact@dj-extensions.com
 */

use Joomla\Registry\Registry;

// No direct access
defined('_JEXEC') or die;

class Djcatalog2TablePriceRules extends JTable
{
    public function __construct(&$db)
    {
        parent::__construct('#__djc2_price_rules', 'id', $db);
        $this->labels = array();
    }


    function bind($array, $ignore = '')
    {
        if (!in_array($array['type'], array('percent', 'amount'))) {
            $array['type'] = 'percent';
        }

        if (!in_array($array['operation'], array('sub', 'add'))) {
            $array['type'] = 'sub';
        }

        if (isset($array['product_id']) && is_array($array['product_id'])) {
            $registry = new Registry();
            $registry->loadArray($array['product_id']);
            $array['product_id'] = (string)$registry;
        } else if (!isset($array['product_id'])) {
            $array['product_id'] = '';
        }

        if (isset($array['category_id']) && is_array($array['category_id'])) {
            $registry = new Registry();
            $registry->loadArray($array['category_id']);
            $array['category_id'] = (string)$registry;
        } else if (!isset($array['category_id'])) {
            $array['category_id'] = '';
        }
        
        if (isset($array['producer_id']) && is_array($array['producer_id'])) {
        	$registry = new Registry();
        	$registry->loadArray($array['producer_id']);
        	$array['producer_id'] = (string)$registry;
        } else if (!isset($array['producer_id'])) {
        	$array['producer_id'] = '';
        }

        if (isset($array['countries']) && is_array($array['countries'])) {
            $registry = new Registry();
            $registry->loadArray($array['countries']);
            $array['countries'] = (string)$registry;
        } else if (!isset($array['countries'])) {
            $array['countries'] = '';
        }

        if (isset($array['extra_fields']) && is_array($array['extra_fields'])) {
            $array['extra_fields'] = json_encode($array['extra_fields']);
        } else if (!isset($array['extra_fields'])) {
            $array['extra_fields'] = '';
        }

        if (isset($array['customer_groups']) && is_array($array['customer_groups'])) {
            $array['customer_groups'] = json_encode($array['customer_groups']);
        } else if (!isset($array['customer_groups'])) {
            $array['customer_groups'] = '';
        }
        
        if (isset($array['deliveries']) && is_array($array['deliveries'])) {
        	$registry = new Registry();
        	$registry->loadArray($array['deliveries']);
        	$array['deliveries'] = (string)$registry;
        } else if (!isset($array['deliveries'])) {
        	$array['deliveries'] = '';
        }
        
        if (isset($array['payments']) && is_array($array['payments'])) {
        	$registry = new Registry();
        	$registry->loadArray($array['payments']);
        	$array['payments'] = (string)$registry;
        } else if (!isset($array['payments'])) {
        	$array['payments'] = '';
        }


        return parent::bind($array, $ignore);
    }

    public function store($updateNulls = false)
    {
        $labels = $this->labels;
        unset($this->labels);

        $date = JFactory::getDate();
        $user = JFactory::getUser();

        if (!$this->id) {
            if (!intval($this->created)) {
                $this->created = $date->toSql();
            }

            if (empty($this->created_by)) {
                $this->created_by = $user->get('id');
            }
        } else {
            $this->modified = $date->toSql();
            $this->modified_by = $user->get('id');
        }

        $store = parent::store($updateNulls);

        if ($store) {
            $db = JFactory::getDbo();

            $db->setQuery('delete from #__djc2_price_rules_labels where price_rule_id='.(int)$this->id);
            if (!$db->query()) {
                $this->setError($db->getErrorMsg());
                return false;
            }

            foreach ($labels as $label) {
                $db->setQuery('INSERT INTO #__djc2_price_rules_labels (price_rule_id, label_id) VALUES (' . $this->id . ', ' . $label . ')');
                if (!$db->query()) {
                    $this->setError($db->getErrorMsg());
                    return false;
                }
            }

        }


        return $store;

    }
}

