<?php
/**
 * @package DJ-Catalog2
 * @copyright Copyright (C) DJ-Extensions.com, All rights reserved.
 * @license http://www.gnu.org/licenses GNU/GPL
 * @author url: http://dj-extensions.com
 * @author email contact@dj-extensions.com
 */

// No direct access
defined('_JEXEC') or die;

class Djcatalog2TableOrderStatuses extends JTable
{
	public function __construct(&$db)
	{
		parent::__construct('#__djc2_order_statuses', 'id', $db);
	}
	function bind($array, $ignore = '')
	{	
		if (isset($array['status_code']) && $array['status_code'] != '') {
			$array['status_code'] = strtoupper(substr($array['status_code'],0,1));
		}
		return parent::bind($array, $ignore);
	}
	public function store($updateNulls = false)
	{
		$table = JTable::getInstance('OrderStatuses', 'Djcatalog2Table');
		if ($table->load(array('status_code'=>$this->status_code)) && ($table->id != $this->id || $this->id==0)) {
			$this->setError(JText::_('COM_DJCATALOG2_ERROR_UNIQUE_ORDER_STATUS_CODE'));
			return false;
		}
		
		return parent::store($updateNulls);
	}
}
