<?php
/**
 * @package DJ-Catalog2
 * @copyright Copyright (C) DJ-Extensions.com, All rights reserved.
 * @license http://www.gnu.org/licenses GNU/GPL
 * @author url: http://dj-extensions.com
 * @author email contact@dj-extensions.com
 */

// No direct access
defined('_JEXEC') or die;

class Djcatalog2TableExrates extends JTable
{
	public function __construct(&$db)
	{
		parent::__construct('#__djc2_currency_exchange', 'id', $db);
	}
	function bind($array, $ignore = '')
	{	
		return parent::bind($array, $ignore);
	}
	public function store($updateNulls = false)
	{
		$date	= JFactory::getDate();
		$user	= JFactory::getUser();
		$app = JFactory::getApplication();
		$db = JFactory::getDbo();
		
		
		
		$id = (int)$this->id;
		$target_id = (int)$this->target_id;
		$base_id = (int)$this->base_id;
		
		if ($target_id == $base_id) {
			$this->setError(JText::_('COM_DJCATALOG2_ERROR_EXCHANGE_SAME_CURRENCIES'));
			return false;
		}
		
		$rate_date = $this->rate_date;
		
		$query = $db->getQuery(true);
		$where = array();
		
		$query->select('count(*)');
		$query->from('#__djc2_currency_exchange');
		
		if ($id) {
			$where[] = 'id != '.$id;
		}
		if ($target_id > 0) {
			$where[] = 'target_id='.$target_id;
		}
		
		$where[] = 'DATE(rate_date)= DATE('.$db->quote($rate_date).')';
		$where[] = 'base_id=' . $this->base_id;
		
		$query->where($where);
		
		$db->setQuery($query);
		$count = $db->loadResult();

		if ($count > 0) {
			$this->setError(JText::_('COM_DJCATALOG2_ERROR_UNIQUE_DATE'));
			return false;
		}
	
		return parent::store($updateNulls);
	}
}
