<?php
/**
 * @package DJ-Catalog2
 * @copyright Copyright (C) DJ-Extensions.com, All rights reserved.
 * @license http://www.gnu.org/licenses GNU/GPL
 * @author url: http://dj-extensions.com
 * @author email contact@dj-extensions.com
 */

// No direct access
defined('_JEXEC') or die;

class Djcatalog2TableCustomers extends JTable
{
	public $vendors = [];
	
	public function __construct(&$db)
	{
		parent::__construct('#__djc2_users', 'id', $db);
	}
	function bind($array, $ignore = '')
	{
		return parent::bind($array, $ignore);
	}
	public function store($updateNulls = false)
	{
		$vendors = $this->vendors;
		unset($this->vendors);
		
		if (!$this->user_id) {
			$this->setError(JText::_('COM_DJCATALOG2_ERROR_USER_ID_MISSING'));
			return false;
		}	
		$table = JTable::getInstance('Customers', 'Djcatalog2Table');
		
		if ($table->load(array('user_id'=>$this->user_id)) && ($table->id != $this->id || $this->id==0)) {
			$this->setError(JText::_('COM_DJCATALOG2_ERROR_UNIQUE_USER_ID'));
			return false;
		}
		
		$success = parent::store($updateNulls);
		
		if (!$success) {
			return false;
		}
		
		$db = JFactory::getDbo();
		
		if ($this->id && $this->user_id) {
			$db->setQuery('DELETE FROM #__djc2_vendors_customers WHERE customer_id='.(int)$this->user_id);
			$db->execute();
			
			
			if (count($vendors)) {
				foreach ($vendors as $vendor_id) {
					$db->setQuery('INSERT INTO #__djc2_vendors_customers (vendor_id, customer_id) VALUES ('.$vendor_id.', '.$this->user_id.')');
					$db->execute();
				}
			}
		}
		
		
		$this->vendors = $vendors;
		unset($vendors);
		
		return true;
	}
	
}
