<?php
/**
 * @package DJ-Catalog2
 * @copyright Copyright (C) DJ-Extensions.com, All rights reserved.
 * @license http://www.gnu.org/licenses GNU/GPL
 * @author url: http://dj-extensions.com
 * @author email contact@dj-extensions.com
 */

// No direct access.
defined('_JEXEC') or die;

class Djcatalog2ModelReview extends JModelAdmin
{
	protected $text_prefix = 'COM_DJCATALOG2';

	public function __construct($config = array()) {
		parent::__construct($config);
	}

	public function getTable($type = 'Reviews', $prefix = 'Djcatalog2Table', $config = array())
	{
		return JTable::getInstance($type, $prefix, $config);
	}
	public function getForm($data = array(), $loadData = true)
	{
		// Initialise variables.
		$app	= JFactory::getApplication();

		// Get the form.
		$form = $this->loadForm('com_djcatalog2.review', 'review', array('control' => 'jform', 'load_data' => $loadData));
		if (empty($form)) {
			return false;
		}
		return $form;
	}

	protected function loadFormData()
	{
		$data = JFactory::getApplication()->getUserState('com_djcatalog2.edit.review.data', array());

		if (empty($data)) {
			$data = $this->getItem();
		}

		return $data;
	}

	protected function prepareTable($table)
	{
	}

	protected function getReorderConditions($table = null)
	{
		$condition = array();
		return $condition;
	}
	
	protected function recalculateRating($item_id) {
		$db = JFactory::getDbo();
		$query = $db->getQuery(true);
		$query->select('sum(rating) as rating_sum, count(*) as rating_count');
		$query->from('#__djc2_item_reviews');
		$query->where('item_id=' . (int)$item_id);
		$db->setQuery($query);
		$reviews = $db->loadObject();
		
		$query = $db->getQuery(true);
		$query->select('*');
		$query->from('#__djc2_item_rating');
		$query->where('item_id=' . (int)$item_id);
		$db->setQuery($query);
		$rating = $db->loadObject();
		 
		$query = $db->getQuery(true);
		
		if (empty($reviews) || empty($reviews->rating_count)) {
			$query->delete('#__djc2_item_rating');
			$query->where('item_id=' . (int)$item_id);
		} else {
			if (empty($rating)) {
				$userIP = Joomla\Utilities\IpHelper::getIp();
				$query->insert('#__djc2_item_rating');
				$query->columns(['item_id', 'rating_sum', 'rating_count', 'lastip']);
				$query->values( (int)$item_id . ', ' . $reviews->rating_sum . ', ' . $reviews->rating_count. ', ' . $db->quote($userIP));
			} else {
				$query->update('#__djc2_item_rating');
				$query->set('rating_sum=' . $reviews->rating_sum);
				$query->set('rating_count=' . $reviews->rating_count);
				$query->where('item_id=' . (int)$item_id);
			}
		}
		
		$db->setQuery($query);
		$db->execute();
	}
	
	public function save($data) {
		$return = parent::save($data);
		if ($return) {
			$this->recalculateRating($data['item_id']);
		}
		return $return;
	}

	public function delete(&$pks)
	{
		$dispatcher = JEventDispatcher::getInstance();
		$pks = (array) $pks;
		$table = $this->getTable();
		
		// Include the plugins for the delete events.
		JPluginHelper::importPlugin($this->events_map['delete']);
		
		// Iterate the items to delete each one.
		foreach ($pks as $i => $pk)
		{
			if ($table->load($pk))
			{
				if ($this->canDelete($table))
				{
					$context = $this->option . '.' . $this->name;
					
					// Trigger the before delete event.
					$result = $dispatcher->trigger($this->event_before_delete, array($context, $table));
					
					if (in_array(false, $result, true))
					{
						$this->setError($table->getError());
						
						return false;
					}
					
					if (!$table->delete($pk))
					{
						$this->setError($table->getError());
						
						return false;
					}
					
					$this->recalculateRating($table->item_id);
					
					// Trigger the after event.
					$dispatcher->trigger($this->event_after_delete, array($context, $table));
				}
				else
				{
					// Prune items that you can't change.
					unset($pks[$i]);
					$error = $this->getError();
					
					if ($error)
					{
						JLog::add($error, JLog::WARNING, 'jerror');
						
						return false;
					}
					else
					{
						JLog::add(JText::_('JLIB_APPLICATION_ERROR_DELETE_NOT_PERMITTED'), JLog::WARNING, 'jerror');
						
						return false;
					}
				}
			}
			else
			{
				$this->setError($table->getError());
				
				return false;
			}
		}
		
		// Clear the component's cache
		$this->cleanCache();
		
		return true;
	}
	
	/**
	 * Method to test whether a record can be deleted.
	 *
	 * @param   object  $record  A record object.
	 *
	 * @return  boolean  True if allowed to delete the record. Defaults to the permission for the component.
	 *
	 * @since   1.6
	 */
	protected function canDelete($record)
	{
		return JFactory::getUser()->authorise('core.delete', $this->option) || JFactory::getUser()->authorise('djcatalog2.admin.catalogue', $this->option);
	}
	
	/**
	 * Method to test whether a record can have its state changed.
	 *
	 * @param   object  $record  A record object.
	 *
	 * @return  boolean  True if allowed to change the state of the record. Defaults to the permission for the component.
	 *
	 * @since   1.6
	 */
	protected function canEditState($record)
	{
		return JFactory::getUser()->authorise('core.edit.state', $this->option)  || JFactory::getUser()->authorise('djcatalog2.admin.catalogue', $this->option);
	}
}