<?php
/**
 * @package DJ-Catalog2
 * @copyright Copyright (C) DJ-Extensions.com, All rights reserved.
 * @license http://www.gnu.org/licenses GNU/GPL
 * @author url: http://dj-extensions.com
 * @author email contact@dj-extensions.com
 *
 */

// no direct access
defined('_JEXEC') or die;

jimport('joomla.application.component.modellist');

class Djcatalog2ModelProducers extends JModelList
{
	public function __construct($config = array())
	{
		if (empty($config['filter_fields'])) {
			$config['filter_fields'] = array(
				'id', 'a.id',
				'name', 'a.name',
				'alias', 'a.alias',
				'ordering', 'a.ordering',
				'checked_out', 'a.checked_out',
				'checked_out_time', 'a.checked_out_time',
				'published', 'a.published',
				'access', 'a.access', 'access_level',
				'created', 'a.created',
				'created_by', 'a.created_by',
				'language', 'a.language',
				'association', 'a.association'
			);
		}

		parent::__construct($config);
	}
	protected function populateState($ordering = null, $direction = null)
	{
		// List state information.
		parent::populateState('a.name', 'asc');
		
		// Initialise variables.
		$app = JFactory::getApplication();
		$session = JFactory::getSession();

		$search = $this->getUserStateFromRequest($this->context.'.filter.search', 'filter_search');
		$this->setState('filter.search', $search);

		$published = $this->getUserStateFromRequest($this->context.'.filter.published', 'filter_published', '');
		$this->setState('filter.published', $published);
		
		$language = $this->getUserStateFromRequest($this->context.'.filter.language', 'filter_language', '');
		$this->setState('filter.language', $language);

		// Load the parameters.
		$params = JComponentHelper::getParams('com_djcatalog2');
		$this->setState('params', $params);
		
		/*
		 * Multilang
		 */
        if ($layout = $app->input->get('layout'))
        {
            $this->context .= '.' . $layout;
        }

        $forcedLanguage = $app->input->get('forcedLanguage', '', 'CMD');
        if ($forcedLanguage)
        {
            $this->context .= '.' . $forcedLanguage;
        }

        // If there's a forced language then define that filter for the query where clause
        if (!empty($forcedLanguage))
        {
            $this->setState('filter.language', $forcedLanguage);
        }
	}

	protected function getStoreId($id = '')
	{
		// Compile the store id.
		$id	.= ':'.$this->getState('filter.search');
		$id	.= ':'.$this->getState('filter.published');
		$id	.= ':'.$this->getState('filter.language');

		return parent::getStoreId($id);
	}

	protected function getListQuery()
	{
		// Create a new query object.
		$db = $this->getDbo();
		$query = $db->getQuery(true);

		// Select the required fields from the table.
		$select_default='a.*, img.fullname AS item_image, img.caption AS image_caption, img.path as image_path, img.fullpath as image_fullpath, uc.name AS editor';
		
		$query->select($this->getState('list.select', $select_default));
		
		$query->from('#__djc2_producers AS a');
		
		// Join over the users for the checked out user.
		//$query->select('uc.name AS editor');
		$query->join('LEFT', '#__users AS uc ON uc.id=a.checked_out');
		
		//$query->select('img.fullname AS item_image, img.caption AS image_caption');
		//$query->join('LEFT', '#__djc2_images AS img ON img.item_id=a.id AND img.type=\'producer\' AND img.ordering=1');
		//$query->join('left', '(SELECT im1.* from #__djc2_images as im1 GROUP BY im1.item_id, im1.type ORDER BY im1.ordering asc) AS img ON img.item_id = a.id AND img.type=\'producer\'');
		//$query->join('left', '(select im1.fullname, im1.caption, im1.type, im1.item_id, im1.path, im1.fullpath from #__djc2_images as im1, (select item_id, type, min(ordering) as lowest_order from #__djc2_images group by item_id, type) as im2 where im1.item_id = im2.item_id and im1.type=im2.type and im1.ordering = im2.lowest_order group by im1.type, im1.item_id, im1.path, im1.fullpath) AS img ON img.item_id = a.id AND img.type=\'producer\'');
		$query->join('left', '#__djc2_images as img on img.id = (select id from #__djc2_images where type=\'producer\' and item_id = a.id order by ordering asc limit 1)');
		
		
		// Filter by published state
		$published = $this->getState('filter.published');
		if (is_numeric($published)) {
			$query->where('a.published = ' . (int) $published);
		}
		else if ($published === '') {
			$query->where('(a.published = 0 OR a.published = 1)');
		}
		
		// Filter by search in title.
		$search = $this->getState('filter.search');
		if (!empty($search)) {
			if (stripos($search, 'id:') === 0) {
				$query->where('a.id = '.(int) substr($search, 3));
			}
			else {
				$search = $db->quote('%'.$db->escape($search, true).'%');
				$query->where('(a.name LIKE '.$search.' OR a.alias LIKE '.$search.')');
			}
		}
		
		/*
		 * Multilang
		 */
		if (JLanguageAssociations::isEnabled())
		{
			/*$query->select('COUNT(asso2.id)>1 as association')
			 ->join('LEFT', '#__associations AS asso ON asso.id = a.id AND asso.context=' . $db->quote('com_djcatalog2.producercategory'))
			 ->join('LEFT', '#__associations AS asso2 ON asso2.key = asso.key')
			 ->group('a.id');*/
			
			$subQuery = $db->getQuery(true)
			->select('COUNT(' . $db->quoteName('asso1.id') . ') > 1')
			->from($db->quoteName('#__associations', 'asso1'))
			->join('INNER', $db->quoteName('#__associations', 'asso2') . ' ON ' . $db->quoteName('asso1.key') . ' = ' . $db->quoteName('asso2.key'))
			->where(
				array(
					$db->quoteName('asso1.id') . ' = ' . $db->quoteName('a.id'),
					$db->quoteName('asso1.context') . ' = ' . $db->quote('com_djcatalog2.producer'),
				)
				);
			$query->select('(' . $subQuery . ') AS ' . $db->quoteName('association'));
		}
		
		$query->select(array('l.title AS language_title', 'l.image AS language_image'));
		$query->join('LEFT', $db->quoteName('#__languages', 'l') . ' ON lang_code = a.language');
		
		// Filter by lang
		$app = JFactory::getApplication();
		$requestLang = $app->input->get('language');
		$lang = $this->getState('filter.language');
		if($requestLang) {
			$query->where('a.language = ' . $db->quote($requestLang));
		}elseif ($lang) {
			$query->where('a.language = ' . $db->quote($lang));
		}
		
		// Add the list ordering clause.
		$orderCol	= $this->state->get('list.ordering', 'a.name');
		$orderDirn	= $this->state->get('list.direction', 'asc');
	
		$query->order($db->escape($orderCol.' '.$orderDirn));

		return $query;
	}
	function recreateThumbnails($cid = array())
	{
		if (count( $cid ))
		{
			JArrayHelper::toInteger($cid);
			$cids = implode( ',', $cid );

			$query = 'SELECT fullname FROM #__djc2_images'
					. ' WHERE item_id IN ( '.$cids.' )'
					. ' AND type=\'producer\''
			;
			$this->_db->setQuery( $query );
			if (!$this->_db->query()) {
				$this->setError($this->_db->getErrorMsg());
				return false;
			}
			$items = $this->_db->loadObjectList();
			$params = &JComponentHelper::getParams( 'com_djcatalog2' );
				
			foreach($items as $item) {
				DJCatalog2ImageHelper::processImage(DJCATIMGFOLDER, $item->fullname, 'producer', $params);
			}
		}
		return true;
	}
	
}