<?php
/**
 * @package DJ-Catalog2
 * @copyright Copyright (C) DJ-Extensions.com, All rights reserved.
 * @license http://www.gnu.org/licenses GNU/GPL
 * @author url: http://dj-extensions.com
 * @author email contact@dj-extensions.com
 */

// No direct access.
defined('_JEXEC') or die;

//jimport('joomla.application.component.modeladmin');
require_once(JPATH_COMPONENT_ADMINISTRATOR.'/lib/modeladmin.php');

class Djcatalog2ModelProducerCategory extends DJCJModelAdmin
{
	protected $text_prefix = 'COM_DJCATALOG2';
	
	protected $associationsContext = 'com_djcatalog2.producercategory';

	public function __construct($config = array()) {
		//$config['event_after_save'] = 'onProducerCategoryAfterSave';
		//$config['event_after_delete'] = 'onProducerCategoryAfterDelete';
		parent::__construct($config);
	}

	public function getTable($type = 'ProducerCategories', $prefix = 'Djcatalog2Table', $config = array())
	{
		return JTable::getInstance($type, $prefix, $config);
	}
	public function getForm($data = array(), $loadData = true)
	{
		// Initialise variables.
		$app	= JFactory::getApplication();

		// Get the form.
		$form = $this->loadForm('com_djcatalog2.producercategory', 'producercategory', array('control' => 'jform', 'load_data' => $loadData));
		if (empty($form)) {
			return false;
		}

		return $form;
	}
	
	public function getItem($pk = null)
	{
		if ($item = parent::getItem($pk)) {
			/*
			 * Multilang
			 */
			if (JLanguageAssociations::isEnabled())
			{
				$item->associations = array();
				
				if ($item->id != null)
				{
					$associations = JLanguageAssociations::getAssociations('com_djcatalog2', '#__djc2_producer_categories', 'com_djcatalog2.producercategory', (int) $item->id, 'id', 'alias', '');
					
					foreach ($associations as $tag => $association)
					{
						$item->associations[$tag] = $association->id;
					}
				}
			}
			return $item;
		} else {
			return false;
		}
	}

	protected function loadFormData()
	{
		$data = JFactory::getApplication()->getUserState('com_djcatalog2.edit.producercategory.data', array());

		if (empty($data)) {
			$data = $this->getItem();
		}

		return $data;
	}
	
	/**
	 * Method to preprocess the form to add the association fields dynamically
	 *
	 * @return     none
	 */
	protected function preprocessForm(JForm $form, $data, $group = 'content')
	{
		// Association content items
		if (JLanguageAssociations::isEnabled())
		{
			$languages = JLanguageHelper::getContentLanguages(false, true, null, 'ordering', 'asc');
			
			if (count($languages) > 1)
			{
				$addform = new SimpleXMLElement('<form />');
				$fields = $addform->addChild('fields');
				$fields->addAttribute('name', 'associations');
				$fieldset = $fields->addChild('fieldset');
				$fieldset->addAttribute('name', 'item_associations');
				
				foreach ($languages as $language)
				{
					$field = $fieldset->addChild('field');
					$field->addAttribute('name', $language->lang_code);
					$field->addAttribute('type', 'djproducercategorymodal');
					$field->addAttribute('language', $language->lang_code);
					$field->addAttribute('label', $language->title);
					$field->addAttribute('translate_label', 'false');
				}
				
				$form->load($addform, false);
			}
		}
		parent::preprocessForm($form, $data, $group);
	}

	protected function _prepareTable(&$table)
	{
		jimport('joomla.filter.output');
		$date = JFactory::getDate();
		$user = JFactory::getUser();

		$table->name		= htmlspecialchars_decode($table->name, ENT_QUOTES);
		$table->alias		= JApplication::stringURLSafe($table->alias);

		if (empty($table->alias)) {
			$table->alias = JApplication::stringURLSafe($table->name);
		}

		if (empty($table->id)) {
			if (empty($table->ordering)) {
				$db = JFactory::getDbo();
				$db->setQuery('SELECT MAX(ordering) FROM #__djc2_producer_categories WHERE parent_id = '.$table->parent_id);
				$max = $db->loadResult();

				$table->ordering = $max+1;
			}
		}
	}

	protected function getReorderConditions($table)
	{
		$condition = array();
		$condition[] = 'parent_id = '.(int) $table->parent_id;
		return $condition;
	}

	public function delete(&$cid = array())
	{
		if (count( $cid ))
		{
			$categories = Djc2ProducerCategories::getInstance();
			$categoryList = $cid;
			foreach($cid as $catid){
				$sublist = array($catid);
				if ($parent = $categories->get($catid) ) {
					$parent->makeChildrenList($sublist);
				}
				$categoryList = array_merge($categoryList, $sublist);
			}
			$categoryList = array_unique($categoryList);
			$cids = implode(',', $categoryList);

			$this->_db->setQuery("SELECT COUNT(*) FROM #__djc2_producers WHERE cat_id IN ( ".$cids." )");
			if ($this->_db->loadResult() > 0) {
				$this->setError(JText::_('COM_DJCATALOG2_DELETE_CATEGORIES_HAVE_ITEMS'));
				return false;
			}

			$cid = $categoryList;
			return parent::delete($cid);
		}
		return false;
	}
	
	/**
	 * Method to test whether a record can be deleted.
	 *
	 * @param   object  $record  A record object.
	 *
	 * @return  boolean  True if allowed to delete the record. Defaults to the permission for the component.
	 *
	 * @since   1.6
	 */
	protected function canDelete($record)
	{
		return JFactory::getUser()->authorise('core.delete', $this->option) || JFactory::getUser()->authorise('djcatalog2.admin.catalogue', $this->option);
	}
	
	/**
	 * Method to test whether a record can have its state changed.
	 *
	 * @param   object  $record  A record object.
	 *
	 * @return  boolean  True if allowed to change the state of the record. Defaults to the permission for the component.
	 *
	 * @since   1.6
	 */
	protected function canEditState($record)
	{
		return JFactory::getUser()->authorise('core.edit.state', $this->option)  || JFactory::getUser()->authorise('djcatalog2.admin.catalogue', $this->option);
	}
}