<?php
/**
 * @package DJ-Catalog2
 * @copyright Copyright (C) DJ-Extensions.com, All rights reserved.
 * @license http://www.gnu.org/licenses GNU/GPL
 * @author url: http://dj-extensions.com
 * @author email contact@dj-extensions.com
 */
use Joomla\Registry\Registry;

// no direct access
defined('_JEXEC') or die;

jimport('joomla.application.component.modellist');

class Djcatalog2ModelPrices extends JModelList
{
	public function __construct($config = array())
	{
		if (empty($config['filter_fields'])) {
			$config['filter_fields'] = array(
				'id', 'a.id',
				'name', 'a.name',
				'alias', 'a.alias', 'a.sku', 'a.stock',
				'category_name',
				'producer_name',
				'ordering', 'a.ordering',
				'checked_out', 'a.checked_out',
				'checked_out_time', 'a.checked_out_time',
				'published', 'a.published',
				'a.featured',
				'access', 'a.access', 'access_level',
				'created', 'a.created',
				'created_by', 'a.created_by',
				'language', 'a.language', 'a.available'
			);
		}
		
		parent::__construct($config);
		
		if (JFactory::getApplication()->input->getCmd('layout') == 'combinations') {
			$this->context .= '.combinations';
		}
	}
	protected function populateState($ordering = null, $direction = null)
	{
		// List state information.
		parent::populateState('a.name', 'asc');
		
		// Initialise variables.
		$app = JFactory::getApplication();
		$session = JFactory::getSession();
		
		$search = $this->getUserStateFromRequest($this->context.'.filter.search', 'filter_search');
		$this->setState('filter.search', $search);
		
		$published = $this->getUserStateFromRequest($this->context.'.filter.published', 'filter_published', '');
		$this->setState('filter.published', $published);
		
		$category = $this->getUserStateFromRequest($this->context.'.filter.category', 'filter_category', '');
		$this->setState('filter.category', $category);
		
		$producer = $this->getUserStateFromRequest($this->context.'.filter.producer', 'filter_producer', '');
		$this->setState('filter.producer', $producer);
		
		$customergroup = $this->getUserStateFromRequest($this->context.'.filter.customergroup', 'filter_customergroup', '');
		$this->setState('filter.customergroup', $customergroup);
		
		$parent = ($app->input->get('layout', 'default') == 'combinations') ? $this->getUserStateFromRequest($this->context.'.filter.item', 'filter_item', 0) : 0;
		$this->setState('filter.item', $parent);
		
		// Load the parameters.
		$params = JComponentHelper::getParams('com_djcatalog2');
		$this->setState('params', $params);
	}
	
	protected function getStoreId($id = '')
	{
		// Compile the store id.
		$id .= ':'.$this->getState('filter.search');
		$id .= ':'.$this->getState('filter.published');
		$id .= ':'.$this->getState('filter.category');
		$id .= ':'.$this->getState('filter.producer');
		$id .= ':'.$this->getState('filter.customergroup');
		$id .= ':'.$this->getState('filter.ids');
		$id .= ':'.$this->getState('filter.item');
		
		return parent::getStoreId($id);
	}
	
	protected function getListQuery()
	{
		
		// Create a new query object.
		$db = $this->getDbo();
		$query = $db->getQuery(true);
		
		// Select the required fields from the table.
		
		$select_default = 'a.*, c.name AS category_name, c.id AS cat_id, p.name AS producer_name ';
		
		$query->select($this->getState('list.select', $select_default));
		$query->from('#__djc2_items AS a');
		
		// Join over the categories.
		//$query->select('c.name AS category_name, c.id AS cat_id');
		//$query->join('INNER', '#__djc2_items_categories AS ic ON a.id = ic.item_id AND ic.default=1');
		//$query->join('LEFT', '#__djc2_categories AS c ON c.id = ic.category_id');
		$query->join('LEFT', '#__djc2_categories AS c ON c.id = a.cat_id');
		
		// Join over the producers.
		//$query->select('p.name AS producer_name');
		$query->join('LEFT', '#__djc2_producers AS p ON p.id = a.producer_id');
		
		$query->select('t.value as tax_rate');
		$query->join('left', '#__djc2_vat_rules as t on a.tax_rule_id = t.id');
		
		$query->select('combo.combo_count');
		$query->join('left', '( SELECT item_id, COUNT(*) AS combo_count FROM #__djc2_items_combinations GROUP BY item_id) AS combo ON combo.item_id = a.id');
		
		// Join over the users for the checked out user.
		//$query->select('uc.name AS editor');
		//$query->join('LEFT', '#__users AS uc ON uc.id=a.checked_out');
		
		//$query->select('img.fullname AS item_image, img.caption AS image_caption');
		//$query->join('LEFT', '#__djc2_images AS img ON img.item_id=a.id AND img.type=\'item\' AND img.ordering=1');
		//$query->join('left', '(SELECT im1.* from #__djc2_images as im1 GROUP BY im1.item_id, im1.type ORDER BY im1.ordering asc) AS img ON img.item_id = a.id AND img.type=\'item\'');
		//$query->join('left', '(select im1.fullname, im1.caption, im1.type, im1.item_id, im1.path, im1.fullpath from #__djc2_images as im1, (select item_id, type, min(ordering) as lowest_order from #__djc2_images group by item_id, type) as im2 where im1.item_id = im2.item_id and im1.type=im2.type and im1.ordering = im2.lowest_order group by im1.type, im1.item_id, im1.path, im1.fullpath) AS img ON img.item_id = a.id AND img.type=\'item\'');
		
		
		// Filter by published state
		$published = $this->getState('filter.published');
		if (is_numeric($published)) {
			$query->where('a.published = ' . (int) $published);
		}
		else if ($published === '') {
			$query->where('(a.published = 0 OR a.published = 1)');
		}
		
		
		// Filter by search in title.
		$search = $this->getState('filter.search');
		if (!empty($search)) {
			if (stripos($search, 'id:') === 0) {
				$query->where('a.id = '.(int) substr($search, 3));
			}
			else {
				$search = $db->quote('%'.$db->escape($search, true).'%');
				$query->where('(a.name LIKE '.$search.' OR a.alias LIKE '.$search.' OR a.sku LIKE '.$search.')');
			}
		}
		
		// Filter by category state
		$category = $this->getState('filter.category');
		if (is_numeric($category) && $category != 0) {
			//$query->where('a.cat_id = ' . (int) $category);
			$categories = Djc2Categories::getInstance();
			if ($parent = $categories->get((int)$category) ) {
				$childrenList = array($parent->id);
				$parent->makeChildrenList($childrenList);
				if ($childrenList) {
					$cids = implode(',', $childrenList);
					$db->setQuery('SELECT item_id
										   FROM #__djc2_items_categories AS ic
										   INNER JOIN #__djc2_categories AS c ON c.id=ic.category_id
										   WHERE category_id IN ('.$cids.')');
					$items = $db->loadColumn();
					if (count ($items)) {
						$items = array_unique($items);
						$query->where('a.id IN ('.implode(',',$items).')');
					} else {
						$query->where('1=0');
					}
					//$where[] = 'i.cat_id IN ( '.$cids.' )';
				}
				else if ($category != 0){
					$query->where('1=0');
				}
			}
		}
		
		// Filter by producer state
		$producer = $this->getState('filter.producer');
		if (is_numeric($producer) && $producer != 0) {
			$query->where('a.producer_id = ' . (int) $producer);
		}
		
		// Filter by primary keys
		$item_ids = $this->getState('filter.ids');
		if ($item_ids != '') {
			$query->where('a.id IN ('.$item_ids.')');
		}
		
		$customer_group = $this->getState('filter.customergroup');
		if (is_numeric($customer_group) && (int)$customer_group != 0) {
			$query->select('cg.price as group_price, cg.available as group_available');
			$query->join('left', '#__djc2_prices as cg on cg.group_id ='.(int)$customer_group.' AND cg.item_id=a.id');
		}
		
		
		// Add the list ordering clause.
		$orderCol   = $this->state->get('list.ordering', 'a.name');
		$orderDirn  = $this->state->get('list.direction', 'asc');
		if ($orderCol == 'a.ordering' || $orderCol == 'category_name') {
			$orderCol = 'c.name '.$orderDirn.', a.ordering';
		}
		
		$query->order($db->escape($orderCol.' '.$orderDirn));
		return $query;
	}
	
	protected function _getListCount($query)
	{
		// Use fast COUNT(*) on JDatabaseQuery objects if there no GROUP BY or HAVING clause:
		if ($query instanceof JDatabaseQuery
			&& $query->type == 'select'
			&& $query->group === null
			&& $query->having === null)
		{
			
			$query = clone $query;
			$query->clear('select')->clear('order')->select('COUNT(*)');
			$this->_db->setQuery($query);
			return (int) $this->_db->loadResult();
		}
		
		// Otherwise fall back to inefficient way of counting all results.
		$this->_db->setQuery($query);
		$this->_db->execute();
		
		return (int) $this->_db->getNumRows();
	}
	
	public function getCategories(){
		if(empty($this->_categories)) {
			$query = "SELECT * FROM #__djc2_categories ORDER BY name";
			$this->_categories = $this->_getList($query,0,0);
		}
		return $this->_categories;
	}
	
	public function getProducers(){
		if(empty($this->_producers)) {
			$query = "SELECT * FROM #__djc2_producers ORDER BY name";
			$this->_producers = $this->_getList($query,0,0);
		}
		return $this->_producers;
	}
	
	public function getUnits($type) {
		$db = JFactory::getDbo();
		$query = $db->getQuery(true);
		$query->select('id AS value, CONCAT(name, " [", unit, "]") as text');
		$query->from('#__djc2_units');
		if ($type) {
			if (strpos($type, ',')) {
				$types = explode(',',$type);
				$whereTypes = array();
				foreach($types as $unittype) {
					$whereTypes[] = 'unit_type='.$db->quote(trim($unittype));
				}
				$query->where('('.implode(' OR ', $whereTypes).')');
			} else {
				$query->where('unit_type='.$db->quote(trim($type)));
			}
		}
		$query->order('is_default DESC, ordering ASC');
		$db->setQuery($query);
		$units = $db->loadObjectList();
		return $units;
	}
	
	public function getCombinations()
	{
		// Get a storage key.
		$store = $this->getStoreId();
		
		// Try to load the data from internal storage.
		if (isset($this->cache[$store]))
		{
			return $this->cache[$store];
		}
		
		try
		{
			// Load the list items and add the items to the internal cache.
			$this->cache[$store] = $this->_getList($this->_getCombinationsListQuery(), $this->getStart(), $this->getState('list.limit'));
		}
		catch (RuntimeException $e)
		{
			$this->setError($e->getMessage());
			
			return false;
		}
		
		$parent = $this->getState('filter.item');
		if ($parent && count($this->cache[$store])) {
			$db = JFactory::getDbo();
			$query = $db->getQuery(true);
			$query->select('cf.*, f.name as field_name, fo.value as field_value, fo.params');
			$query->from('#__djc2_items_combinations_fields AS cf');
			$query->join('inner', '#__djc2_items_combinations AS c ON c.id=cf.combination_id');
			$query->join('left', '#__djc2_items_extra_fields as f ON f.id = cf.field_id');
			$query->join('left', '#__djc2_items_extra_fields_options as fo ON fo.id = cf.value AND fo.field_id = cf.field_id AND fo.field_id = f.id');
			$query->order('f.ordering, fo.ordering ASC');
			$query->where('c.item_id='.(int)$parent);
			$db->setQuery($query);
			
			$fields = $db->loadObjectList();
			
			foreach($this->cache[$store] as &$combination) {
				$combination->fields = array();
				foreach($fields as $field) {
					if ($field->combination_id != $combination->id) continue;
					$field->option_params = new Registry($field->params);
					$combination->fields[$field->field_id] = $field;
				}
			}
			unset($combination);
		}
		
		return $this->cache[$store];
	}
	
	protected function _getCombinationsListQuery()
	{
		
		// Create a new query object.
		$db = $this->getDbo();
		$query = $db->getQuery(true);
		
		// Select the required fields from the table.
		
		$select_default = 'combo.*, a.name, a.alias';
		
		$query->select($this->getState('list.select', $select_default));
		
		$query->from('#__djc2_items_combinations as combo');
		
		$query->join('inner', '#__djc2_items AS a ON a.id = combo.item_id');
		
		$query->select('t.value as tax_rate');
		$query->join('left', '#__djc2_vat_rules as t on a.tax_rule_id = t.id');
		
		$customer_group = $this->getState('filter.customergroup');
		if (is_numeric($customer_group) && (int)$customer_group != 0) {
			$query->select('cg.price as group_price');
			$query->join('left', '#__djc2_combination_prices as cg on cg.group_id ='.(int)$customer_group.' AND cg.combination_id=combo.id');
		}
		
		$query->where('combo.item_id='.(int)$this->getState('filter.item', 0));
		
		// Add the list ordering clause.
		$orderCol   = $this->state->get('list.ordering', 'a.name');
		$orderDirn  = $this->state->get('list.direction', 'asc');
		if ($orderCol == 'a.ordering' || $orderCol == 'category_name') {
			$orderCol = 'c.name '.$orderDirn.', a.ordering';
		}
		
		$query->order($db->escape($orderCol.' '.$orderDirn));
		return $query;
	}
	
	public function getTotal()
	{
		// Get a storage key.
		$store = $this->getStoreId('getTotal');
		
		// Try to load the data from internal storage.
		if (isset($this->cache[$store]))
		{
			return $this->cache[$store];
		}
		
		try
		{
			// Load the total and add the total to the internal cache.
			if ((int)$this->state->get('filter.item') > 0) {
				$this->cache[$store] = (int) $this->_getListCount($this->_getCombinationsListQuery());
			} else {
				$this->cache[$store] = (int) $this->_getListCount($this->_getListQuery());
			}
		}
		catch (RuntimeException $e)
		{
			$this->setError($e->getMessage());
			
			return false;
		}
		
		return $this->cache[$store];
	}
	
}