<?php
/**
 * @package DJ-Catalog2
 * @copyright Copyright (C) DJ-Extensions.com, All rights reserved.
 * @license http://www.gnu.org/licenses GNU/GPL
 * @author url: http://dj-extensions.com
 * @author email contact@dj-extensions.com
 */

use Joomla\Registry\Registry;

// No direct access.
defined('_JEXEC') or die;

//jimport('joomla.application.component.modeladmin');
require_once(JPATH_ROOT.'/administrator/components/com_djcatalog2/lib/modeladmin.php');

class Djcatalog2ModelOrder extends DJCJModelAdmin
{
	protected $text_prefix = 'COM_DJCATALOG2';
	public $invoiceStatuses = array('C', 'P', 'F');
	
	
	public function __construct($config = array()) {
		parent::__construct($config);
	}
	
	public function getTable($type = 'Orders', $prefix = 'Djcatalog2Table', $config = array())
	{
		return JTable::getInstance($type, $prefix, $config);
	}
	public function getForm($data = array(), $loadData = true)
	{
		// Initialise variables.
		$app	= JFactory::getApplication();
		
		// Get the form.
		$form = $this->loadForm('com_djcatalog2.order', 'order', array('control' => 'jform', 'load_data' => $loadData));
		if (empty($form)) {
			return false;
		}
		
		return $form;
	}
	
	public function getItem($pk = null)
	{
		$pk = (!empty($pk)) ? $pk : (int) $this->getState($this->getName() . '.id');
		$table = $this->getTable();
		
		if ($pk > 0)
		{
			// Attempt to load the row.
			$return = $table->load($pk);
			
			// Check for a table object error.
			if ($return === false && $table->getError())
			{
				$this->setError($table->getError());
				return false;
			}
		}
		
		// Convert to the JObject before adding other data.
		$properties = $table->getProperties(1);
		
		$item = JArrayHelper::toObject($properties, 'JObject');
		
		if (!is_array($item->items)) {
			if (isset($item->id)) {
				$this->_db->setQuery('SELECT * FROM #__djc2_order_items WHERE order_id=\''.$item->id.'\'');
				$item->items = $this->_db->loadObjectList();
			} else {
				$item->items = array();
			}
		}
		
		if (property_exists($item, 'params'))
		{
			$registry = new Registry;
			$registry->loadString($item->params);
			$item->params = $registry->toArray();
		}
		
		if (property_exists($item, 'recurring_params'))
		{
			$registry = new Registry;
			$registry->loadString($item->recurring_params);
			$item->recurring_params = $registry->toArray();
		}
		
		if (property_exists($item, 'delivery_params'))
		{
			$registry = new Registry;
			$registry->loadString($item->delivery_params);
			$item->delivery_params = $registry->toArray();
		}
		
		if (property_exists($item, 'payment_params'))
		{
			$registry = new Registry;
			$registry->loadString($item->payment_params);
			$item->payment_params = $registry->toArray();
		}
		
		if (property_exists($item, 'additional_user_data') && trim($item->additional_user_data) != '')
		{
			$registry = new Registry;
			$registry->loadString($item->additional_user_data);
			$registry = $registry->toArray();
			$item->additional_user_data = $registry;

			foreach($registry as $set => $values ) {
				foreach($values as $field) {
					$alias = $field['alias'];
					$item->$alias = $field['value_text'];
				}
			}
		}
		
		return $item;
	}
	
	
	protected function loadFormData()
	{
		$data = JFactory::getApplication()->getUserState('com_djcatalog2.edit.order.data', array());
		
		if (empty($data)) {
			$data = $this->getItem();
		}
		
		$dispatcher = JEventDispatcher::getInstance();
		
		JPluginHelper::importPlugin('content');
		JPluginHelper::importPlugin('djcatalog2delivery');
		JPluginHelper::importPlugin('djcatalog2payment');
		
		// Trigger the data preparation event.
		$results = $dispatcher->trigger('onContentPrepareData', array('com_djcatalog2.order', &$data));
		
		return $data;
	}
	
	protected function preprocessForm(JForm $form, $data, $group = 'content')
	{
		Djcatalog2HelperUser::preprocessOrderForm($form, $data);
		JPluginHelper::importPlugin($group);
		JPluginHelper::importPlugin('djcatalog2delivery');
		JPluginHelper::importPlugin('djcatalog2payment');
	}
	
	protected function _prepareTable(&$table)
	{
		$db = JFactory::getDbo();
		
		if (empty($table->order_number)) {
			$db->setQuery('select max(order_number) from #__djc2_orders');
			$current = (int)$db->loadResult();
			$table->order_number = $current + 1;
		}
	}
	
	protected function getReorderConditions($table = null)
	{
		$condition = array();
		return $condition;
	}
	
	public function delete(&$cid) {
		if (parent::delete($cid)) {
			
			$cids = implode(',', $cid);
			
			$this->_db->setQuery("delete from #__djc2_order_items WHERE order_id IN ( ".$cids." )");
			if (!$this->_db->query()) {
				$this->setError($this->_db->getErrorMsg());
				return false;
			}
			return true;
		}
		return false;
	}
	
	public function save($data) {
		$params = JComponentHelper::getParams('com_djcatalog2');
		
		$new_status = $data['status'];
		$old_status = false;
		
		$userFields = Djcatalog2HelperUser::getUserFields('checkout');
		
		$additionalData = array();
		foreach($userFields as $field) {
			if ($field->is_core) continue;
			if (!isset($additionalData[$field->target_fieldset])) {
				$additionalData[$field->target_fieldset] = array();
			}
			if (isset($data[$field->alias])) {
				$additionalData[$field->target_fieldset][$field->id] = array('field' => $field->name, 'alias' => $field->alias, 'value' => '', 'value_text' => $data[$field->alias]);
			}
		}
		$data['additional_user_data'] = json_encode($additionalData);

		if ((int)$data['id'] > 0) {
			$table = $this->getTable();
			$table->load((int)$data['id']);
			$old_status = $table->status;
		}
		
		if (!parent::save($data)) {
			return false;
		}
		
		$id = $this->getState($this->getName() . '.id');
		$table = $this->getTable();
		$db = JFactory::getDbo();
		
		$loaded = $table->load((int)$id);
		
		$attachments = array();

		if ($loaded && empty($table->proforma_number) && $params->get('cart_proformas')) {
			
			require_once JPATH_ROOT.'/components/com_djcatalog2/helpers/invoice.php';
			$invoiceCounter = 0;
			$date = JFactory::getDate();
			
			$invoiceNumber = DJCatalog2HelperInvoice::getNext($invoiceCounter, $date, 'proforma');
			
			$query = $db->getQuery(true);
			$query->update('#__djc2_orders');
			$query->set('proforma_counter='.$invoiceCounter);
			$query->set('proforma_number='.$db->quote($invoiceNumber));
			$query->where('id='.(int)$table->id);
			$db->setQuery($query);
			
			if (!$db->execute()) {
				$this->setError($db->getErrorMsg());
				return false;
			}
			
			$table->proforma_counter = $invoiceCounter;
			$table->proforma_number = $invoiceNumber;
			
			DJCatalog2HelperInvoice::update($invoiceCounter, $date, 'proforma');
		}
		
		$invoiceStatuses = (array)$params->get('cart_status_invoice', $this->invoiceStatuses);
		
		if ($loaded && $table->status != $old_status && !empty($table->email)) {
			
			if (in_array($table->status, $invoiceStatuses) && empty($table->invoice_number)) {
				$date = JFactory::getDate();
				
				$paymentDate = (empty($table->payment_date) || $table->payment_date == '0000-00-00 00:00:00') ? $date->toSql(true) : $table->payment_date;
				$serviceDate = (empty($table->service_date) || $table->service_date == '0000-00-00 00:00:00') ? $date->toSql(true) : $table->service_date;
				
				$query = $db->getQuery(true);
				$query->update('#__djc2_orders');
				
				$newInvoice = false;
				if ($params->get('cart_invoices') && $table->want_invoice) {
					$invoiceDate = (empty($table->invoice_date) || $table->invoice_date == '0000-00-00 00:00:00') ? $date->toSql(true) : $table->invoice_date;
					
					//$invoiceNumber = $this->getNextInvoiceNumber($date);
					require_once JPATH_ROOT.'/components/com_djcatalog2/helpers/invoice.php';
					$invoiceCounter = 0;
					$invoiceNumber = DJCatalog2HelperInvoice::getNext($invoiceCounter, $date, 'invoice');
					
					$query->set('invoice_counter='.$invoiceCounter);
					$query->set('invoice_number='.$db->quote($invoiceNumber));
					$query->set('invoice_date='.$db->quote($invoiceDate));
					
					$newInvoice = true;
				}
				
				$query->set('payment_date='.$db->quote($paymentDate));
				$query->set('service_date='.$db->quote($serviceDate));
				$query->where('id='.(int)$table->id);
				$db->setQuery($query);
				
				
				if (!$db->execute()) {
					$this->setError($db->getErrorMsg());
					return false;
				}
				
				if ($newInvoice) {
					DJCatalog2HelperInvoice::update($invoiceCounter, $date, 'invoice');
					
					$table->invoice_counter = $invoiceCounter;
					$table->invoice_number = $invoiceNumber;
					$table->invoice_date = $invoiceDate;
					
					if ($params->get('cart_invoices_email', 0) && $table->want_invoice) {
						$pdf = DJCatalog2HelperInvoice::getPdfInvoice($table->id, 'invoice', false);
						if ($pdf) {
							$attachments[] = $pdf;
						}
					}
				}
				
				$table->payment_date = $paymentDate;
				$table->service_date = $serviceDate;
				
				// add subscriptions related to products
				$sub = new DJCatalog2Subscription();
				if(!$sub->setSubscriptions($table)) {
					$this->setError($sub->getError());
					return false;
				} else {
					//$notify = false;
				}
			}
			
			$data = $table->getProperties();
			foreach ($data['items'] as $k=>$v) {
				$data['items'][$k] = JArrayHelper::fromObject($v);
			}
			
			// update stock information if necessary
			$updStock = 0;
			if ( ($table->status == 'W' || $table->status =='R')  && ($old_status != 'W' && $old_status != 'R') ) {
				$updStock = 1;
			} else if (($table->status != 'W' && $table->status != 'R') && ($old_status == 'W' || $old_status == 'R')) {
				$updStock = -1;
			}
			
			if ($updStock != 0) {
				foreach($data['items'] as $item) {
					if ($item['item_type'] != 'item' || $item['item_id'] == 0) continue;
					
					$quantity = $item['quantity'];
					if (!($quantity > 0.0000)) continue;
					
					$operation = ($updStock > 0) ? '+ '.(float)$quantity : '- ' .(float)$quantity;
					
					if ($item['combination_id'] == 0) {
						$db->setQuery('UPDATE #__djc2_items SET stock = stock '.$operation.' WHERE id='.(int)$item['item_id']);
						$db->execute();
					} else {
						$db->setQuery('UPDATE #__djc2_items_combinations SET stock = stock '.$operation.' WHERE id='.(int)$item['combination_id']);
						$db->execute();
					}
				}
			}
			
			$dispatcher = JEventDispatcher::getInstance();
			$dispatcher->trigger('onDJC2AfterOrderStatusChange', array($data));
			
			return $this->_sendEmail($data, $attachments);
		}
		
		return true;
	}
	public function set_status($id, $value, $notify = true) {
		$params = JComponentHelper::getParams('com_djcatalog2');
		$date = JFactory::getDate();
		$db = JFactory::getDbo();
		$user = JFactory::getUser();
		
		$attachments = array();
		
		$table = $this->getTable('Orders');
		
		if ($table->load((int)$id)) {
			$oldStatus = $table->status;
			$table->status = $value;
			
			$invoiceStatuses = (array)$params->get('cart_status_invoice', $this->invoiceStatuses);
			
			$query = $db->getQuery(true);
			$query->update('#__djc2_orders');
			$query->set('status='.$db->quote($value));
			$query->set('modified='.$db->quote($date->toSql()));
			$query->set('modified_by='.$user->id);
			
			if (in_array($table->status, $invoiceStatuses) && empty($table->invoice_number)) {
				
				$paymentDate = (empty($table->payment_date) || $table->payment_date == '0000-00-00 00:00:00') ? $date->toSql(true) : $table->payment_date;
				$serviceDate = (empty($table->service_date) || $table->service_date == '0000-00-00 00:00:00') ? $date->toSql(true) : $table->service_date;
				
				$invoiceCounter = 0;
				$invoiceNumber = null;
				
				$newInvoice = false;
				if ($params->get('cart_invoices') && $table->want_invoice) {
					$invoiceDate = (empty($table->invoice_date) || $table->invoice_date == '0000-00-00 00:00:00') ? $date->toSql(true) : $table->invoice_date;
					
					require_once JPATH_ROOT.'/components/com_djcatalog2/helpers/invoice.php';
					
					$invoiceCounter = 0;
					$invoiceNumber = DJCatalog2HelperInvoice::getNext($invoiceCounter, $date, 'invoice');
					
					$query->set('invoice_counter='.$invoiceCounter);
					$query->set('invoice_number='.$db->quote($invoiceNumber));
					$query->set('invoice_date='.$db->quote($invoiceDate));
					
					$newInvoice = true;
				}
				
				$query->set('payment_date='.$db->quote($paymentDate));
				$query->set('service_date='.$db->quote($serviceDate));
				$query->where('id='.(int)$table->id);
				$db->setQuery($query);
				
				if (!$db->execute()) {
					$this->setError($db->getErrorMsg());
					return false;
				}
				
				if ($newInvoice) {
					DJCatalog2HelperInvoice::update($invoiceCounter, $date, 'invoice');
					
					$table->invoice_counter = $invoiceCounter;
					$table->invoice_number = $invoiceNumber;
					$table->invoice_date = $invoiceDate;
					
					if ($params->get('cart_invoices_email', 0) && $table->want_invoice) {
						$pdf = DJCatalog2HelperInvoice::getPdfInvoice($table->id, 'invoice', false);
						if ($pdf) {
							$attachments[] = $pdf;
						}
					}
				}
				
				$table->payment_date = $paymentDate;
				$table->service_date = $serviceDate;
				
				// add subscriptions related to products
				$sub = new DJCatalog2Subscription();
				if(!$sub->setSubscriptions($table)) {
					$this->setError($sub->getError());
					return false;
				} else {
					//$notify = false;
				}
			} else {
				$query->where('id='.(int)$table->id);
				$db->setQuery($query);
				
				if (!$db->execute()) {
					$this->setError($db->getErrorMsg());
					return false;
				}
			}
			
			$data = $table->getProperties();
			foreach ($data['items'] as $k=>$v) {
				$data['items'][$k] = JArrayHelper::fromObject($v);
			}
			
			// update stock information if necessary
			$updStock = 0;
			if ( ($value == 'W' || $value =='R')  && ($oldStatus != 'W' && $oldStatus != 'R') ) {
				$updStock = 1;
			} else if (($value != 'W' && $value != 'R') && ($oldStatus == 'W' || $oldStatus == 'R')) {
				$updStock = -1;
			}
			
			if ($updStock != 0) {
				foreach($data['items'] as $item) {
					if ($item['item_type'] != 'item' || $item['item_id'] == 0) continue;
					
					$quantity = $item['quantity'];
					if (!($quantity > 0.0000)) continue;
					
					$operation = ($updStock > 0) ? '+ '.(float)$quantity : '- ' .(float)$quantity;
					
					if ($item['combination_id'] == 0) {
						$db->setQuery('UPDATE #__djc2_items SET stock = stock '.$operation.' WHERE id='.(int)$item['item_id']);
						$db->execute();
					} else {
						$db->setQuery('UPDATE #__djc2_items_combinations SET stock = stock '.$operation.' WHERE id='.(int)$item['combination_id']);
						$db->execute();
					}
				}
			}
			
			$dispatcher = JEventDispatcher::getInstance();
			$dispatcher->trigger('onDJC2AfterOrderStatusChange', array($data));

			if ($notify) {
				return $this->_sendEmail($data, $attachments);
			}
		}
		
		return true;
	}
	
	private function _sendEmail($order, $attachments = array())
	{
		
		$app = JFactory::getApplication();
		
		require_once JPATH_ROOT.'/components/com_djcatalog2/helpers/html.php';
		require_once JPATH_ROOT.'/components/com_djcatalog2/helpers/djcatalog2.php';
		require_once (JPATH_ROOT.'/administrator/components/com_djcatalog2/helpers/messenger.php');
		require_once JPATH_ROOT.'/components/com_djcatalog2/helpers/price.php';
		
		Djcatalog2Helper::loadComponentLanguage();
		
		$params 	= JComponentHelper::getParams('com_djcatalog2');
		$config 	= JFactory::getConfig();
		
		$customerName = $order['firstname'].' '.$order['lastname'];
		if (!empty($order['company'])) {
			$customerName = $order['company'];
		}
		
		$statusObj = DJCatalog2HtmlHelper::getOrderStatus($order['status']);
		$msg_type = (!empty($statusObj) && !empty($statusObj->message_template)) ? $statusObj->message_template : 'order_status';
		
		$status = DJCatalog2HtmlHelper::getOrderStatusName($order['status']);
		$status_desc = DJCatalog2HtmlHelper::getOrderStatusInfo($order['status']);
		$orderLink = null;
		if ($app->isSite()) {
			$orderLink = JRoute::_(DJCatalogHelperRoute::getOrderRoute($order['id']).'&token='.$order['token'], true, -1);
		} else {
			require_once JPATH_ROOT.'/administrator/components/com_djcatalog2/helpers/route.php';
			$orderLink = DJCatalog2HelperSiteRoute::buildRoute('getOrderRoute', array($order['id']), '&token='.$order['token'], true);
		}
		
		if (strstr($order['email'], '@example.com') === false) {
			$mailopts = [
				'recipient_name' => $customerName,
				'order_number' => $order['order_number'],
				'order_status' => $status,
				'order_status_description' => $status_desc,
				'order_customer_data' => DJCatalog2HtmlHelper::getThemeLayout($order, 'order_customer', 'email/layouts'),
				'order_items' => DJCatalog2HtmlHelper::getThemeLayout($order, 'order_items', 'email/layouts'),
				'order_link' =>  $orderLink
			];

			$messenger = new DJCatalog2HelperMessenger();
			$messenger->notify($order['email'], ['type' => $msg_type], $attachments, $mailopts );
		}
		
		return true;
	}
	
	/*public function getNextInvoiceNumber($date = false) {
	 $db = JFactory::getDbo();
	 
	 if (!$date) {
	 $date = JFactory::getDate();
	 }
	 
	 $db->setQuery('select count(*) from #__djc2_orders where invoice_date > 0 AND (invoice_number IS NOT NULL or invoice_number != "") and year(invoice_date) = '.$db->quote($date->format('Y')));
	 
	 $count = $db->loadResult();
	 $count++;
	 
	 $number = str_pad($count, 6, '0', STR_PAD_LEFT).'/'.$date->format("Y");
	 
	 return $number;
	 }*/
	
	/**
	 * Method to test whether a record can be deleted.
	 *
	 * @param   object  $record  A record object.
	 *
	 * @return  boolean  True if allowed to delete the record. Defaults to the permission for the component.
	 *
	 * @since   1.6
	 */
	protected function canDelete($record)
	{
		return JFactory::getUser()->authorise('core.delete', $this->option) || JFactory::getUser()->authorise('djcatalog2.admin.orders', $this->option);
	}
	
	/**
	 * Method to test whether a record can have its state changed.
	 *
	 * @param   object  $record  A record object.
	 *
	 * @return  boolean  True if allowed to change the state of the record. Defaults to the permission for the component.
	 *
	 * @since   1.6
	 */
	protected function canEditState($record)
	{
		return JFactory::getUser()->authorise('core.edit.state', $this->option)  || JFactory::getUser()->authorise('djcatalog2.admin.orders', $this->option);
	}

	public function getDeliveryMethod($id) {
		if(!isset($this->deliveryMethods[$id])) {
			$deliveryObject = false;
			$db = JFactory::getDbo();
			if ($id != 0) {
				$db->setQuery('select * from #__djc2_delivery_methods where id='.(int)$id);
				if ($deliveryObject = $db->loadObject()) {
					$params = new JRegistry();

					$deliveryObject->params = $params->loadString($deliveryObject->params);
				}
			}

			$this->deliveryMethods[$id] = $deliveryObject;
		}
		return $this->deliveryMethods[$id];

	}
}