<?php
/**
 * @package DJ-Catalog2
 * @copyright Copyright (C) DJ-Extensions.com, All rights reserved.
 * @license http://www.gnu.org/licenses GNU/GPL
 * @author url: http://dj-extensions.com
 * @author email contact@dj-extensions.com
 */

defined('_JEXEC') or die();
defined('JPATH_BASE') or die;

jimport('joomla.html.html');
jimport('joomla.form.formfield');

require_once JPATH_ROOT.'/components/com_djcatalog2/helpers/price.php';
require_once JPATH_ROOT.'/components/com_djcatalog2/helpers/html.php';

class JFormFieldDjcpayment extends JFormField {
	
	protected $type = 'Djcpayment';
	
	protected function getInput()
	{
		$html = array();

		// Initialize some field attributes.
		$class     = !empty($this->class) ? ' class="radio ' . $this->class . '"' : ' class="radio"';
		$required  = $this->required ? ' required aria-required="true"' : '';
		$autofocus = $this->autofocus ? ' autofocus' : '';
		$disabled  = $this->disabled ? ' disabled' : '';
		$readonly  = $this->readonly;
		
		$params = JComponentHelper::getParams('com_djcatalog2');
		$basket = Djcatalog2HelperCart::getInstance(true);
		$total = $basket->getProductTotal();
		
		$tax_already_incl = (bool)($params->get('price_including_tax', 1) == 1);
		
		//TODO - parameter
		$displayPrices = true;
		
		$noShipment = (bool)(isset($this->element['no_shipment']) && $this->element['no_shipment']);

		// Start the radio field output.
		$html[] = '<fieldset id="' . $this->id . '"' . $class . $required . $autofocus . $disabled . ' >';

		// Get the field options.
		$options = $this->getOptions();
		
		$db = JFactory::getDbo();
		$query = $db->getQuery(true);
		$query->select('*')->from('#__djc2_deliveries_payments')->order('payment_id');
		$db->setQuery($query);
		$deliveriesXref = $db->loadObjectList();
		
		// Build the radio field output.
		foreach ($options as $i => $option)
		{
			$xtra = array();
			foreach ($deliveriesXref as $xref) {
				if ($xref->payment_id == $option->value) {
					$xtra[] = $xref->delivery_id;
				}
			}
				
			if ($noShipment && count($xtra)) {
				unset($options[$i]);
				continue;
			} 
			
			$options[$i]->_xtra = $xtra;
		}
		
		$options = array_values($options);
		
		foreach ($options as $i => $option)
		{
			// Initialize some option attributes.
			$checked = ((string) $option->value == (string) $this->value || count($options) == 1) ? ' checked="checked"' : '';
			$class = !empty($option->class) ? ' class="' . $option->class . '"' : '';

			$disabled = !empty($option->disable) || ($readonly && !$checked);

			$disabled = $disabled ? ' disabled' : '';

			// Initialize some JavaScript option attributes.
			$onclick = !empty($option->onclick) ? ' onclick="' . $option->onclick . '"' : '';
			$onchange = !empty($option->onchange) ? ' onchange="' . $option->onchange . '"' : '';
			
			/*$lblText = $option->text;
			if ($displayPrices && $option->price > 0.0) {
				$price = ($option->free_amount > 0 && $option->free_amount <= $total['gross']) ? 0.0 : $option->price;
				$prices = Djcatalog2HelperPrice::getCartPrices($price, $price, $option->tax_rule_id, false,  1, $params);
				$priceText = strip_tags(DJCatalog2HtmlHelper::formatPrice($prices['base']['display'], $params));
				$lblText .= ' ('.$priceText.')';
			}*/
			
			$html[] = '<label for="' . $this->id . $i . '"' . $class . ' >';
			
			$html[] = '<input type="radio" id="' . $this->id . $i . '" name="' . $this->name . '" value="'
				. htmlspecialchars($option->value, ENT_COMPAT, 'UTF-8') . '"' . $checked . $class . $required . $onclick
				. $onchange . $disabled . ' data-delivery="'.implode(',', $option->_xtra).'" '.$option->attributes.' />';
			
			$html[] = '<span class="djc_payment_option">';
			
			if (trim($option->image) != '') {
				$html[] = '<img class="djc_payment_option-image" src="' . ($option->image) .'" alt="'.htmlspecialchars($option->text).'" />';
			}
			
			$html[] = '<span class="djc_payment_option-title">'
				. JText::alt($option->text, preg_replace('/[^a-zA-Z0-9_\-]/', '_', $this->fieldname))
				.'</span>';
			
			if (trim($option->short_description) != '') {
				$html[] = '<span class="djc_payment_option-description">' . nl2br($option->short_description) .'</span>';
			}
			
			if ($displayPrices && ($option->price > 0.0 || $option->additional_fee > 0)) {
				
				$fee = 0;
				if ($option->additional_fee > 0) {
					if ($tax_already_incl) {
						$fee = round(($option->additional_fee * $total ['gross'])/100,2);
					} else {
						$fee = round(($option->additional_fee * $total ['net'])/100,2);
					}
				}
				
				$price = ($option->free_amount > 0 && $option->free_amount <= $total['gross']) ? 0.0 : $option->price + $fee;
				$prices = Djcatalog2HelperPrice::getCartPrices($price, $price, $option->tax_rule_id, false,  1, $params);
				$priceText = strip_tags(DJCatalog2HtmlHelper::formatPrice($prices['base']['display'], $params));
				$html[] = '<span class="djc_payment_option-price">'.$priceText.'</span>';
			}
			
			$html[] = '</span>';
			$html[] = '</label>';
		}

		// End the radio field output.
		$html[] = '</fieldset>';
		
		return implode($html);
	}
	
	protected function getOptions()
	{
		$app = JFactory::getApplication();
		$user = JFactory::getUser();
		
		$options = array();
		
		$basket = Djcatalog2HelperCart::getInstance(true);
		
		$db = JFactory::getDbo();
		$query = $db->getQuery(true);
		$query->select('p.*')->from('#__djc2_payment_methods AS p');
		if (!$app->isAdmin() && !$user->authorise('djcatalog2.salesman', 'com_djcatalog2')) {
			$user = JFactory::getUser();
			$userGroups = implode(',', $user->getAuthorisedViewLevels());
			
			$query->where('p.published=1');
			$query->where('p.access IN ('.$userGroups.')');
			
		}
		if ($basket->productTypes['tangible']  == 0) {
			$query->join('left', '#__djc2_deliveries_payments AS dp ON dp.payment_id = p.id');
			$query->where('dp.payment_id is null');
		}
		$query->order('p.ordering asc');
		
		$db->setQuery($query);
		$rows = $db->loadObjectList('id');
		
		$optOptions = array(
			'attr' => null,
			'disable' => false,
			'option.attr' => null,
			'option.disable' => 'disable',
			'option.key' => 'value',
			'option.label' => null,
			'option.text' => 'text'
		);
		
		$basket_currency = false;
		if ($app->isAdmin() == false) {
			$basket_currency = $basket->getCurrencyID();
			if ($basket_currency) {
				$query = $db->getQuery(true);
				$query->select('*')->from('#__djc2_payments_currencies');
				$db->setQuery($query);
				$paymentCurrencies = $db->loadObjectList();
				
				foreach($paymentCurrencies as $currency) {
					if (!isset($rows[$currency->payment_id])) continue;
					if (!isset($rows[$currency->payment_id]->currencies)) {
						$rows[$currency->payment_id]->currencies = [];
					}
					
					$rows[$currency->payment_id]->currencies[] = $currency->currency_id;
				}
			}
		}
		

		foreach ($rows as $option)
		{
			
			if ($basket_currency && !empty($option->currencies)) {
				if (!in_array($basket_currency, $option->currencies)) {
					continue;
				}
			}
			
			$disabled = false;
			
			$optOptions['option.attr'] = 'attributes';
			$attr = array(
				'countries' => $option->countries ? explode(',', $option->countries) : array(),
				'postcodes' => $option->postcodes ? explode('|', $option->postcodes, 2) : array(),
			);
			
			$optOptions['attr'] = 'data-options=\''.json_encode($attr).'\'';
			
			// Create a new option object based on the <option /> element.
			$tmp = JHtml::_(
				'select.option', (string) $option->id, trim((string) $option->name), $optOptions, 'text',
				$disabled
				);

			// Set some option attributes.
			$tmp->class = 'djc_payment_method';
			
			$tmp->price = $option->price;
			$tmp->free_amount = $option->free_amount;
			$tmp->tax_rule_id = $option->tax_rule_id;
			$tmp->image = $option->image;
			$tmp->short_description = $option->short_description;
			$tmp->description = $option->description;
			$tmp->additional_fee = $option->additional_fee;

			// Set some JavaScript option attributes.
			//$tmp->onclick = (string) $option['onclick'];
			//$tmp->onchange = (string) $option['onchange'];

			// Add the option object to the result set.
			$options[] = $tmp;
		}

		reset($options);

		return $options;
	}
}
?>