<?php
/**
 * @package DJ-Catalog2
 * @copyright Copyright (C) DJ-Extensions.com, All rights reserved.
 * @license http://www.gnu.org/licenses GNU/GPL
 * @author url: http://dj-extensions.com
 * @author email contact@dj-extensions.com
 */

defined('_JEXEC') or die();
defined('JPATH_BASE') or die;

jimport('joomla.html.html');
jimport('joomla.form.formfield');

class JFormFieldDjcorderstatus extends JFormField {
	
	protected $type = 'Djcorderstatus';
	
	public function setup(\SimpleXMLElement $element, $value, $group = null)
	{
		$set = parent::setup($element, $value, $group);
		
		if ($set && empty($value)) {
			if (isset($element['default_multiple']) && isset($element['multiple']) && $element['multiple'] != 'false') {
				$this->value = explode(',', $element['default_multiple']);
			}
		}
		
		return $set;
	}
	
	protected function getInput()
	{
		// Initialize some field attributes.
		$size		= $this->element['size'] ? ' size="'.(int) $this->element['size'].'"' : '';
		$maxLength	= $this->element['maxlength'] ? ' maxlength="'.(int) $this->element['maxlength'].'"' : '';
		$attr = '';
		
		$class = $this->element['class'] ? (string) $this->element['class'] : '';
		$class .= $this->element['required']=='true' ? ' required' : '';
		
		$type = isset($this->element['unit_type']) ? $this->element['unit_type'] : false;
		
		$attr .= 'class="'.$class.'"';
		$name = $this->name;
		if (isset($this->element['multiple']) && $this->element['multiple'] == 'true') {
			$attr .= ' multiple="true" size="10"';
		} 
		
		$optionText = (!empty($this->element['option_text'])) ? trim($this->element['option_text']) : 'concat';
		$clause = 'CONCAT(name, " [", status_code, "]") as text';
		if ($optionText == 'name') {
			$clause = 'name as text';
		} else if ($optionText == 'unit') {
			$clause = 'status_code as text';
		}
		
		$db = JFactory::getDbo();
		$query = $db->getQuery(true);
		$query->select('status_code AS value, '.$clause);
		$query->from('#__djc2_order_statuses');
		$query->order('name');
		$db->setQuery($query);
		$statuses = $db->loadObjectList();
		$options = array();
		
		foreach ($statuses as $status) {
			$options[] = JHTML::_('select.option', $status->value, $status->text);
		}
		
		$out = JHtml::_('select.genericlist', $options, $name, trim($attr), 'value', 'text', $this->value, $this->id);
		
		return ($out);
		
	}
}
?>