<?php
/**
 * @package DJ-Catalog2
 * @copyright Copyright (C) DJ-Extensions.com, All rights reserved.
 * @license http://www.gnu.org/licenses GNU/GPL
 * @author url: http://dj-extensions.com
 * @author email contact@dj-extensions.com
 */

defined('_JEXEC') or die();
defined('JPATH_BASE') or die;

jimport('joomla.html.html');
jimport('joomla.form.formfield');

class JFormFieldDJCFieldOptionRule extends JFormFieldSubform {
	
	protected $type = 'DJCFieldOptionRule';
	
	static $fields = null;
	
	static $scriptLoaded = array();
	
	protected function getInput()
	{
		$html = $html2 = $html3 = '';
		
		$fields = static::getDJC2Fields();
		
		$json = json_encode($fields);
		
		$formname = 'form_' . str_replace(array('jform[', '[', ']'), array('', '_', ''), $this->fieldname);
		
		$html .= '<select data-formparentrule="'.$formname.'" class="djc_formparent_rule" onchange="DJC2SetOptionsRule_'.$formname.'(this);" name="'.$this->name.'[field_id][]">';
		$html .= '<option value="">'.JText::_('COM_DJCATALOG2_LIST_PLEASE_SELECT').'</option>';
		
		$html2 .= '<select data-formchildrule="'.$formname.'"  class="djc_formchild_rule" id="'.$this->id.'" name="'.$this->name.'[rule_options][]" multiple="true" size="10">';
		
		$v = $this->value;
		
		foreach($fields as $field) {
			$selected = false;
			
			if (is_object($v) && is_array($v->field_id) && in_array($field->id, $v->field_id)) {
				$selected = true;
				
				if (isset($v->rule_options) && is_object($v->rule_options)) {
					$v->rule_options = JArrayHelper::fromObject($v->rule_options);
				}
				
				if (isset($v->rule_text) && is_object($v->rule_text)) {
					$v->rule_text = $v->rule_text;
				}
				
			}
			
			foreach($field->options as $option) {
				$optSelected = false;
				
				if ($selected && is_array($v->rule_options) && in_array($option->id, $v->rule_options)) {
					$optSelected = true;
				}
				
				$html2 .= '<option value="'.$option->id.'" data-fieldid="'.$field->id.'" '.($optSelected ? 'selected="selected"' : '' ).'>'.$option->value.'</option>';
			}
			
			$html .= '<option value="'.$field->id.'" '.($selected ? 'selected="selected"' : '' ).'>'.$field->name.'</option>';
		}
		$html2 .= '</select>';
		
		$html2 .= '<input data-formchildrule="'.$formname.'" placeholder="'.JText::_('COM_DJCATALOG2_ENTER_SOME_TEXT_PH').'" type="text" name="'.$this->name.'[rule_text]" value="'.(!empty($v->rule_text) ? htmlspecialchars($v->rule_text, ENT_COMPAT) : '').'" class="input" />';
		
		$html .= '</select>';
		
		
		$html3 .= '<select name="'.$this->name.'[operator]" data-operatorrule="'.$formname.'" >';
		$html3 .= '<option value="eq" '.($v->operator == 'eq' ? 'selected="selected"' : '').'>==</option>';
		$html3 .= '<option value="not" '.($v->operator == 'not' ? 'selected="selected"' : '').'>&lt;&gt;</option>';
		$html3 .= '<option value="lt" '.($v->operator == 'lt' ? 'selected="selected"' : '').'>&lt;</option>';
		$html3 .= '<option value="lte" '.($v->operator == 'lte' ? 'selected="selected"' : '').'>&lt;=</option>';
		$html3 .= '<option value="gt" '.($v->operator == 'gt' ? 'selected="selected"' : '').'>&gt;</option>';
		$html3 .= '<option value="gte" '.($v->operator == 'gte' ? 'selected="selected"' : '').'>=&gt;</option>';
		$html3 .= '<option value="contains">'.JText::_('COM_DJCATALOG2_CONTAINS').'</option>';
		$html3 .= '</select>';
		
		if (!isset(static::$scriptLoaded[$formname])) {
			$script = '
			jQuery(document).ready(function(){
				window.DJC2SetOptionsRule_' . $formname.' = function(elem) {
					var formname = "'.$formname.'";
					var $this = jQuery(elem);
					var parents = jQuery(\'select[data-formparentrule="'.$formname.'"]\');
					var children = jQuery(\'select[data-formchildrule="'.$formname.'"]\');
					var target;
					var operator = $this.siblings(\'select[data-operatorrule="'.$formname.'"]\');

					if (parents.length < 1 || children.length < 1) return;
					var counter = 0;
					parents.each(function(){
						if ($this.is(jQuery(this))) {
							target = children.get(counter);
							var field_id = $this.val();
							if (!field_id || target.length < 1) return;
							jQuery(target).find("option").each(function(i,e){
								var ee = jQuery(e);
								if (jQuery(ee).attr("data-fieldid") == field_id) {
									ee.css("display", "");
									ee.removeAttr("disabled");
								} else {
									ee.css("display", "none");
									ee.attr("disabled", "disabled");
									ee.removeAttr("selected");
								}
							});
							jQuery(target).trigger("liszt:updated");
						}
						counter++;
					});
						
					operator.change(function(){
						var value = jQuery(this).val();
						var fieldOptions = jQuery("#" + jQuery(target).attr("id") + "_chzn");
						var fieldCriteria = jQuery(target).siblings("input[data-formchildrule]");
						if (value == "eq" || value == "not") {
							fieldOptions.show();
							fieldCriteria.hide();
						} else {
							fieldCriteria.show();
							fieldOptions.hide();
						}
					});

					jQuery(operator).trigger("change");
					jQuery(operator).trigger("liszt:updated");
				}
						
				jQuery(\'select[data-formparentrule="'.$formname.'"]\').each(function(i,e){
					DJC2SetOptionsRule_' . $formname.'(e);
				});
						
				jQuery(document).on("subform-row-add", function(event, row){
					jQuery(\'select[data-formparentrule="'.$formname.'"]\').each(function(i,e){
						DJC2SetOptionsRule_' . $formname.'(e);
					});
				})
						
			});
			';
			
			JFactory::getDocument()->addScriptDeclaration($script);
			static::$scriptLoaded[$formname] = true;
		}
		
		return $html . $html3 . $html2;
		
	}
		
	protected static function getDJC2Fields() {
		if (is_null(static::$fields)) {
			$db = JFactory::getDbo();
			$query = $db->getQuery(true);
			$query->select('o.*, f.name as field_name');
			$query->from('#__djc2_items_extra_fields_options AS o');
			$query->join('INNER', '#__djc2_items_extra_fields AS f ON f.id = o.field_id');
			$query->order('f.ordering, o.ordering');
			$query->where('f.cart_variant=2');
			$db->setQuery($query);
			
			$fields = array();
			
			$rows = $db->loadObjectList();
			foreach($rows as $row) {
				$field = new stdClass();
				if (isset($fields[$row->field_id])) {
					$field = $fields[$row->field_id];
				} else {
					$field->id = $row->field_id;
					$field->name = $row->field_name;
					$field->options = array();
				}
				
				$field->options[] = $row;
				
				$fields[$row->field_id] = $field;
			}
			static::$fields = $fields;
		}
		
		return static::$fields;
	}
}
?>