<?php
/**
 * @package DJ-Catalog2
 * @copyright Copyright (C) DJ-Extensions.com, All rights reserved.
 * @license http://www.gnu.org/licenses GNU/GPL
 * @author url: http://dj-extensions.com
 * @author email contact@dj-extensions.com
 */

defined('_JEXEC') or die();
defined('JPATH_BASE') or die;

jimport('joomla.html.html');
jimport('joomla.form.formfield');

class JFormFieldDJCFieldOption extends JFormFieldSubform {
	
	protected $type = 'DJCFieldOption';
	
	static $fields = null;
	
	static $scriptLoaded = array();
	
	protected function getInput()
	{
		$html = $html2 = '';
		
		$fields = static::getDJC2Fields();
		
		$json = json_encode($fields);
		
		$follow_filter = (bool)(isset($this->element['follow_filters']) && $this->element['follow_filters'] == 'true');
		
		$formname = 'form_' . str_replace(array('jform[', '[', ']'), array('', '_', ''), $this->fieldname);
		
		$html .= '<select data-formparent="'.$formname.'" class="djc_formparent" onchange="DJC2SetOptions_'.$formname.'(this);">';
		$html .= '<option value="">'.JText::_('COM_DJCATALOG2_LIST_PLEASE_SELECT').'</option>';
		
		$html2 .= '<select data-formchild="'.$formname.'"  class="djc_formchild" id="'.$this->id.'" name="'.$this->name.'[]" multiple="true" size="10">';
		
		
		$value = is_array($this->value) ? $this->value : array($this->value);
		$this->value = $value;
		
		foreach($fields as $field) {
			$selected = false;
			
			foreach($field->options as $option) {
				$optSelected = false;
				if (in_array($option->id, $value)) {
					$selected = $optSelected = true;
				}
				$html2 .= '<option value="'.$option->id.'"  data-fieldid="'.$field->id.'" '.($optSelected ? 'selected="selected"' : '' ).'>'.$option->value.'</option>';
			}
			
			$attr = 'data-multiple="true"';
			if ($follow_filter && $field->filter_type != 'checkbox_or') {
				$attr = 'data-multiple="false"';
			}
			
			$html .= '<option value="'.$field->id.'" '.$attr.' '.($selected ? 'selected="selected"' : '' ).'>'.$field->name.'</option>';
		}
		$html2 .= '</select>';
		$html .= '</select>';
		
		if (!isset(static::$scriptLoaded[$formname])) {
			$script = '
			jQuery(document).ready(function(){
				window.DJC2SetOptions_' . $formname.' = function(elem) {
					var formname = "'.$formname.'";
					var $this = jQuery(elem);
					var parents = jQuery(\'select[data-formparent="'.$formname.'"]\');
					var children = jQuery(\'select[data-formchild="'.$formname.'"]\');
						
					if (parents.length < 1 || children.length < 1) return;
					var counter = 0;
					parents.each(function(){
						if ($this.is(jQuery(this))) {
							var target = children.get(counter);
							var field_id = $this.val();
							var is_multiple = $this.find(\':selected\').first().attr(\'data-multiple\') == \'true\';
							if (is_multiple){
								jQuery(target).attr(\'multiple\', \'multiple\');	
							} else {
								jQuery(target).removeAttr(\'multiple\');
							}
							jQuery(target).chosen(\'destroy\');
							//jQuery(target).prop("selectedIndex", -1);
							jQuery(target).chosen();


							if (!field_id || target.length < 1) return;
							jQuery(target).find("option").each(function(i,e){
								var ee = jQuery(e);
								if (jQuery(ee).attr("data-fieldid") == field_id) {
									ee.css("display", "");
									ee.removeAttr("disabled");
								} else {
									ee.css("display", "none");
									ee.attr("disabled", "disabled");
									ee.removeAttr("selected");
								}
							});
							jQuery(target).trigger("liszt:updated");
						}
						counter++;
					});
				}
						
				jQuery(\'select[data-formparent="'.$formname.'"]\').each(function(i,e){
					DJC2SetOptions_' . $formname.'(e);
				});
			});
			';
			
			JFactory::getDocument()->addScriptDeclaration($script);
			
			static::$scriptLoaded[$formname] = true;
		}
		
		return $html . $html2;
		
	}
		
	protected static function getDJC2Fields() {
		if (is_null(static::$fields)) {
			$db = JFactory::getDbo();
			$query = $db->getQuery(true);
			$query->select('o.*, f.name as field_name, f.type as field_type, f.filter_type');
			$query->from('#__djc2_items_extra_fields_options AS o');
			$query->join('INNER', '#__djc2_items_extra_fields AS f ON f.id = o.field_id');
			$query->order('f.ordering, o.ordering');
			$db->setQuery($query);
			
			$fields = array();
			
			$rows = $db->loadObjectList();
			foreach($rows as $row) {
				$field = new stdClass();
				if (isset($fields[$row->field_id])) {
					$field = $fields[$row->field_id];
				} else {
					$field->id = $row->field_id;
					$field->name = $row->field_name;
					$field->type = $row->field_type;
					$field->filter_type = $row->filter_type;
					$field->options = array();
				}
				
				$field->options[] = $row;
				
				$fields[$row->field_id] = $field;
			}
			static::$fields = $fields;
		}
		
		return static::$fields;
	}
}
?>