<?php
/**
 * @package DJ-Catalog2
 * @copyright Copyright (C) DJ-Extensions.com, All rights reserved.
 * @license http://www.gnu.org/licenses GNU/GPL
 * @author url: http://dj-extensions.com
 * @author email contact@dj-extensions.com
 */

defined('_JEXEC') or die();
defined('JPATH_BASE') or die;

jimport('joomla.html.html');
jimport('joomla.form.formfield');

JFormHelper::loadFieldClass('list');

class JFormFieldDJCCustomerGroup extends JFormFieldList {
	
	protected $type = 'DJCCustomerGroup';
	
	protected function getOptions()
	{
		$allowed = isset($this->element['visible-groups']) ? (string)$this->element['visible-groups'] : false;
		$header = isset($this->element['header']) ? (string)$this->element['header'] : false;
		
		$db = JFactory::getDbo();
		$query = $db->getQuery(true);
		$query->select('id as value, name as text');
		$query->from('#__djc2_customer_groups');
		if ($allowed) {
			$query->where('id IN ('.$allowed.')');
		}
		$query->order('is_default DESC, ordering ASC');
		$db->setQuery($query);
		$rows = $db->loadObjectList();
		
		if (!empty($header) && count($rows))
		{
			$headerObj = new stdClass();
			$headerObj->value = '';
			$headerObj->text = JText::_($header);
			
			array_unshift($rows, $headerObj);
		}
		
		return $rows;
	}
}
?>