<?php
/**
 * @package DJ-Catalog2
 * @copyright Copyright (C) DJ-Extensions.com, All rights reserved.
 * @license http://www.gnu.org/licenses GNU/GPL
 * @author url: http://dj-extensions.com
 * @author email contact@dj-extensions.com
 */

use Joomla\CMS\Language\LanguageHelper;

defined('_JEXEC') or die();
defined('JPATH_BASE') or die;

jimport('joomla.html.html');
jimport('joomla.form.formfield');


class JFormFieldDJCategoryModal extends JFormField {
	
	protected $type = 'DJCategoryModal';
	
	protected function getInput()
	{
		$allowClear     = ((string) $this->element['clear'] != 'false');
		$allowSelect    = ((string) $this->element['select'] != 'false');
		
		// The active article id field.
		$value = (int) $this->value > 0 ? (int) $this->value : '';
		
		// Create the modal id.
		$modalId = 'Category_' . $this->id;
		
		// Add the modal field script to the document head.
		JHtml::_('jquery.framework');
		JHtml::_('script', 'system/modal-fields.js', array('version' => 'auto', 'relative' => true));
		
		// Script to proxy the select modal function to the modal-fields.js file.
		if ($allowSelect)
		{
			static $scriptSelect = null;
			
			if (is_null($scriptSelect))
			{
				$scriptSelect = array();
			}
			
			if (!isset($scriptSelect[$this->id]))
			{
				JFactory::getDocument()->addScriptDeclaration("
				function jSelectDJCatalog2Category_" . $this->id . "(id, title) {
					window.processModalSelect('Category', '" . $this->id . "', id, title);
				}
				");
				
				JText::script('JGLOBAL_ASSOCIATIONS_PROPAGATE_FAILED');
				
				$scriptSelect[$this->id] = true;
			}
		}
		
		// Setup variables for display.
		$linkArticles = 'index.php?option=com_djcatalog2&amp;view=categories&amp;layout=modal&amp;tmpl=component&amp;' . JSession::getFormToken() . '=1';
		$linkArticle  = 'index.php?option=com_djcatalog2&amp;view=categories&amp;layout=modal&amp;tmpl=component&amp;' . JSession::getFormToken() . '=1';
		
		if (isset($this->element['language']))
		{
			$linkArticles .= '&amp;forcedLanguage=' . $this->element['language'];
			$linkArticle  .= '&amp;forcedLanguage=' . $this->element['language'];
			$modalTitle    = JText::_('COM_DJCATALOG2_CHANGE_CATEGORY') . ' &#8212; ' . $this->element['label'];
		}
		else
		{
			$modalTitle    = JText::_('COM_DJCATALOG2_CHANGE_CATEGORY');
		}
		
		$urlSelect = $linkArticles . '&amp;function=jSelectDJCatalog2Category_' . $this->id;
		
		if ((int) $this->value > 0)
		{
			$db	= JFactory::getDbo();
			$query = $db->getQuery(true)
			->select($db->quoteName('name'))
			->from($db->quoteName('#__djc2_categories'))
			->where($db->quoteName('id') . ' = ' . (int) $this->value);
			$db->setQuery($query);
			
			try
			{
				$title = $db->loadResult();
			}
			catch (RuntimeException $e)
			{
				JError::raiseWarning(500, $e->getMessage());
			}
		}
		
		$title = empty($title) ? JText::_('COM_DJCATALOG2_SELECT_CATEGORY') : htmlspecialchars($title, ENT_QUOTES, 'UTF-8');
		
		// The current article display field.
		$html  = '<span class="input-append">';
		$html .= '<input class="input-medium" id="' . $this->id . '_name" type="text" value="' . $title . '" disabled="disabled" size="35" />';
		
		// Select article button
		if ($allowSelect)
		{
			$html .= '<button'
				. ' type="button"'
					. ' class="btn hasTooltip' . ($value ? ' hidden' : '') . '"'
						. ' id="' . $this->id . '_select"'
							. ' data-toggle="modal"'
								. ' data-target="#ModalSelect' . $modalId . '"'
									. ' title="' . JHtml::tooltipText('COM_DJCATALOG2_CHANGE_CATEGORY') . '">'
										. '<span class="icon-file" aria-hidden="true"></span> ' . JText::_('JSELECT')
										. '</button>';
		}
		
		// Clear article button
		if ($allowClear)
		{
			$html .= '<button'
				. ' type="button"'
					. ' class="btn' . ($value ? '' : ' hidden') . '"'
						. ' id="' . $this->id . '_clear"'
							. ' onclick="window.processModalParent(\'' . $this->id . '\'); return false;">'
								. '<span class="icon-remove" aria-hidden="true"></span>' . JText::_('JCLEAR')
								. '</button>';
		}
		
		
		$html .= '</span>';
		
		// Select article modal
		if ($allowSelect)
		{
			$html .= JHtml::_(
				'bootstrap.renderModal',
				'ModalSelect' . $modalId,
				array(
					'title'       => $modalTitle,
					'url'         => $urlSelect,
					'height'      => '400px',
					'width'       => '800px',
					'bodyHeight'  => '70',
					'modalWidth'  => '80',
					'footer'      => '<button type="button" class="btn" data-dismiss="modal">' . JText::_('JLIB_HTML_BEHAVIOR_CLOSE') . '</button>',
				)
				);
		}
		
		// Note: class='required' for client side validation.
		$class = $this->required ? ' class="required modal-value"' : '';
		
		$html .= '<input type="hidden" id="' . $this->id . '_id" ' . $class . ' data-required="' . (int) $this->required . '" name="' . $this->name
		. '" data-text="' . htmlspecialchars(JText::_('COM_DJCATALOG2_SELECT_CATEGORY'), ENT_COMPAT, 'UTF-8') . '" value="' . $value . '" />';
		
		return $html;
	}
	
	/**
	 * Method to get the field label markup.
	 *
	 * @return  string  The field label markup.
	 *
	 * @since   3.4
	 */
	protected function getLabel()
	{
		return str_replace($this->id, $this->id . '_id', parent::getLabel());
	}
}
?>
